/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceListImpl
extends JavaStubPsiElement<PsiClassReferenceListStub>
implements PsiReferenceList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiReferenceListImpl");

    public PsiReferenceListImpl(PsiClassReferenceListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public PsiReferenceListImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = (PsiJavaCodeReferenceElement[])this.calcTreeElement().getChildrenAsPsiElements(JavaElementType.JAVA_CODE_REFERENCE, PsiJavaCodeReferenceElement.ARRAY_FACTORY);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiReferenceListImpl", "getReferenceElements"));
        }
        return psiJavaCodeReferenceElementArray;
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassReferenceListStub stub = (PsiClassReferenceListStub)this.getStub();
        if (stub != null) {
            PsiClassType[] psiClassTypeArray = stub.getReferencedTypes();
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiReferenceListImpl", "getReferencedTypes"));
            }
            return psiClassTypeArray;
        }
        PsiJavaCodeReferenceElement[] refs = this.getReferenceElements();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        PsiClassType[] types = new PsiClassType[refs.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = factory.createType(refs[i]);
        }
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiReferenceListImpl", "getReferencedTypes"));
        }
        return types;
    }

    public PsiReferenceList.Role getRole() {
        IStubElementType type = this.getElementType();
        if (type == JavaElementType.EXTENDS_LIST) {
            return PsiReferenceList.Role.EXTENDS_LIST;
        }
        if (type == JavaElementType.IMPLEMENTS_LIST) {
            return PsiReferenceList.Role.IMPLEMENTS_LIST;
        }
        if (type == JavaElementType.THROWS_LIST) {
            return PsiReferenceList.Role.THROWS_LIST;
        }
        if (type == JavaElementType.EXTENDS_BOUND_LIST) {
            return PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
        }
        LOG.error("Unknown element type:" + type);
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiReferenceListImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceList((PsiReferenceList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return this.getElementType() == JavaElementType.EXTENDS_BOUND_LIST ? "PsiElement(EXTENDS_BOUND_LIST)" : "PsiReferenceList";
    }
}

