/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeImpl
implements CodeStyleScheme,
ExternalizableScheme {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemeImpl.class);
    private String myName;
    private Element myRootElement;
    private String myParentSchemeName;
    private final boolean myIsDefault;
    private volatile CodeStyleSettings myCodeStyleSettings;
    private final ExternalInfo myExternalInfo;

    public CodeStyleSchemeImpl(@NotNull String name, String parentSchemeName, Element rootElement) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        this.myExternalInfo = new ExternalInfo();
        this.myName = name;
        this.myRootElement = rootElement;
        this.myIsDefault = false;
        this.myParentSchemeName = parentSchemeName;
    }

    public CodeStyleSchemeImpl(@NotNull String name, boolean isDefault, CodeStyleScheme parentScheme) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        this.myExternalInfo = new ExternalInfo();
        this.myName = name;
        this.myIsDefault = isDefault;
        this.init(parentScheme, null);
    }

    public void init(@NotNull CodeStyleSchemes schemesManager) {
        if (schemesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesManager", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "init"));
        }
        LOG.assertTrue(this.myCodeStyleSettings == null, (Object)"Already initialized");
        this.init(this.myParentSchemeName == null ? null : schemesManager.findSchemeByName(this.myParentSchemeName), this.myRootElement);
        this.myParentSchemeName = null;
        this.myRootElement = null;
    }

    private void init(@Nullable CodeStyleScheme parentScheme, Element root) {
        if (parentScheme == null) {
            this.myCodeStyleSettings = new CodeStyleSettings();
        } else {
            CodeStyleSettings parentSettings = parentScheme.getCodeStyleSettings();
            this.myCodeStyleSettings = parentSettings.clone();
            while (parentSettings.getParentSettings() != null) {
                parentSettings = parentSettings.getParentSettings();
            }
            this.myCodeStyleSettings.setParentSettings(parentSettings);
        }
        if (root != null) {
            try {
                this.readExternal(root);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public CodeStyleSettings getCodeStyleSettings() {
        return this.myCodeStyleSettings;
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "setCodeStyleSettings"));
        }
        this.myCodeStyleSettings = codeStyleSettings;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "getName"));
        }
        return string;
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    public String toString() {
        return this.getName();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myCodeStyleSettings.writeExternal(element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myCodeStyleSettings.readExternal(element);
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "setName"));
        }
        this.myName = name;
    }

    @NotNull
    public ExternalInfo getExternalInfo() {
        ExternalInfo externalInfo = this.myExternalInfo;
        if (externalInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "getExternalInfo"));
        }
        return externalInfo;
    }
}

