/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;

public class SubtypingConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance((String)("#" + SubtypingConstraint.class.getName()));
    private PsiType myS;
    private PsiType myT;

    public SubtypingConstraint(PsiType t, PsiType s) {
        this.myT = t;
        this.myS = s;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtypingConstraint that = (SubtypingConstraint)o;
        if (this.myS instanceof PsiCapturedWildcardType && this.myS != that.myS) {
            return false;
        }
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result = this.myS != null ? this.myS.hashCode() : 0;
        result = 31 * result + (this.myT != null ? this.myT.hashCode() : 0);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        if (this.myT instanceof PsiWildcardType) {
            PsiType tBound = ((PsiWildcardType)this.myT).getBound();
            if (tBound == null) {
                return true;
            }
            if (tBound instanceof PsiCapturedWildcardType) {
                PsiType psiType = tBound = ((PsiWildcardType)this.myT).isExtends() ? ((PsiCapturedWildcardType)tBound).getUpperBound() : ((PsiCapturedWildcardType)tBound).getLowerBound();
            }
            if (this.myS instanceof PsiCapturedWildcardType) {
                this.myS = ((PsiCapturedWildcardType)this.myS).getWildcard();
            }
            if (((PsiWildcardType)this.myT).isExtends()) {
                if (this.myS instanceof PsiWildcardType) {
                    PsiType sBound = ((PsiWildcardType)this.myS).getBound();
                    if (sBound == null) {
                        constraints.add(new StrictSubtypingConstraint(tBound, ((PsiWildcardType)this.myS).getExtendsBound()));
                        return true;
                    }
                    if (((PsiWildcardType)this.myS).isExtends()) {
                        if (sBound instanceof PsiCapturedWildcardType) {
                            return true;
                        }
                        constraints.add(new StrictSubtypingConstraint(tBound, sBound));
                        return true;
                    }
                    if (((PsiWildcardType)this.myS).isSuper()) {
                        constraints.add(new TypeEqualityConstraint(tBound, (PsiType)PsiType.getJavaLangObject((PsiManager)((PsiWildcardType)this.myT).getManager(), (GlobalSearchScope)this.myT.getResolveScope())));
                        return true;
                    }
                    assert (false);
                    return false;
                }
                constraints.add(new StrictSubtypingConstraint(tBound, this.myS));
                return true;
            }
            LOG.assertTrue(((PsiWildcardType)this.myT).isSuper());
            if (this.myS instanceof PsiWildcardType) {
                PsiType sBound = ((PsiWildcardType)this.myS).getBound();
                if (sBound == null || !((PsiWildcardType)this.myS).isSuper()) return false;
                if (sBound instanceof PsiCapturedWildcardType) {
                    return false;
                }
                constraints.add(new StrictSubtypingConstraint(sBound, tBound));
                return true;
            }
            constraints.add(new StrictSubtypingConstraint(this.myS, tBound));
            return true;
        }
        if (this.myS instanceof PsiWildcardType) {
            return false;
        }
        constraints.add(new TypeEqualityConstraint(this.myT, this.myS));
        return true;
    }

    public String toString() {
        return this.myS.getPresentableText() + " <= " + this.myT.getPresentableText();
    }
}

