/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractInterface.ExtractClassUtil;
import com.intellij.refactoring.extractInterface.ExtractInterfaceDialog;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ExtractInterfaceHandler
implements RefactoringActionHandler,
ElementsHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractInterface.ExtractInterfaceHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.interface.title");
    private Project myProject;
    private PsiClass myClass;
    private String myInterfaceName;
    private MemberInfo[] mySelectedMembers;
    private PsiDirectory myTargetDir;
    private DocCommentPolicy myJavaDocPolicy;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractInterface/ExtractInterfaceHandler", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractInterface");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractInterface/ExtractInterfaceHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/extractInterface/ExtractInterfaceHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        this.myClass = (PsiClass)elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.myClass)) {
            return;
        }
        final ExtractInterfaceDialog dialog = new ExtractInterfaceDialog(this.myProject, this.myClass);
        if (!dialog.showAndGet() || !dialog.isExtractSuperclass()) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        ExtractSuperClassUtil.checkSuperAccessible(dialog.getTargetDirectory(), (MultiMap<PsiElement, String>)conflicts, this.myClass);
        if (!ExtractSuperClassUtil.showConflicts(dialog, (MultiMap<PsiElement, String>)conflicts, this.myProject)) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ExtractInterfaceHandler.this.myInterfaceName = dialog.getExtractedSuperName();
                        ExtractInterfaceHandler.access$102(ExtractInterfaceHandler.this, (MemberInfo[])ArrayUtil.toObjectArray(dialog.getSelectedMemberInfos(), MemberInfo.class));
                        ExtractInterfaceHandler.this.myTargetDir = dialog.getTargetDirectory();
                        ExtractInterfaceHandler.this.myJavaDocPolicy = new DocCommentPolicy(dialog.getDocCommentPolicy());
                        try {
                            ExtractInterfaceHandler.this.doRefactoring();
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, REFACTORING_NAME, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring() throws IncorrectOperationException {
        PsiClass anInterface;
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            anInterface = ExtractInterfaceHandler.extractInterface(this.myTargetDir, this.myClass, this.myInterfaceName, this.mySelectedMembers, this.myJavaDocPolicy);
        }
        finally {
            a.finish();
        }
        if (anInterface != null) {
            final SmartPsiElementPointer classPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myClass);
            final SmartPsiElementPointer interfacePointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)anInterface);
            Runnable turnRefsToSuperRunnable = new Runnable(){

                @Override
                public void run() {
                    ExtractClassUtil.askAndTurnRefsToSuper(ExtractInterfaceHandler.this.myProject, classPointer, interfacePointer);
                }
            };
            SwingUtilities.invokeLater(turnRefsToSuperRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PsiClass extractInterface(PsiDirectory targetDir, PsiClass aClass, String interfaceName, MemberInfo[] selectedMembers, DocCommentPolicy javaDocPolicy) throws IncorrectOperationException {
        ((RefactoringEventListener)aClass.getProject().getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.extractSuper", ExtractSuperClassUtil.createBeforeData(aClass, selectedMembers));
        PsiClass anInterface = JavaDirectoryService.getInstance().createInterface(targetDir, interfaceName);
        try {
            PsiReferenceList referenceList;
            PsiJavaCodeReferenceElement ref = ExtractSuperClassUtil.createExtendingReference(anInterface, aClass, selectedMembers);
            PsiReferenceList psiReferenceList = referenceList = aClass.isInterface() ? aClass.getExtendsList() : aClass.getImplementsList();
            assert (referenceList != null);
            referenceList.add((PsiElement)ref);
            PullUpProcessor pullUpHelper = new PullUpProcessor(aClass, anInterface, selectedMembers, javaDocPolicy);
            pullUpHelper.moveMembersToBase();
            PsiClass psiClass = anInterface;
            return psiClass;
        }
        finally {
            ((RefactoringEventListener)aClass.getProject().getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.extractSuper", ExtractSuperClassUtil.createAfterData(anInterface));
        }
    }

    private String getCommandName() {
        return RefactoringBundle.message((String)"extract.interface.command.name", (Object[])new Object[]{this.myInterfaceName, DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)});
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }

    static /* synthetic */ MemberInfo[] access$102(ExtractInterfaceHandler x0, MemberInfo[] x1) {
        x0.mySelectedMembers = x1;
        return x1;
    }
}

