/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;

public class ReplaceStaticVariableAccess
extends FixableUsageInfo {
    private final PsiReferenceExpression expression;
    private final String delegateClass;
    private final boolean myEnumConstant;
    private static final Logger LOGGER = Logger.getInstance((String)("#" + ReplaceStaticVariableAccess.class.getName()));

    public ReplaceStaticVariableAccess(PsiReferenceExpression expression, String delegateClass, boolean enumConstant) {
        super((PsiElement)expression);
        this.expression = expression;
        this.delegateClass = delegateClass;
        this.myEnumConstant = enumConstant;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiSwitchLabelStatement switchStatement;
        if (this.myEnumConstant && (switchStatement = (PsiSwitchLabelStatement)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiSwitchLabelStatement.class)) != null) {
            MutationUtils.replaceExpression(this.expression.getReferenceName(), (PsiExpression)this.expression);
            return;
        }
        boolean replaceWithGetEnumValue = this.myEnumConstant && !this.alreadyMigratedToEnum();
        String link = replaceWithGetEnumValue ? "." + GenerateMembersUtil.suggestGetterName("value", this.expression.getType(), this.expression.getProject()) + "()" : "";
        MutationUtils.replaceExpression(this.delegateClass + '.' + this.expression.getReferenceName() + link, (PsiExpression)this.expression);
    }

    private boolean alreadyMigratedToEnum() {
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiMethodCallExpression.class);
        if (callExpression != null) {
            PsiElement resolved = callExpression.getMethodExpression().resolve();
            if (resolved instanceof PsiMethod) {
                PsiParameter[] parameters = ((PsiMethod)resolved).getParameterList().getParameters();
                Object[] args = callExpression.getArgumentList().getExpressions();
                int idx = ArrayUtilRt.find((Object[])args, (Object)this.expression);
                if (idx != -1 && parameters[idx].getType().equalsToText(this.delegateClass)) {
                    return true;
                }
            }
        } else {
            PsiReturnStatement returnStatement = (PsiReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiReturnStatement.class);
            if (returnStatement != null) {
                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiMethod.class);
                LOGGER.assertTrue(psiMethod != null);
                PsiType returnType = psiMethod.getReturnType();
                if (returnType != null && returnType.getCanonicalText().equals(this.delegateClass)) {
                    return true;
                }
            } else {
                PsiElement resolve;
                PsiExpression lExpression;
                PsiAssignmentExpression assignmentExpression;
                PsiVariable psiVariable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiVariable.class);
                if (psiVariable != null ? psiVariable.getType().equalsToText(this.delegateClass) : (assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiAssignmentExpression.class)) != null && assignmentExpression.getRExpression() == this.expression && (lExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable && ((PsiVariable)resolve).getType().equalsToText(this.delegateClass)) {
                    return true;
                }
            }
        }
        return false;
    }
}

