/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class JavaVisibilityPanel
extends VisibilityPanelBase<String> {
    private JRadioButton myRbAsIs;
    private JRadioButton myRbEscalate;
    private final JRadioButton myRbPrivate;
    private final JRadioButton myRbProtected;
    private final JRadioButton myRbPackageLocal;
    private final JRadioButton myRbPublic;

    public JavaVisibilityPanel(boolean hasAsIs, boolean hasEscalate) {
        this(hasAsIs, hasEscalate, RefactoringBundle.message((String)"visibility.border.title"));
    }

    public JavaVisibilityPanel(boolean hasAsIs, boolean hasEscalate, String visibilityTitle) {
        this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)visibilityTitle, (boolean)true, (Insets)new Insets(7, 10, 10, 0)));
        this.setLayout(new BoxLayout(this, 1));
        ButtonGroup bg = new ButtonGroup();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ((ChangeListener)JavaVisibilityPanel.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
                }
            }
        };
        if (hasEscalate) {
            this.myRbEscalate = new JRadioButton();
            this.myRbEscalate.setText(RefactoringBundle.getEscalateVisibility());
            this.myRbEscalate.addItemListener(listener);
            this.add(this.myRbEscalate);
            bg.add(this.myRbEscalate);
        }
        if (hasAsIs) {
            this.myRbAsIs = new JRadioButton();
            this.myRbAsIs.setText(RefactoringBundle.getVisibilityAsIs());
            this.myRbAsIs.addItemListener(listener);
            this.add(this.myRbAsIs);
            bg.add(this.myRbAsIs);
        }
        this.myRbPrivate = new JRadioButton();
        this.myRbPrivate.setText(RefactoringBundle.getVisibilityPrivate());
        this.myRbPrivate.addItemListener(listener);
        this.myRbPrivate.setFocusable(false);
        this.add(this.myRbPrivate);
        bg.add(this.myRbPrivate);
        this.myRbPackageLocal = new JRadioButton();
        this.myRbPackageLocal.setText(RefactoringBundle.getVisibilityPackageLocal());
        this.myRbPackageLocal.addItemListener(listener);
        this.myRbPackageLocal.setFocusable(false);
        this.add(this.myRbPackageLocal);
        bg.add(this.myRbPackageLocal);
        this.myRbProtected = new JRadioButton();
        this.myRbProtected.setText(RefactoringBundle.getVisibilityProtected());
        this.myRbProtected.addItemListener(listener);
        this.myRbProtected.setFocusable(false);
        this.add(this.myRbProtected);
        bg.add(this.myRbProtected);
        this.myRbPublic = new JRadioButton();
        this.myRbPublic.setText(RefactoringBundle.getVisibilityPublic());
        this.myRbPublic.addItemListener(listener);
        this.myRbPublic.setFocusable(false);
        this.add(this.myRbPublic);
        bg.add(this.myRbPublic);
    }

    @Override
    @Nullable
    public String getVisibility() {
        if (this.myRbPublic.isSelected()) {
            return "public";
        }
        if (this.myRbPackageLocal.isSelected()) {
            return "packageLocal";
        }
        if (this.myRbProtected.isSelected()) {
            return "protected";
        }
        if (this.myRbPrivate.isSelected()) {
            return "private";
        }
        if (this.myRbEscalate != null && this.myRbEscalate.isSelected()) {
            return "EscalateVisible";
        }
        return null;
    }

    @Override
    public void setVisibility(@Nullable String visibility) {
        if ("public".equals(visibility)) {
            this.myRbPublic.setSelected(true);
        } else if ("protected".equals(visibility)) {
            this.myRbProtected.setSelected(true);
        } else if ("packageLocal".equals(visibility)) {
            this.myRbPackageLocal.setSelected(true);
        } else if ("private".equals(visibility)) {
            this.myRbPrivate.setSelected(true);
        } else if (this.myRbEscalate != null) {
            this.myRbEscalate.setSelected(true);
        } else if (this.myRbAsIs != null) {
            this.myRbAsIs.setSelected(true);
        }
    }

    public void disableAllButPublic() {
        this.myRbPrivate.setEnabled(false);
        this.myRbProtected.setEnabled(false);
        this.myRbPackageLocal.setEnabled(false);
        if (this.myRbEscalate != null) {
            this.myRbEscalate.setEnabled(false);
        }
        if (this.myRbAsIs != null) {
            this.myRbAsIs.setEnabled(false);
        }
        this.myRbPublic.setEnabled(true);
        this.myRbPublic.setSelected(true);
    }
}

