/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.UnsupportedPatternException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;

class StringToConstraintsTransformer {
    @NonNls
    private static final String P_STR = "(\\w+)\\('(\\w+)\\)";
    private static final Pattern p = Pattern.compile("(\\w+)\\('(\\w+)\\)");
    @NonNls
    private static final String P2_STR = "(\\w+)";
    private static final Pattern p2 = Pattern.compile("(\\w+)");
    @NonNls
    private static final String P3_STR = "(\\w+)\\(( ?(?:[\\\"\\*<>!\\.\\?\\:\\$\\\\\\(\\)\\[\\]\\w\\|\\+ =]*|(?:\\\"[^\\\"]*\\\")) ?)\\)";
    private static final Pattern p3 = Pattern.compile("(\\w+)\\(( ?(?:[\\\"\\*<>!\\.\\?\\:\\$\\\\\\(\\)\\[\\]\\w\\|\\+ =]*|(?:\\\"[^\\\"]*\\\")) ?)\\)");
    @NonNls
    private static final String REF = "ref";
    @NonNls
    private static final String READ = "read";
    @NonNls
    private static final String WRITE = "write";
    @NonNls
    private static final String REGEX = "regex";
    @NonNls
    private static final String REGEXW = "regexw";
    @NonNls
    private static final String EXPRTYPE = "exprtype";
    @NonNls
    private static final String FORMAL = "formal";
    @NonNls
    private static final String SCRIPT = "script";
    @NonNls
    private static final String CONTAINS = "contains";
    @NonNls
    private static final String WITHIN = "within";

    StringToConstraintsTransformer() {
    }

    static void transformOldPattern(MatchOptions options) {
        String pattern = options.getSearchPattern();
        StringBuilder buf = new StringBuilder();
        StringBuilder miscBuffer = null;
        int anonymousTypedVarsCount = 0;
        boolean targetFound = false;
        for (int index = 0; index < pattern.length(); ++index) {
            char ch = pattern.charAt(index);
            if (ch == '\'') {
                int length = pattern.length();
                if (index + 1 < length && pattern.charAt(index + 1) == '\'') {
                    ++index;
                } else if (index + 2 < length && pattern.charAt(index + 2) == '\'') {
                    buf.append(ch);
                    buf.append(pattern.charAt(++index));
                    ch = pattern.charAt(++index);
                } else if (index + 3 < length && pattern.charAt(index + 1) == '\\' && pattern.charAt(index + 3) == '\'') {
                    buf.append(ch);
                    buf.append(pattern.charAt(++index));
                    buf.append(pattern.charAt(++index));
                    ch = pattern.charAt(++index);
                } else if (index + 7 < length && pattern.charAt(index + 1) == '\\' && pattern.charAt(index + 2) == 'u' && pattern.charAt(index + 7) == '\'') {
                    buf.append(ch);
                    buf.append(pattern.charAt(++index));
                    buf.append(pattern.charAt(++index));
                    buf.append(pattern.charAt(++index));
                    buf.append(pattern.charAt(++index));
                    buf.append(pattern.charAt(++index));
                    buf.append(pattern.charAt(++index));
                    ch = pattern.charAt(++index);
                } else {
                    buf.append("$");
                    if (miscBuffer == null) {
                        miscBuffer = new StringBuilder();
                    } else {
                        miscBuffer.setLength(0);
                    }
                    ++index;
                    while (index < length && Character.isJavaIdentifierPart(ch = pattern.charAt(index))) {
                        miscBuffer.append(ch);
                        buf.append(ch);
                        ++index;
                    }
                    boolean anonymous = false;
                    if (miscBuffer.length() == 0) {
                        throw new MalformedPatternException(SSRBundle.message("error.expected.character", new Object[0]));
                    }
                    if (miscBuffer.charAt(0) == '_') {
                        anonymous = true;
                        if (miscBuffer.length() == 1) {
                            miscBuffer.append(++anonymousTypedVarsCount);
                            buf.append(anonymousTypedVarsCount);
                        } else {
                            buf.deleteCharAt(buf.length() - miscBuffer.length());
                            miscBuffer.deleteCharAt(0);
                        }
                    }
                    buf.append("$");
                    String typedVar = miscBuffer.toString();
                    int minOccurs = 1;
                    int maxOccurs = 1;
                    boolean greedy = true;
                    MatchVariableConstraint constraint = options.getVariableConstraint(typedVar);
                    boolean constraintCreated = false;
                    if (constraint == null) {
                        constraint = new MatchVariableConstraint();
                        constraint.setName(typedVar);
                        constraintCreated = true;
                    }
                    if (index < length) {
                        char possibleQuantifier = pattern.charAt(index);
                        if (possibleQuantifier == '+') {
                            maxOccurs = Integer.MAX_VALUE;
                            ++index;
                        } else if (possibleQuantifier == '?') {
                            minOccurs = 0;
                            ++index;
                        } else if (possibleQuantifier == '*') {
                            minOccurs = 0;
                            maxOccurs = Integer.MAX_VALUE;
                            ++index;
                        } else if (possibleQuantifier == '{') {
                            ++index;
                            minOccurs = 0;
                            while (index < length && (ch = pattern.charAt(index)) >= '0' && ch <= '9') {
                                minOccurs *= 10;
                                if ((minOccurs += ch - 48) < 0) {
                                    throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                                }
                                ++index;
                            }
                            if (ch == ',') {
                                ++index;
                                maxOccurs = 0;
                                while (index < length && (ch = pattern.charAt(index)) >= '0' && ch <= '9') {
                                    maxOccurs *= 10;
                                    if ((maxOccurs += ch - 48) < 0) {
                                        throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                                    }
                                    ++index;
                                }
                            } else {
                                maxOccurs = Integer.MAX_VALUE;
                            }
                            if (ch != '}') {
                                if (maxOccurs == Integer.MAX_VALUE) {
                                    throw new MalformedPatternException(SSRBundle.message("error.expected.brace1", new Object[0]));
                                }
                                throw new MalformedPatternException(SSRBundle.message("error.expected.brace2", new Object[0]));
                            }
                            ++index;
                        }
                        if (index < length && (ch = pattern.charAt(index)) == '?') {
                            greedy = false;
                            ++index;
                        }
                    }
                    if (constraintCreated) {
                        constraint.setMinCount(minOccurs);
                        constraint.setMaxCount(maxOccurs);
                        constraint.setGreedy(greedy);
                        constraint.setPartOfSearchResults(!anonymous);
                        if (targetFound && !anonymous) {
                            throw new MalformedPatternException("Pattern may have only one target");
                        }
                        boolean bl = targetFound = !anonymous;
                    }
                    if (index < length && pattern.charAt(index) == ':') {
                        if (++index >= length) {
                            throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(':')));
                        }
                        ch = pattern.charAt(index);
                        if (ch == ':') {
                            buf.append(ch);
                        } else {
                            index = StringToConstraintsTransformer.eatTypedVarCondition(index, pattern, miscBuffer, constraint);
                        }
                    }
                    if (constraintCreated) {
                        if (constraint.getWithinConstraint().length() > 0) {
                            constraint.setName("__context__");
                        }
                        options.addVariableConstraint(constraint);
                    }
                    if (index == length) break;
                    ch = pattern.charAt(index);
                }
            }
            buf.append(ch);
        }
        options.setSearchPattern(buf.toString());
    }

    private static int eatTypedVarCondition(int index, String pattern, StringBuilder miscBuffer, MatchVariableConstraint constraint) {
        int length = pattern.length();
        char ch = pattern.charAt(index);
        if (ch == '+' || ch == '*') {
            switch (ch) {
                case '+': {
                    constraint.setStrictlyWithinHierarchy(true);
                    break;
                }
                case '*': {
                    constraint.setWithinHierarchy(true);
                }
            }
            if (++index >= length) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(ch)));
            }
            ch = pattern.charAt(index);
        }
        if (ch == '[') {
            miscBuffer.setLength(0);
            ++index;
            while (index < length && ((ch = pattern.charAt(index)) != ']' || pattern.charAt(index - 1) == '\\')) {
                if (ch == '\"') {
                    miscBuffer.append(ch);
                    ++index;
                    while (index < length && (ch = pattern.charAt(index)) != '\"') {
                        if (ch == '\\') {
                            if (++index >= length) break;
                            ch = pattern.charAt(index);
                        }
                        miscBuffer.append(ch);
                        ++index;
                    }
                    if (ch != '\"') {
                        throw new MalformedPatternException(SSRBundle.message("error.expected.end.quote", new Object[0]));
                    }
                }
                miscBuffer.append(ch);
                ++index;
            }
            if (ch != ']') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition.or.bracket", new Object[0]));
            }
            ++index;
            StringToConstraintsTransformer.parseCondition(constraint, miscBuffer.toString());
        } else {
            miscBuffer.setLength(0);
            index = StringToConstraintsTransformer.handleRegExp(index, pattern, miscBuffer, constraint);
        }
        return index;
    }

    private static int handleRegExp(int index, String pattern, StringBuilder miscBuffer, MatchVariableConstraint constraint) {
        char ch;
        char c = pattern.charAt(index - 1);
        int length = pattern.length();
        while (index < length && !Character.isWhitespace(ch = pattern.charAt(index))) {
            miscBuffer.append(ch);
            ++index;
        }
        if (miscBuffer.length() == 0) {
            if (c == ':') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(c)));
            }
            return index;
        }
        String regexp = miscBuffer.toString();
        if (constraint.getRegExp() != null && constraint.getRegExp().length() > 0 && !constraint.getRegExp().equals(regexp)) {
            throw new MalformedPatternException(SSRBundle.message("error.two.different.type.constraints", new Object[0]));
        }
        try {
            Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            throw new MalformedPatternException(SSRBundle.message("invalid.regular.expression", new Object[0]));
        }
        constraint.setRegExp(regexp);
        return index;
    }

    private static void parseCondition(MatchVariableConstraint constraint, String condition) {
        if (condition.isEmpty()) {
            throw new MalformedPatternException(SSRBundle.message("error.expected.condition", "["));
        }
        List tokens = StringUtil.split((String)condition, (String)"&&", (boolean)true, (boolean)false);
        for (String token : tokens) {
            String option;
            Matcher m;
            if ((token = token.trim()).isEmpty()) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", "&&"));
            }
            boolean hasNot = false;
            boolean consumed = false;
            if (StringUtil.startsWithChar((CharSequence)token, (char)'!')) {
                if ((token = token.substring(1)).isEmpty()) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.condition", "!"));
                }
                hasNot = true;
            }
            if ((m = p.matcher(token)).matches()) {
                option = m.group(1);
                if (option.equalsIgnoreCase(REF)) {
                    String name = m.group(2);
                    constraint.setReference(true);
                    constraint.setInvertReference(hasNot);
                    constraint.setNameOfReferenceVar(name);
                    consumed = true;
                }
            } else {
                m = p2.matcher(token);
                if (m.matches()) {
                    option = m.group(1);
                    if (option.equalsIgnoreCase(READ)) {
                        constraint.setReadAccess(true);
                        constraint.setInvertReadAccess(hasNot);
                        consumed = true;
                    } else if (option.equalsIgnoreCase(WRITE)) {
                        constraint.setWriteAccess(true);
                        constraint.setInvertWriteAccess(hasNot);
                        consumed = true;
                    }
                } else {
                    m = p3.matcher(token);
                    if (m.matches()) {
                        String script;
                        String exprTypePattern;
                        option = m.group(1);
                        if (option.equalsIgnoreCase(REGEX) || option.equalsIgnoreCase(REGEXW)) {
                            String typePattern = StringToConstraintsTransformer.getSingleParameter(m, SSRBundle.message("reg.exp.should.be.delimited.with.spaces.error.message", new Object[0]));
                            if (typePattern.isEmpty()) {
                                throw new MalformedPatternException(SSRBundle.message("no.reg.exp.specified.error.message", new Object[0]));
                            }
                            if (StringUtil.startsWithChar((CharSequence)typePattern, (char)'*')) {
                                typePattern = typePattern.substring(1);
                                constraint.setWithinHierarchy(true);
                            }
                            try {
                                Pattern.compile(typePattern);
                            }
                            catch (PatternSyntaxException e) {
                                throw new MalformedPatternException(SSRBundle.message("invalid.regular.expression", new Object[0]));
                            }
                            constraint.setRegExp(typePattern);
                            constraint.setInvertRegExp(hasNot);
                            consumed = true;
                            if (option.equalsIgnoreCase(REGEXW)) {
                                constraint.setWholeWordsOnly(true);
                            }
                        } else if (option.equalsIgnoreCase(EXPRTYPE)) {
                            exprTypePattern = StringToConstraintsTransformer.getSingleParameter(m, SSRBundle.message("reg.exp.in.expr.type.should.be.delimited.with.spaces.error.message", new Object[0]));
                            if (StringUtil.startsWithChar((CharSequence)exprTypePattern, (char)'*')) {
                                exprTypePattern = exprTypePattern.substring(1);
                                constraint.setExprTypeWithinHierarchy(true);
                            }
                            try {
                                Pattern.compile(exprTypePattern);
                            }
                            catch (PatternSyntaxException e) {
                                throw new MalformedPatternException(SSRBundle.message("invalid.regular.expression", new Object[0]));
                            }
                            constraint.setNameOfExprType(exprTypePattern);
                            constraint.setInvertExprType(hasNot);
                            consumed = true;
                        } else if (option.equalsIgnoreCase(FORMAL)) {
                            exprTypePattern = StringToConstraintsTransformer.getSingleParameter(m, SSRBundle.message("reg.exp.in.formal.arg.type.should.be.delimited.with.spaces.error.message", new Object[0]));
                            if (StringUtil.startsWithChar((CharSequence)exprTypePattern, (char)'*')) {
                                exprTypePattern = exprTypePattern.substring(1);
                                constraint.setFormalArgTypeWithinHierarchy(true);
                            }
                            try {
                                Pattern.compile(exprTypePattern);
                            }
                            catch (PatternSyntaxException e) {
                                throw new MalformedPatternException(SSRBundle.message("invalid.regular.expression", new Object[0]));
                            }
                            constraint.setNameOfFormalArgType(exprTypePattern);
                            constraint.setInvertFormalType(hasNot);
                            consumed = true;
                        } else if (option.equalsIgnoreCase(SCRIPT)) {
                            script = StringToConstraintsTransformer.getSingleParameter(m, SSRBundle.message("script.should.be.delimited.with.spaces.error.message", new Object[0]));
                            constraint.setScriptCodeConstraint(script);
                            consumed = true;
                        } else if (option.equalsIgnoreCase(CONTAINS)) {
                            if (hasNot) {
                                constraint.setInvertContainsConstraint(true);
                            }
                            script = StringToConstraintsTransformer.getSingleParameter(m, SSRBundle.message("script.should.be.delimited.with.spaces.error.message", new Object[0]));
                            constraint.setContainsConstraint(script);
                            consumed = true;
                        } else if (option.equalsIgnoreCase(WITHIN)) {
                            if (hasNot) {
                                constraint.setInvertWithinConstraint(true);
                            }
                            script = StringToConstraintsTransformer.getSingleParameter(m, SSRBundle.message("script.should.be.delimited.with.spaces.error.message", new Object[0]));
                            constraint.setWithinConstraint(script);
                            consumed = true;
                        }
                    }
                }
            }
            if (consumed) continue;
            throw new UnsupportedPatternException(SSRBundle.message("option.is.not.recognized.error.message", token));
        }
    }

    private static String getSingleParameter(Matcher m, String errorMessage) {
        String value = m.group(2);
        if (value.isEmpty()) {
            return value;
        }
        if (value.charAt(0) != ' ' || value.charAt(value.length() - 1) != ' ') {
            throw new MalformedPatternException(errorMessage);
        }
        return value.trim();
    }
}

