/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import com.siyeh.ipp.trivialif.ExpandBooleanPredicate;
import org.jetbrains.annotations.NotNull;

public class ExpandBooleanIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ExpandBooleanPredicate expandBooleanPredicate = new ExpandBooleanPredicate();
        if (expandBooleanPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/trivialif/ExpandBooleanIntention", "getElementPredicate"));
        }
        return expandBooleanPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/trivialif/ExpandBooleanIntention", "processIntention"));
        }
        PsiStatement containingStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (containingStatement == null) {
            return;
        }
        if (ExpandBooleanPredicate.isBooleanAssignment(containingStatement)) {
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)containingStatement;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (rhs == null) {
                return;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (ErrorUtil.containsDeepError((PsiElement)lhs) || ErrorUtil.containsDeepError((PsiElement)rhs)) {
                return;
            }
            String rhsText = rhs.getText();
            String lhsText = lhs.getText();
            PsiJavaToken sign = assignmentExpression.getOperationSign();
            String signText = sign.getText();
            String conditionText = signText.length() == 2 ? lhsText + signText.charAt(0) + rhsText : rhsText;
            String statement = "if(" + conditionText + ") " + lhsText + " = true; else " + lhsText + " = false;";
            PsiReplacementUtil.replaceStatement(containingStatement, statement);
        } else if (ExpandBooleanPredicate.isBooleanReturn(containingStatement)) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)containingStatement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            if (ErrorUtil.containsDeepError((PsiElement)returnValue)) {
                return;
            }
            String valueText = returnValue.getText();
            String statement = "if(" + valueText + ") return true; else return false;";
            PsiReplacementUtil.replaceStatement(containingStatement, statement);
        } else if (ExpandBooleanPredicate.isBooleanDeclaration(containingStatement)) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)containingStatement;
            PsiElement declaredElement = declarationStatement.getDeclaredElements()[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            String name = variable.getName();
            String newStatementText = "if(" + initializer.getText() + ") " + name + "=true; else " + name + "=false;";
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)containingStatement.getProject());
            PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)containingStatement);
            declarationStatement.getParent().addAfter((PsiElement)newStatement, (PsiElement)declarationStatement);
            initializer.delete();
        }
    }
}

