/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.JUnit4ReflectionUtil;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

class SMTestSender
extends RunListener {
    private static final String JUNIT_FRAMEWORK_COMPARISON_NAME = (class$junit$framework$ComparisonFailure == null ? (class$junit$framework$ComparisonFailure = SMTestSender.class$("junit.framework.ComparisonFailure")) : class$junit$framework$ComparisonFailure).getName();
    private static final String ORG_JUNIT_COMPARISON_NAME = "org.junit.ComparisonFailure";
    private String myCurrentClassName;
    static /* synthetic */ Class class$junit$framework$ComparisonFailure;
    static /* synthetic */ Class class$org$junit$Ignore;

    SMTestSender() {
    }

    public void testRunStarted(Description description) throws Exception {
        this.myCurrentClassName = description.toString();
        System.out.println("##teamcity[testSuiteStarted name ='" + this.myCurrentClassName + "']");
    }

    public void testRunFinished(Result result) throws Exception {
        if (this.myCurrentClassName != null) {
            System.out.println("##teamcity[testSuiteFinished name='" + this.myCurrentClassName + "']");
        }
    }

    public void testStarted(Description description) throws Exception {
        System.out.println("##teamcity[testStarted name='" + JUnit4ReflectionUtil.getMethodName(description) + "']");
    }

    public void testFinished(Description description) throws Exception {
        System.out.println("##teamcity[testFinished name='" + JUnit4ReflectionUtil.getMethodName(description) + "']");
    }

    public void testFailure(Failure failure) throws Exception {
        String failureMessage = failure.getMessage();
        String trace = failure.getTrace();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", JUnit4ReflectionUtil.getMethodName(failure.getDescription()));
        attrs.put("message", failureMessage != null ? failureMessage : "");
        ComparisonFailureData notification = SMTestSender.createExceptionNotification(failure.getException());
        if (notification != null) {
            attrs.put("expected", notification.getExpected());
            attrs.put("actual", notification.getActual());
            int failureIdx = trace.indexOf(failureMessage);
            attrs.put("details", failureIdx > -1 ? trace.substring(failureIdx + failureMessage.length()) : trace);
        } else {
            attrs.put("details", trace);
            attrs.put("error", "true");
        }
        System.out.println(ServiceMessage.asString((String)"testFailed", attrs));
    }

    public void testAssumptionFailure(Failure failure) {
        SMTestSender.prepareIgnoreMessage(failure.getDescription(), false);
    }

    public synchronized void testIgnored(Description description) throws Exception {
        SMTestSender.prepareIgnoreMessage(description, true);
    }

    private static void prepareIgnoreMessage(Description description, boolean commentMessage) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (commentMessage) {
            try {
                String val;
                Ignore ignoredAnnotation = (Ignore)description.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = SMTestSender.class$("org.junit.Ignore")) : class$org$junit$Ignore);
                if (ignoredAnnotation != null && (val = ignoredAnnotation.value()) != null) {
                    attrs.put("message", val);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        attrs.put("name", JUnit4ReflectionUtil.getMethodName(description));
        System.out.println(ServiceMessage.asString((String)"testIgnored", attrs));
    }

    private static boolean isComparisonFailure(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        return SMTestSender.isComparisonFailure(throwable.getClass());
    }

    private static boolean isComparisonFailure(Class aClass) {
        if (aClass == null) {
            return false;
        }
        String throwableClassName = aClass.getName();
        if (throwableClassName.equals(JUNIT_FRAMEWORK_COMPARISON_NAME) || throwableClassName.equals(ORG_JUNIT_COMPARISON_NAME)) {
            return true;
        }
        return SMTestSender.isComparisonFailure(aClass.getSuperclass());
    }

    private static ComparisonFailureData createExceptionNotification(Throwable assertion) {
        String message;
        if (SMTestSender.isComparisonFailure(assertion)) {
            return ComparisonFailureData.create((Throwable)assertion);
        }
        Throwable cause = assertion.getCause();
        if (SMTestSender.isComparisonFailure(cause)) {
            try {
                return ComparisonFailureData.create((Throwable)assertion);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        if ((message = assertion.getMessage()) != null) {
            ComparisonFailureData notification = SMTestSender.createExceptionNotification(message, "\nExpected: is \"(.*)\"\n\\s*got: \"(.*)\"\n");
            if (notification == null) {
                notification = SMTestSender.createExceptionNotification(message, "\nExpected: is \"(.*)\"\n\\s*but: was \"(.*)\"");
            }
            if (notification == null) {
                notification = SMTestSender.createExceptionNotification(message, "\nExpected: (.*)\n\\s*got: (.*)");
            }
            if (notification == null) {
                notification = SMTestSender.createExceptionNotification(message, "\\s*expected same:<(.*)> was not:<(.*)>");
            }
            if (notification == null) {
                notification = SMTestSender.createExceptionNotification(message, "\\s*expected:<(.*)> but was:<(.*)>");
            }
            if (notification == null) {
                notification = SMTestSender.createExceptionNotification(message, "\nExpected: \"(.*)\"\n\\s*but: was \"(.*)\"");
            }
            if (notification != null) {
                return notification;
            }
        }
        return null;
    }

    private static ComparisonFailureData createExceptionNotification(String message, String regex) {
        Matcher matcher = Pattern.compile(regex, 34).matcher(message);
        if (matcher.matches()) {
            return new ComparisonFailureData(matcher.group(1).replaceAll("\\\\n", "\n"), matcher.group(2).replaceAll("\\\\n", "\n"));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

