/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConvertor;
import git4idea.actions.BasicAction;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(final @NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        List<GithubRepo> availableRepos;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/extensions/GithubCheckoutProvider", "doCheckout"));
        }
        if (!GithubUtil.testGitExecutable(project)) {
            return;
        }
        BasicAction.saveAll();
        try {
            availableRepos = GithubUtil.computeValueInModal(project, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, List<GithubRepo>, IOException>(){

                @NotNull
                public List<GithubRepo> convert(ProgressIndicator indicator) throws IOException {
                    List<GithubRepo> list = GithubUtil.runTask(project, GithubAuthDataHolder.createFromSettings(), indicator, new ThrowableConvertor<GithubConnection, List<GithubRepo>, IOException>(){

                        @NotNull
                        public List<GithubRepo> convert(@NotNull GithubConnection connection) throws IOException {
                            if (connection == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/extensions/GithubCheckoutProvider$1$1", "convert"));
                            }
                            List<GithubRepo> list = GithubApiUtil.getAvailableRepos(connection);
                            if (list == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/extensions/GithubCheckoutProvider$1$1", "convert"));
                            }
                            return list;
                        }
                    });
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/extensions/GithubCheckoutProvider$1", "convert"));
                    }
                    return list;
                }
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "Couldn't get the list of GitHub repositories", e);
            return;
        }
        Collections.sort(availableRepos, new Comparator<GithubRepo>(){

            @Override
            public int compare(GithubRepo r1, GithubRepo r2) {
                int comparedOwners = r1.getUserName().compareTo(r2.getUserName());
                return comparedOwners != 0 ? comparedOwners : r1.getName().compareTo(r2.getName());
            }
        });
        GitCloneDialog dialog = new GitCloneDialog(project);
        dialog.prependToHistory("-----------------------------------------------");
        for (int i = availableRepos.size() - 1; i >= 0; --i) {
            dialog.prependToHistory(availableRepos.get(i).getCloneUrl());
        }
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.rememberSettings();
        VirtualFile destinationParent = LocalFileSystem.getInstance().findFileByIoFile(new File(dialog.getParentDirectory()));
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        String directoryName = dialog.getDirectoryName();
        String parentDirectory = dialog.getParentDirectory();
        Git git = (Git)ServiceManager.getService(Git.class);
        GitCheckoutProvider.clone((Project)project, (Git)git, (CheckoutProvider.Listener)listener, (VirtualFile)destinationParent, (String)sourceRepositoryURL, (String)directoryName, (String)parentDirectory);
    }

    public String getVcsName() {
        return "Git_Hub";
    }
}

