/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.AssetSetStep;
import com.android.tools.idea.wizard.AssetStudioAssetGenerator;
import com.android.tools.idea.wizard.ChooseAndroidAndJavaSdkStep;
import com.android.tools.idea.wizard.ChooseTemplateStep;
import com.android.tools.idea.wizard.ConfigureAndroidModuleStep;
import com.android.tools.idea.wizard.LegacyWizardPathProvider;
import com.android.tools.idea.wizard.NewModuleWizardState;
import com.android.tools.idea.wizard.TemplateParameterStep;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.android.tools.idea.wizard.WizardPath;
import com.google.common.collect.ImmutableSet;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@LegacyWizardPathProvider.Migrated
public final class NewAndroidModulePath
implements WizardPath {
    private static final Logger LOG = Logger.getInstance(NewAndroidModulePath.class);
    @NotNull
    private final NewModuleWizardState myWizardState;
    @Nullable
    private final Project myProject;
    private ConfigureAndroidModuleStep myConfigureAndroidModuleStep;
    private AssetSetStep myAssetSetStep;
    private ChooseTemplateStep myChooseActivityStep;
    private TemplateParameterStep myActivityTemplateParameterStep;
    private TemplateParameterStep myJavaModuleTemplateParameterStep;

    public NewAndroidModulePath(@NotNull NewModuleWizardState wizardState, @NotNull TemplateWizardStep.UpdateListener builder, @Nullable Project project, @Nullable Icon sidePanelIcon, @NotNull Disposable disposable) {
        if (wizardState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardState", "com/android/tools/idea/wizard/NewAndroidModulePath", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/wizard/NewAndroidModulePath", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/wizard/NewAndroidModulePath", "<init>"));
        }
        this.myWizardState = wizardState;
        this.myProject = project;
        this.myConfigureAndroidModuleStep = new ConfigureAndroidModuleStep(wizardState, project, sidePanelIcon, builder);
        this.myAssetSetStep = new AssetSetStep(this.myWizardState, project, null, sidePanelIcon, builder, null);
        Disposer.register((Disposable)disposable, (Disposable)this.myAssetSetStep);
        this.myChooseActivityStep = new ChooseTemplateStep(this.myWizardState.getActivityTemplateState(), "activities", project, null, sidePanelIcon, builder, null, ContainerUtil.newHashSet((Object[])new String[]{"Android TV Activity"})){

            public String getHelpId() {
                return "Android_Application_Template_Page";
            }
        };
        this.myActivityTemplateParameterStep = new TemplateParameterStep(this.myWizardState.getActivityTemplateState(), project, null, sidePanelIcon, builder){

            public String getHelpId() {
                return "Android_Activity_Settings_Page";
            }
        };
        this.myJavaModuleTemplateParameterStep = new TemplateParameterStep(this.myWizardState, project, null, sidePanelIcon, builder);
        this.myAssetSetStep.finalizeAssetType(AssetStudioAssetGenerator.AssetType.LAUNCHER);
    }

    @Override
    public void update() {
        boolean isAndroidTemplate = NewModuleWizardState.isAndroidTemplate(this.myWizardState.getTemplateMetadata());
        this.myJavaModuleTemplateParameterStep.setVisible(!isAndroidTemplate);
        this.myConfigureAndroidModuleStep.setVisible(isAndroidTemplate);
        if (isAndroidTemplate) {
            this.myConfigureAndroidModuleStep.updateStep();
        }
        this.myAssetSetStep.setVisible(isAndroidTemplate && this.myWizardState.getBoolean("createIcons"));
        boolean createActivity = isAndroidTemplate && this.myWizardState.getBoolean("createActivity");
        this.myChooseActivityStep.setVisible(createActivity);
        this.myActivityTemplateParameterStep.setVisible(createActivity);
    }

    public void templateChanged() {
        this.myConfigureAndroidModuleStep.refreshUiFromParameters();
    }

    @Override
    public void createModule() {
        if (this.myProject != null) {
            try {
                this.myWizardState.populateDirectoryParameters();
                File projectRoot = new File(this.myProject.getBasePath());
                File moduleRoot = new File(projectRoot, this.myWizardState.getString("projectName"));
                projectRoot.mkdirs();
                this.myWizardState.updateParameters();
                Template template = this.myWizardState.myTemplate;
                template.render(projectRoot, moduleRoot, this.myWizardState.myParameters, this.myProject);
                if (NewModuleWizardState.isAndroidTemplate(template.getMetadata())) {
                    if (this.myAssetSetStep.isStepVisible() && this.myWizardState.getBoolean("createIcons")) {
                        AssetStudioAssetGenerator assetGenerator = new AssetStudioAssetGenerator(this.myWizardState);
                        assetGenerator.outputImagesIntoDefaultVariant(moduleRoot);
                    }
                    if (this.myActivityTemplateParameterStep.isStepVisible() && this.myWizardState.getBoolean("createActivity")) {
                        TemplateWizardState activityTemplateState = this.myWizardState.getActivityTemplateState();
                        activityTemplateState.populateRelativePackage(null);
                        Template activityTemplate = activityTemplateState.getTemplate();
                        assert (activityTemplate != null);
                        activityTemplate.render(moduleRoot, moduleRoot, activityTemplateState.myParameters, this.myProject);
                    }
                }
            }
            catch (Exception e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)"New Module");
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public Collection<ModuleWizardStep> getSteps() {
        return ImmutableSet.of((Object)((Object)new ChooseAndroidAndJavaSdkStep()), (Object)this.myJavaModuleTemplateParameterStep, (Object)this.myConfigureAndroidModuleStep, (Object)this.myAssetSetStep, (Object)this.myChooseActivityStep, (Object)this.myActivityTemplateParameterStep, (Object[])new ModuleWizardStep[0]);
    }

    @Override
    public boolean isStepVisible(ModuleWizardStep step) {
        if (!step.isStepVisible()) {
            return false;
        }
        if (step instanceof ChooseAndroidAndJavaSdkStep) {
            return true;
        }
        return !NewModuleWizardState.isAndroidTemplate(this.myWizardState.getTemplateMetadata()) == (step == this.myJavaModuleTemplateParameterStep);
    }

    @Override
    public Collection<ChooseTemplateStep.MetadataListItem> getBuiltInTemplates() {
        File moduleTemplate = new File(TemplateManager.getTemplateRootFolder(), FileUtil.join((String[])new String[]{"gradle-projects", "NewAndroidModule"}));
        TemplateManager manager = TemplateManager.getInstance();
        TemplateMetadata metadata = manager.getTemplate(moduleTemplate);
        assert (metadata != null);
        ChooseTemplateStep.MetadataListItem appListItem = new ChooseTemplateStep.MetadataListItem(moduleTemplate, metadata){

            @Override
            public String toString() {
                return "Android Application";
            }
        };
        ChooseTemplateStep.MetadataListItem libListItem = new ChooseTemplateStep.MetadataListItem(moduleTemplate, metadata){

            @Override
            public String toString() {
                return "Android Library";
            }

            @Override
            @Nullable
            public String getDescription() {
                return "Creates a new Android library module.";
            }
        };
        return ImmutableSet.of((Object)appListItem, (Object)libListItem);
    }

    @Override
    public boolean supportsGlobalWizard() {
        return true;
    }

    @Override
    public Collection<String> getExcludedTemplates() {
        return ImmutableSet.of((Object)"Android Module", (Object)"Android Project");
    }
}

