/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.profiles.Activation;
import org.apache.maven.profiles.ActivationFile;
import org.apache.maven.profiles.ActivationOS;
import org.apache.maven.profiles.ActivationProperty;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.Repository;
import org.apache.maven.profiles.RepositoryPolicy;

public class ProfilesConversionUtils {
    private ProfilesConversionUtils() {
    }

    public static org.apache.maven.model.Profile convertFromProfileXmlProfile(Profile profileXmlProfile) {
        List<Repository> pluginRepos;
        org.apache.maven.model.Profile profile = new org.apache.maven.model.Profile();
        profile.setId(profileXmlProfile.getId());
        profile.setSource("profiles.xml");
        Activation profileActivation = profileXmlProfile.getActivation();
        if (profileActivation != null) {
            ActivationFile profileFile;
            ActivationOS profileOs;
            org.apache.maven.model.Activation activation = new org.apache.maven.model.Activation();
            activation.setActiveByDefault(profileActivation.isActiveByDefault());
            activation.setJdk(profileActivation.getJdk());
            ActivationProperty profileProp = profileActivation.getProperty();
            if (profileProp != null) {
                org.apache.maven.model.ActivationProperty prop = new org.apache.maven.model.ActivationProperty();
                prop.setName(profileProp.getName());
                prop.setValue(profileProp.getValue());
                activation.setProperty(prop);
            }
            if ((profileOs = profileActivation.getOs()) != null) {
                org.apache.maven.model.ActivationOS os = new org.apache.maven.model.ActivationOS();
                os.setArch(profileOs.getArch());
                os.setFamily(profileOs.getFamily());
                os.setName(profileOs.getName());
                os.setVersion(profileOs.getVersion());
                activation.setOs(os);
            }
            if ((profileFile = profileActivation.getFile()) != null) {
                org.apache.maven.model.ActivationFile file = new org.apache.maven.model.ActivationFile();
                file.setExists(profileFile.getExists());
                file.setMissing(profileFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(profileXmlProfile.getProperties());
        List<Repository> repos = profileXmlProfile.getRepositories();
        if (repos != null) {
            Iterator<Repository> it = repos.iterator();
            while (it.hasNext()) {
                profile.addRepository(ProfilesConversionUtils.convertFromProfileXmlRepository(it.next()));
            }
        }
        if ((pluginRepos = profileXmlProfile.getPluginRepositories()) != null) {
            Iterator<Repository> it = pluginRepos.iterator();
            while (it.hasNext()) {
                profile.addPluginRepository(ProfilesConversionUtils.convertFromProfileXmlRepository(it.next()));
            }
        }
        return profile;
    }

    private static org.apache.maven.model.Repository convertFromProfileXmlRepository(Repository profileXmlRepo) {
        org.apache.maven.model.Repository repo = new org.apache.maven.model.Repository();
        repo.setId(profileXmlRepo.getId());
        repo.setLayout(profileXmlRepo.getLayout());
        repo.setName(profileXmlRepo.getName());
        repo.setUrl(profileXmlRepo.getUrl());
        if (profileXmlRepo.getSnapshots() != null) {
            repo.setSnapshots(ProfilesConversionUtils.convertRepositoryPolicy(profileXmlRepo.getSnapshots()));
        }
        if (profileXmlRepo.getReleases() != null) {
            repo.setReleases(ProfilesConversionUtils.convertRepositoryPolicy(profileXmlRepo.getReleases()));
        }
        return repo;
    }

    private static org.apache.maven.model.RepositoryPolicy convertRepositoryPolicy(RepositoryPolicy profileXmlRepo) {
        org.apache.maven.model.RepositoryPolicy policy = new org.apache.maven.model.RepositoryPolicy();
        policy.setEnabled(profileXmlRepo.isEnabled());
        policy.setUpdatePolicy(profileXmlRepo.getUpdatePolicy());
        policy.setChecksumPolicy(profileXmlRepo.getChecksumPolicy());
        return policy;
    }
}

