/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckLevelHighlightInfoHolder
extends HighlightInfoHolder {
    private final HighlightInfoHolder myHolder;
    private PsiElement myLevel;

    public CheckLevelHighlightInfoHolder(PsiFile file, HighlightInfoHolder holder) {
        super(file, new HighlightInfoFilter[0]);
        this.myHolder = holder;
    }

    @Override
    @NotNull
    public TextAttributesScheme getColorsScheme() {
        TextAttributesScheme textAttributesScheme = this.myHolder.getColorsScheme();
        if (textAttributesScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CheckLevelHighlightInfoHolder", "getColorsScheme"));
        }
        return textAttributesScheme;
    }

    @Override
    @NotNull
    public PsiFile getContextFile() {
        PsiFile psiFile = this.myHolder.getContextFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CheckLevelHighlightInfoHolder", "getContextFile"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myHolder.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CheckLevelHighlightInfoHolder", "getProject"));
        }
        return project;
    }

    @Override
    public boolean hasErrorResults() {
        return this.myHolder.hasErrorResults();
    }

    @Override
    public boolean add(@Nullable HighlightInfo info) {
        if (info == null) {
            return false;
        }
        PsiElement psiElement = info.psiElement;
        if (psiElement != null && !PsiTreeUtil.isAncestor((PsiElement)this.myLevel, (PsiElement)psiElement, (boolean)false)) {
            throw new RuntimeException("Info: '" + info + "' reported for the element '" + psiElement + "'; but it was at the level " + this.myLevel);
        }
        return this.myHolder.add(info);
    }

    @Override
    public void clear() {
        this.myHolder.clear();
    }

    @Override
    public boolean addAll(Collection<? extends HighlightInfo> highlightInfos) {
        return this.myHolder.addAll(highlightInfos);
    }

    @Override
    public int size() {
        return this.myHolder.size();
    }

    @Override
    public HighlightInfo get(int i) {
        return this.myHolder.get(i);
    }

    @Override
    @NotNull
    public AnnotationSession getAnnotationSession() {
        AnnotationSession annotationSession = this.myHolder.getAnnotationSession();
        if (annotationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CheckLevelHighlightInfoHolder", "getAnnotationSession"));
        }
        return annotationSession;
    }

    public void enterLevel(PsiElement element) {
        this.myLevel = element;
    }
}

