/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitializeFinalFieldInConstructorFix
implements IntentionAction {
    private final PsiField myField;

    public InitializeFinalFieldInConstructorFix(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "<init>"));
        }
        this.myField = field;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("initialize.final.field.in.constructor.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "isAvailable"));
        }
        if (!this.myField.isValid() || this.myField.hasModifierProperty("static") || this.myField.hasInitializer()) {
            return false;
        }
        PsiClass containingClass = this.myField.getContainingClass();
        if (containingClass == null || containingClass.getName() == null) {
            return false;
        }
        PsiManager manager = this.myField.getManager();
        return manager != null && manager.isInProject((PsiElement)this.myField);
    }

    public void invoke(final @NotNull Project project, final Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiClass myClass = this.myField.getContainingClass();
        if (myClass == null) {
            return;
        }
        if (myClass.getConstructors().length == 0) {
            InitializeFinalFieldInConstructorFix.createDefaultConstructor(myClass, project, editor, file);
        }
        final List<PsiMethod> constructors = InitializeFinalFieldInConstructorFix.choose(InitializeFinalFieldInConstructorFix.filterIfFieldAlreadyAssigned(this.myField, myClass.getConstructors()), project);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                List statements = InitializeFinalFieldInConstructorFix.addFieldInitialization(constructors, InitializeFinalFieldInConstructorFix.this.myField, project);
                PsiExpressionStatement highestStatement = (PsiExpressionStatement)InitializeFinalFieldInConstructorFix.getHighestElement(statements);
                if (highestStatement == null) {
                    return;
                }
                PsiAssignmentExpression expression = (PsiAssignmentExpression)highestStatement.getExpression();
                PsiExpression rightExpression = expression.getRExpression();
                TextRange expressionRange = rightExpression.getTextRange();
                editor.getCaretModel().moveToOffset(expressionRange.getStartOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().setSelection(expressionRange.getStartOffset(), expressionRange.getEndOffset());
            }
        });
    }

    @Nullable
    private static <T extends PsiElement> T getHighestElement(@NotNull List<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "getHighestElement"));
        }
        PsiElement highest = null;
        int highestTextOffset = Integer.MAX_VALUE;
        for (PsiElement element : elements) {
            PsiElement forcedElem = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element);
            int startOffset = forcedElem.getTextOffset();
            if (startOffset >= highestTextOffset) continue;
            highest = forcedElem;
            highestTextOffset = startOffset;
        }
        return (T)highest;
    }

    @NotNull
    private static List<PsiExpressionStatement> addFieldInitialization(@NotNull List<PsiMethod> constructors, @NotNull PsiField field, @NotNull Project project) {
        if (constructors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructors", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        ArrayList<PsiExpressionStatement> statements = new ArrayList<PsiExpressionStatement>();
        for (PsiMethod constructor : constructors) {
            PsiExpressionStatement statement = InitializeFinalFieldInConstructorFix.addFieldInitialization(constructor, field, project);
            if (statement == null) continue;
            statements.add(statement);
        }
        ArrayList<PsiExpressionStatement> arrayList = statements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        return arrayList;
    }

    @Nullable
    private static PsiExpressionStatement addFieldInitialization(@NotNull PsiMethod constructor, @NotNull PsiField field, @NotNull Project project) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        PsiCodeBlock methodBody = constructor.getBody();
        if (methodBody == null) {
            return null;
        }
        String fieldName = field.getName();
        String stmtText = fieldName + " = " + InitializeFinalFieldInConstructorFix.suggestInitValue(field) + ";";
        if (InitializeFinalFieldInConstructorFix.methodContainsParameterWithName(constructor, fieldName)) {
            stmtText = "this." + stmtText;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        return (PsiExpressionStatement)methodBody.add(codeStyleManager.reformat((PsiElement)factory.createStatementFromText(stmtText, (PsiElement)methodBody)));
    }

    private static boolean methodContainsParameterWithName(@NotNull PsiMethod constructor, @NotNull String name) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "methodContainsParameterWithName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "methodContainsParameterWithName"));
        }
        for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
            if (!name.equals(parameter.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<PsiMethod> choose(@NotNull PsiMethod[] ctors, @NotNull Project project) {
        if (ctors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctors", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List<PsiMethod> list = Arrays.asList(ctors);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
            }
            return list;
        }
        if (ctors.length == 1) {
            List<PsiMethod> list = Arrays.asList(ctors[0]);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
            }
            return list;
        }
        if (ctors.length > 1) {
            MemberChooser chooser = new MemberChooser((ClassMember[])InitializeFinalFieldInConstructorFix.toPsiMethodMemberArray(ctors), false, true, project);
            chooser.setTitle(QuickFixBundle.message("initialize.final.field.in.constructor.choose.dialog.title", new Object[0]));
            chooser.show();
            List<PsiMethodMember> chosenMembers = chooser.getSelectedElements();
            if (chosenMembers != null) {
                List<PsiMethod> list = Arrays.asList(InitializeFinalFieldInConstructorFix.toPsiMethodArray(chosenMembers));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
                }
                return list;
            }
        }
        List<PsiMethod> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
        }
        return list;
    }

    private static PsiMethodMember[] toPsiMethodMemberArray(@NotNull PsiMethod[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "toPsiMethodMemberArray"));
        }
        PsiMethodMember[] result = new PsiMethodMember[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new PsiMethodMember(methods[i]);
        }
        return result;
    }

    private static PsiMethod[] toPsiMethodArray(@NotNull List<PsiMethodMember> methodMembers) {
        if (methodMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodMembers", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "toPsiMethodArray"));
        }
        PsiMethod[] result = new PsiMethod[methodMembers.size()];
        int i = 0;
        for (PsiMethodMember methodMember : methodMembers) {
            result[i++] = (PsiMethod)methodMember.getElement();
        }
        return result;
    }

    private static void createDefaultConstructor(PsiClass psiClass, final @NotNull Project project, final Editor editor, final PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "createDefaultConstructor"));
        }
        final AddDefaultConstructorFix defaultConstructorFix = new AddDefaultConstructorFix(psiClass);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                defaultConstructorFix.invoke(project, editor, file);
            }
        });
    }

    private static PsiMethod[] filterIfFieldAlreadyAssigned(@NotNull PsiField field, @NotNull PsiMethod[] ctors) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "filterIfFieldAlreadyAssigned"));
        }
        if (ctors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctors", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "filterIfFieldAlreadyAssigned"));
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(Arrays.asList(ctors));
        for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement[])ctors))) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element))) continue;
            result.remove(PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class));
        }
        return result.toArray(new PsiMethod[result.size()]);
    }

    private static String suggestInitValue(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "suggestInitValue"));
        }
        PsiType type = field.getType();
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

