/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.IDEInspectionToolsConfigurable;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeInspectionAction
extends BaseAnalysisAction {
    private GlobalInspectionContextImpl myGlobalInspectionContext = null;
    protected InspectionProfile myExternalProfile = null;

    public CodeInspectionAction() {
        super(InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0]));
    }

    public CodeInspectionAction(String title, String analysisNoon) {
        super(title, analysisNoon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CodeInspectionAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/actions/CodeInspectionAction", "analyze"));
        }
        try {
            this.runInspections(project, scope);
        }
        finally {
            this.myGlobalInspectionContext = null;
            this.myExternalProfile = null;
        }
    }

    protected void runInspections(Project project, AnalysisScope scope) {
        scope.setSearchInLibraries(false);
        FileDocumentManager.getInstance().saveAllDocuments();
        GlobalInspectionContextImpl inspectionContext = this.getGlobalInspectionContext(project);
        inspectionContext.setExternalProfile(this.myExternalProfile);
        inspectionContext.setCurrentScope(scope);
        inspectionContext.doInspections(scope);
    }

    private GlobalInspectionContextImpl getGlobalInspectionContext(Project project) {
        if (this.myGlobalInspectionContext == null) {
            this.myGlobalInspectionContext = ((InspectionManagerEx)InspectionManager.getInstance((Project)project)).createNewGlobalContext(false);
        }
        return this.myGlobalInspectionContext;
    }

    @Override
    @NonNls
    protected String getHelpTopic() {
        return "reference.dialogs.inspection.scope";
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.myGlobalInspectionContext = null;
    }

    @Override
    protected JComponent getAdditionalActionSettings(final @NotNull Project project, final BaseAnalysisActionDialog dialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CodeInspectionAction", "getAdditionalActionSettings"));
        }
        AdditionalPanel panel = new AdditionalPanel();
        final InspectionManagerEx manager = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        final JComboBox profiles = panel.myBrowseProfilesCombo.getComboBox();
        profiles.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Profile) {
                    Profile profile = (Profile)value;
                    this.setText(profile.getName());
                    this.setIcon(profile.isProjectLevel() ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
                }
            }
        });
        final InspectionProfileManager profileManager = InspectionProfileManager.getInstance();
        final InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project);
        this.reloadProfiles(profiles, profileManager, projectProfileManager, manager);
        panel.myBrowseProfilesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IDEInspectionToolsConfigurable errorConfigurable = CodeInspectionAction.this.createConfigurable(projectProfileManager, profileManager);
                MySingleConfigurableEditor editor = new MySingleConfigurableEditor(project, errorConfigurable, manager);
                errorConfigurable.selectProfile((Profile)profiles.getSelectedItem());
                if (editor.showAndGet()) {
                    CodeInspectionAction.this.reloadProfiles(profiles, profileManager, projectProfileManager, manager);
                } else {
                    InspectionProfile profile = (InspectionProfile)profiles.getSelectedItem();
                    boolean canExecute = profile != null && profile.isExecutable(project);
                    dialog.setOKActionEnabled(canExecute);
                }
            }
        });
        profiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeInspectionAction.this.myExternalProfile = (InspectionProfile)profiles.getSelectedItem();
                boolean canExecute = CodeInspectionAction.this.myExternalProfile != null && CodeInspectionAction.this.myExternalProfile.isExecutable(project);
                dialog.setOKActionEnabled(canExecute);
                if (canExecute) {
                    manager.setProfile(CodeInspectionAction.this.myExternalProfile.getName());
                }
            }
        });
        InspectionProfile profile = (InspectionProfile)profiles.getSelectedItem();
        dialog.setOKActionEnabled(profile != null && profile.isExecutable(project));
        return panel.myAdditionalPanel;
    }

    protected IDEInspectionToolsConfigurable createConfigurable(InspectionProjectProfileManager projectProfileManager, InspectionProfileManager profileManager) {
        return new IDEInspectionToolsConfigurable(projectProfileManager, profileManager);
    }

    private void reloadProfiles(JComboBox profiles, InspectionProfileManager inspectionProfileManager, InspectionProjectProfileManager inspectionProjectProfileManager, InspectionManagerEx inspectionManager) {
        InspectionProfile selectedProfile = this.getGlobalInspectionContext(inspectionManager.getProject()).getCurrentProfile();
        DefaultComboBoxModel model = (DefaultComboBoxModel)profiles.getModel();
        model.removeAllElements();
        CodeInspectionAction.fillModel((ProfileManager)inspectionProfileManager, model);
        CodeInspectionAction.fillModel((ProfileManager)inspectionProjectProfileManager, model);
        profiles.setSelectedItem(selectedProfile);
    }

    private static void fillModel(ProfileManager inspectionProfileManager, DefaultComboBoxModel model) {
        TreeSet profiles = new TreeSet(inspectionProfileManager.getProfiles());
        for (Profile profile : profiles) {
            model.addElement(profile);
        }
    }

    private static class MySingleConfigurableEditor
    extends SingleConfigurableEditor {
        private final InspectionManagerEx myManager;

        public MySingleConfigurableEditor(Project project, ErrorsConfigurable configurable, InspectionManagerEx manager) {
            super(project, (Configurable)configurable, MySingleConfigurableEditor.createDimensionKey(configurable));
            this.myManager = manager;
        }

        @Override
        protected void doOKAction() {
            Object o = ((ErrorsConfigurable)this.getConfigurable()).getSelectedObject();
            if (o instanceof Profile) {
                this.myManager.setProfile(((Profile)o).getName());
            }
            super.doOKAction();
        }
    }

    private static class AdditionalPanel {
        public ComboboxWithBrowseButton myBrowseProfilesCombo;
        public JPanel myAdditionalPanel;

        private AdditionalPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            ComboboxWithBrowseButton comboboxWithBrowseButton;
            JPanel jPanel;
            this.myAdditionalPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.action.profile.label"), (int)0, (int)0, null, null));
            this.myBrowseProfilesCombo = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
            jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myAdditionalPanel;
        }
    }
}

