/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaVariableState {
    protected final Set<DfaPsiType> myInstanceofValues;
    protected final Set<DfaPsiType> myNotInstanceofValues;
    protected final Nullness myNullability;
    private final int myHash;

    public DfaVariableState(@NotNull DfaVariableValue dfaVar) {
        if (dfaVar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaVar", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        this(Collections.emptySet(), Collections.emptySet(), dfaVar.getInherentNullability());
    }

    protected DfaVariableState(Set<DfaPsiType> instanceofValues, Set<DfaPsiType> notInstanceofValues, Nullness nullability) {
        this.myInstanceofValues = instanceofValues;
        this.myNotInstanceofValues = notInstanceofValues;
        this.myNullability = nullability;
        this.myHash = (((Object)this.myInstanceofValues).hashCode() * 31 + ((Object)this.myNotInstanceofValues).hashCode()) * 31 + this.myNullability.hashCode();
    }

    public boolean isNullable() {
        return this.myNullability == Nullness.NULLABLE;
    }

    private boolean checkInstanceofValue(DfaPsiType dfaType) {
        if (this.myInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaPsiType dfaTypeValue : this.myNotInstanceofValues) {
            if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
            return false;
        }
        for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
            if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public DfaVariableState withInstanceofValue(DfaTypeValue dfaType) {
        if (dfaType.getDfaType().getPsiType() instanceof PsiPrimitiveType) {
            return this;
        }
        if (this.checkInstanceofValue(dfaType.getDfaType())) {
            DfaVariableState result = dfaType.isNullable() ? this.withNullability(Nullness.NULLABLE) : this;
            ArrayList moreGeneric = ContainerUtil.newArrayList();
            for (DfaPsiType alreadyInstanceof : this.myInstanceofValues) {
                if (dfaType.getDfaType().isAssignableFrom(alreadyInstanceof)) {
                    return result;
                }
                if (!alreadyInstanceof.isAssignableFrom(dfaType.getDfaType())) continue;
                moreGeneric.add(alreadyInstanceof);
            }
            HashSet newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.removeAll(moreGeneric);
            newInstanceof.add(dfaType.getDfaType());
            result = this.createCopy(newInstanceof, this.myNotInstanceofValues, result.myNullability);
            return result;
        }
        return null;
    }

    @Nullable
    public DfaVariableState withNotInstanceofValue(DfaTypeValue dfaType) {
        if (this.myNotInstanceofValues.contains(dfaType.getDfaType())) {
            return this;
        }
        for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
            if (!dfaType.getDfaType().isAssignableFrom(dfaTypeValue)) continue;
            return null;
        }
        ArrayList moreSpecific = ContainerUtil.newArrayList();
        for (DfaPsiType alreadyNotInstanceof : this.myNotInstanceofValues) {
            if (alreadyNotInstanceof.isAssignableFrom(dfaType.getDfaType())) {
                return this;
            }
            if (!dfaType.getDfaType().isAssignableFrom(alreadyNotInstanceof)) continue;
            moreSpecific.add(alreadyNotInstanceof);
        }
        HashSet newNotInstanceof = ContainerUtil.newHashSet(this.myNotInstanceofValues);
        newNotInstanceof.removeAll(moreSpecific);
        newNotInstanceof.add(dfaType.getDfaType());
        return this.createCopy(this.myInstanceofValues, newNotInstanceof, this.myNullability);
    }

    DfaVariableState withoutType(DfaPsiType type) {
        if (this.myInstanceofValues.contains(type)) {
            HashSet newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.remove(type);
            return this.createCopy(newInstanceof, this.myNotInstanceofValues, this.myNullability);
        }
        if (this.myNotInstanceofValues.contains(type)) {
            HashSet newNotInstanceof = ContainerUtil.newHashSet(this.myNotInstanceofValues);
            newNotInstanceof.remove(type);
            return this.createCopy(this.myInstanceofValues, newNotInstanceof, this.myNullability);
        }
        return this;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaVariableState)) {
            return false;
        }
        DfaVariableState aState = (DfaVariableState)obj;
        return this.myHash == aState.myHash && this.myNullability == aState.myNullability && ((Object)this.myInstanceofValues).equals(aState.myInstanceofValues) && ((Object)this.myNotInstanceofValues).equals(aState.myNotInstanceofValues);
    }

    protected DfaVariableState createCopy(Set<DfaPsiType> instanceofValues, Set<DfaPsiType> notInstanceofValues, Nullness nullability) {
        return new DfaVariableState(instanceofValues, notInstanceofValues, nullability);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append((Object)this.myNullability);
        if (!this.myInstanceofValues.isEmpty()) {
            buf.append(" instanceof ").append(StringUtil.join(this.myInstanceofValues, (String)","));
        }
        if (!this.myNotInstanceofValues.isEmpty()) {
            buf.append(" not instanceof ").append(StringUtil.join(this.myNotInstanceofValues, (String)","));
        }
        return buf.toString();
    }

    public Nullness getNullability() {
        return this.myNullability;
    }

    public boolean isNotNull() {
        return this.myNullability == Nullness.NOT_NULL;
    }

    DfaVariableState withNullability(@NotNull Nullness nullness) {
        if (nullness == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullness", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withNullability"));
        }
        return this.myNullability == nullness ? this : this.createCopy(this.myInstanceofValues, this.myNotInstanceofValues, nullness);
    }

    public DfaVariableState withNullable(boolean nullable) {
        return this.myNullability != Nullness.NOT_NULL ? this.withNullability(nullable ? Nullness.NULLABLE : Nullness.UNKNOWN) : this;
    }

    public DfaVariableState withValue(DfaValue value) {
        return this;
    }

    @Nullable
    public DfaValue getValue() {
        return null;
    }

    public Set<DfaPsiType> getInstanceofValues() {
        return this.myInstanceofValues;
    }

    public Set<DfaPsiType> getNotInstanceofValues() {
        return this.myNotInstanceofValues;
    }
}

