/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.IDEInspectionToolsConfigurable;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class EditInspectionToolsSettingsAction
implements IntentionAction,
Iconable,
HighPriorityAction {
    private final String myShortName;

    public EditInspectionToolsSettingsAction(@NotNull LocalInspectionTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "<init>"));
        }
        this.myShortName = tool.getShortName();
    }

    public EditInspectionToolsSettingsAction(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "<init>"));
        }
        this.myShortName = key.toString();
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"edit.options.of.reporter.inspection.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"edit.options.of.reporter.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsAction", "invoke"));
        }
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(file.getProject());
        InspectionProfile inspectionProfile = projectProfileManager.getInspectionProfile();
        EditInspectionToolsSettingsAction.editToolSettings(project, inspectionProfile, true, this.myShortName);
    }

    public boolean editToolSettings(Project project, InspectionProfileImpl inspectionProfile, boolean canChooseDifferentProfiles) {
        return EditInspectionToolsSettingsAction.editToolSettings(project, inspectionProfile, canChooseDifferentProfiles, this.myShortName);
    }

    public static boolean editToolSettings(Project project, final InspectionProfile inspectionProfile, boolean canChooseDifferentProfile, final String selectedToolShortName) {
        ShowSettingsUtil settingsUtil = ShowSettingsUtil.getInstance();
        final ErrorsConfigurable errorsConfigurable = !canChooseDifferentProfile ? new IDEInspectionToolsConfigurable(InspectionProjectProfileManager.getInstance(project), InspectionProfileManager.getInstance()) : ErrorsConfigurable.SERVICE.createConfigurable(project);
        return settingsUtil.editConfigurable(project, (Configurable)errorsConfigurable, new Runnable(){

            @Override
            public void run() {
                errorsConfigurable.selectProfile((Profile)inspectionProfile);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        errorsConfigurable.selectInspectionTool(selectedToolShortName);
                    }
                });
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return AllIcons.General.Settings;
    }
}

