/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.impl.DebuggerComboBoxRenderer;
import com.intellij.debugger.ui.impl.FramesList;
import com.intellij.debugger.ui.impl.UpdatableDebuggerView;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Alarm;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FramesPanel
extends UpdatableDebuggerView
implements DataProvider {
    private static final Icon FILTER_STACK_FRAMES_ICON = AllIcons.Debugger.Class_filter;
    private final JComboBox myThreadsCombo;
    private final FramesList myFramesList;
    private final ThreadsListener myThreadsListener;
    private final FramesListener myFramesListener;
    private final DebuggerStateManager myStateManager;
    private boolean myShowLibraryFrames;
    private final Alarm myRebuildAlarm;
    private final AtomicBoolean myPerformFullRebuild;
    private final AtomicLong myTimeCounter;
    private long myFramesLastUpdateTime;

    public FramesPanel(Project project, DebuggerStateManager stateManager) {
        super(project, stateManager);
        this.myShowLibraryFrames = DebuggerSettings.getInstance().SHOW_LIBRARY_STACKFRAMES;
        this.myRebuildAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myPerformFullRebuild = new AtomicBoolean(false);
        this.myTimeCounter = new AtomicLong(0L);
        this.myFramesLastUpdateTime = 0L;
        this.myStateManager = stateManager;
        this.setLayout(new BorderLayout());
        this.myThreadsCombo = new ComboBoxWithWidePopup();
        this.myThreadsCombo.setRenderer(new DebuggerComboBoxRenderer(this.myThreadsCombo.getRenderer()));
        this.myThreadsListener = new ThreadsListener();
        this.myThreadsCombo.addItemListener(this.myThreadsListener);
        this.myFramesList = new FramesList(project);
        this.myFramesListener = new FramesListener();
        this.myFramesList.addListSelectionListener(this.myFramesListener);
        this.myFramesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = FramesPanel.this.myFramesList.locationToIndex(e.getPoint());
                if (index >= 0 && FramesPanel.this.myFramesList.isSelectedIndex(index)) {
                    FramesPanel.this.processListValue(FramesPanel.this.myFramesList.getModel().getElementAt(index));
                }
            }
        });
        this.registerThreadsPopupMenu((JList)((Object)this.myFramesList));
        this.setBorder(null);
        ActionToolbar toolbar = this.createToolbar();
        Wrapper threads = new Wrapper();
        CustomLineBorder border = new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, 0, 0, 1, 0);
        threads.setBorder((Border)border);
        threads.add((Component)toolbar.getComponent(), (Object)"East");
        threads.add((Component)this.myThreadsCombo, (Object)"Center");
        this.add((Component)threads, "North");
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myFramesList)), "Center");
    }

    private ActionToolbar createToolbar() {
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        framesGroup.addSeparator();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        framesGroup.add(actionsManager.createPrevOccurenceAction(this.getOccurenceNavigator()));
        framesGroup.add(actionsManager.createNextOccurenceAction(this.getOccurenceNavigator()));
        framesGroup.add((AnAction)new ShowLibraryFramesAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)framesGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        ((ActionToolbarImpl)toolbar).setAddSeparatorFirst(true);
        toolbar.getComponent().setBorder(new EmptyBorder(1, 0, 0, 0));
        return toolbar;
    }

    @Override
    public DebuggerStateManager getContextManager() {
        return this.myStateManager;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        SourcePosition position;
        DebuggerContextImpl context;
        if (CommonDataKeys.PSI_FILE.is(dataId) && (context = this.myStateManager.getContext()) != null && (position = context.getSourcePosition()) != null) {
            return position.getFile();
        }
        return null;
    }

    private void processListValue(Object selected) {
        if (selected instanceof StackFrameDescriptorImpl) {
            DebuggerContextUtil.setStackFrame(this.getContextManager(), ((StackFrameDescriptorImpl)selected).getFrameProxy());
        }
    }

    private void registerThreadsPopupMenu(final JList framesList) {
        final PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.ThreadsPanelPopup");
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("Debugger.ThreadsPanelPopup", (ActionGroup)group);
                popupMenu.getComponent().show(comp, x, y);
            }
        };
        framesList.addMouseListener((MouseListener)popupHandler);
        this.registerDisposable(new Disposable(){

            public void dispose() {
                FramesPanel.this.myThreadsCombo.removeItemListener(FramesPanel.this.myThreadsListener);
                framesList.removeMouseListener((MouseListener)popupHandler);
            }
        });
    }

    @Override
    protected void rebuild(int event) {
        boolean isRefresh;
        this.myRebuildAlarm.cancelAllRequests();
        boolean bl = isRefresh = event == 7 || event == 11 || event == 12;
        if (!isRefresh) {
            this.myPerformFullRebuild.set(true);
        }
        this.myRebuildAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    FramesPanel.this.doRebuild(!FramesPanel.this.myPerformFullRebuild.getAndSet(false));
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
        }, 100, ModalityState.NON_MODAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebuild(boolean refreshOnly) {
        DebugProcessImpl process;
        boolean paused;
        DebuggerContextImpl context = this.getContext();
        DebuggerSession session = context.getDebuggerSession();
        boolean bl = paused = session != null && session.isPaused();
        if (!paused || !refreshOnly) {
            this.myThreadsCombo.removeAllItems();
            FramesList framesList = this.myFramesList;
            synchronized (framesList) {
                this.myFramesLastUpdateTime = this.getNextStamp();
                this.myFramesList.getModel().clear();
            }
        }
        if (paused && (process = context.getDebugProcess()) != null) {
            process.getManagerThread().schedule(new RefreshFramePanelCommand(refreshOnly && this.myThreadsCombo.getItemCount() != 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            Disposer.dispose((Disposable)this.myRebuildAlarm);
        }
        finally {
            super.dispose();
        }
    }

    public boolean isShowLibraryFrames() {
        return this.myShowLibraryFrames;
    }

    public void setShowLibraryFrames(boolean showLibraryFrames) {
        if (this.myShowLibraryFrames != showLibraryFrames) {
            this.myShowLibraryFrames = showLibraryFrames;
            this.rebuild(8);
        }
    }

    private void selectThread(ThreadReferenceProxyImpl toSelect) {
        int count = this.myThreadsCombo.getItemCount();
        for (int idx = 0; idx < count; ++idx) {
            ThreadDescriptorImpl item = (ThreadDescriptorImpl)this.myThreadsCombo.getItemAt(idx);
            if (!toSelect.equals(item.getThreadReference())) continue;
            if (!item.equals(this.myThreadsCombo.getSelectedItem())) {
                this.myThreadsCombo.setSelectedIndex(idx);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFrame(StackFrameProxy frame) {
        FramesList framesList = this.myFramesList;
        synchronized (framesList) {
            int count = this.myFramesList.getElementCount();
            Object selectedValue = this.myFramesList.getSelectedValue();
            DefaultListModel model = this.myFramesList.getModel();
            for (int idx = 0; idx < count; ++idx) {
                StackFrameDescriptorImpl item;
                Object elem = model.getElementAt(idx);
                if (!(elem instanceof StackFrameDescriptorImpl) || !frame.equals((item = (StackFrameDescriptorImpl)elem).getFrameProxy())) continue;
                if (!item.equals(selectedValue)) {
                    this.myFramesList.setSelectedIndex(idx);
                }
                return;
            }
        }
    }

    private long getNextStamp() {
        return this.myTimeCounter.incrementAndGet();
    }

    @Override
    public void requestFocus() {
        this.myFramesList.requestFocus();
    }

    public OccurenceNavigator getOccurenceNavigator() {
        return this.myFramesList;
    }

    public FramesList getFramesList() {
        return this.myFramesList;
    }

    private class ShowLibraryFramesAction
    extends ToggleAction {
        private volatile boolean myShouldShow;
        private static final String ourTextWhenShowIsOn = "Hide Frames from Libraries";
        private static final String ourTextWhenShowIsOff = "Show All Frames";

        public ShowLibraryFramesAction() {
            super("", "", FILTER_STACK_FRAMES_ICON);
            this.myShouldShow = DebuggerSettings.getInstance().SHOW_LIBRARY_STACKFRAMES;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/ui/FramesPanel$ShowLibraryFramesAction", "update"));
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            boolean shouldShow = !Boolean.TRUE.equals(presentation.getClientProperty("selected"));
            presentation.setText(shouldShow ? ourTextWhenShowIsOn : ourTextWhenShowIsOff);
        }

        public boolean isSelected(AnActionEvent e) {
            return !this.myShouldShow;
        }

        public void setSelected(AnActionEvent e, boolean enabled) {
            DebuggerSettings.getInstance().SHOW_LIBRARY_STACKFRAMES = this.myShouldShow = !enabled;
            FramesPanel.this.setShowLibraryFrames(this.myShouldShow);
        }
    }

    private class AppendFrameCommand
    extends SuspendContextCommandImpl {
        private final StackFrameProxyImpl myFrame;
        private final EvaluationContextImpl myEvaluationContext;
        private final MethodsTracker myTracker;
        private final int myIndexToInsert;
        private final boolean myIsContextFrame;
        private final long myTimestamp;
        private final IndexCounter myCounter;

        /*
         * WARNING - void declaration
         */
        public AppendFrameCommand(@NotNull SuspendContextImpl suspendContext, StackFrameProxyImpl frame, EvaluationContextImpl evaluationContext, MethodsTracker tracker, int indexToInsert, boolean isContextFrame, long timestamp, IndexCounter indexCounter) {
            void counter;
            if (suspendContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/FramesPanel$AppendFrameCommand", "<init>"));
            }
            if (frame == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/ui/FramesPanel$AppendFrameCommand", "<init>"));
            }
            super(suspendContext);
            this.myFrame = frame;
            this.myEvaluationContext = evaluationContext;
            this.myTracker = tracker;
            this.myIndexToInsert = indexToInsert;
            this.myIsContextFrame = isContextFrame;
            this.myTimestamp = timestamp;
            this.myCounter = counter;
        }

        @Override
        public void contextAction() throws Exception {
            final StackFrameDescriptorImpl descriptor = new StackFrameDescriptorImpl(this.myFrame, this.myTracker);
            descriptor.setContext(this.myEvaluationContext);
            descriptor.updateRepresentation(this.myEvaluationContext, DescriptorLabelListener.DUMMY_LISTENER);
            Project project = FramesPanel.this.getProject();
            DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        FramesPanel.this.myFramesListener.setEnabled(false);
                        FramesList framesList = FramesPanel.this.myFramesList;
                        synchronized (framesList) {
                            boolean shouldHide;
                            DefaultListModel model;
                            block11: {
                                model = FramesPanel.this.myFramesList.getModel();
                                if (FramesPanel.this.myFramesLastUpdateTime < AppendFrameCommand.this.myTimestamp) {
                                    FramesPanel.this.myFramesLastUpdateTime = AppendFrameCommand.this.myTimestamp;
                                    model.clear();
                                }
                                if (AppendFrameCommand.this.myTimestamp == FramesPanel.this.myFramesLastUpdateTime) break block11;
                                return;
                            }
                            boolean bl = shouldHide = !FramesPanel.this.myShowLibraryFrames && !AppendFrameCommand.this.myIsContextFrame && AppendFrameCommand.this.myIndexToInsert != 0 && (descriptor.isSynthetic() || descriptor.isInLibraryContent());
                            if (!shouldHide) {
                                AppendFrameCommand.this.myCounter.markCalculated(AppendFrameCommand.this.myIndexToInsert);
                                int actualIndex = AppendFrameCommand.this.myCounter.getActualIndex(AppendFrameCommand.this.myIndexToInsert);
                                model.insertElementAt(descriptor, actualIndex);
                                if (AppendFrameCommand.this.myIsContextFrame) {
                                    FramesPanel.this.myFramesList.setSelectedIndex(actualIndex);
                                }
                            }
                        }
                    }
                    finally {
                        FramesPanel.this.myFramesListener.setEnabled(true);
                    }
                }
            });
        }
    }

    private static class IndexCounter {
        private final int[] myData;

        private IndexCounter(int totalSize) {
            this.myData = new int[totalSize];
            for (int idx = 0; idx < totalSize; ++idx) {
                this.myData[idx] = 0;
            }
        }

        public void markCalculated(int idx) {
            this.myData[idx] = 1;
        }

        public int getActualIndex(int index) {
            int result = 0;
            for (int idx = 0; idx < index; ++idx) {
                result += this.myData[idx];
            }
            return result;
        }
    }

    private class RebuildFramesListCommand
    extends SuspendContextCommandImpl {
        private final DebuggerContextImpl myDebuggerContext;

        public RebuildFramesListCommand(DebuggerContextImpl debuggerContext, SuspendContextImpl suspendContext) {
            super(suspendContext);
            this.myDebuggerContext = debuggerContext;
        }

        @Override
        public void contextAction() throws Exception {
            List<StackFrameProxyImpl> frames;
            ThreadReferenceProxyImpl thread = this.myDebuggerContext.getThreadProxy();
            try {
                if (!this.getSuspendContext().getDebugProcess().getSuspendManager().isSuspended(thread)) {
                    DebuggerInvocationUtil.swingInvokeLater(FramesPanel.this.getProject(), new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                FramesPanel.this.myFramesListener.setEnabled(false);
                                FramesList framesList = FramesPanel.this.myFramesList;
                                synchronized (framesList) {
                                    FramesPanel.this.myFramesLastUpdateTime = FramesPanel.this.getNextStamp();
                                    DefaultListModel model = FramesPanel.this.myFramesList.getModel();
                                    model.clear();
                                    model.addElement(new Object(){

                                        public String toString() {
                                            return DebuggerBundle.message((String)"frame.panel.frames.not.available", (Object[])new Object[0]);
                                        }
                                    });
                                    FramesPanel.this.myFramesList.setSelectedIndex(0);
                                }
                            }
                            finally {
                                FramesPanel.this.myFramesListener.setEnabled(true);
                            }
                        }
                    });
                    return;
                }
            }
            catch (ObjectCollectedException ignored) {
                return;
            }
            try {
                frames = thread.frames();
            }
            catch (EvaluateException ignored) {
                frames = Collections.emptyList();
            }
            StackFrameProxyImpl contextFrame = this.myDebuggerContext.getFrameProxy();
            EvaluationContextImpl evaluationContext = this.myDebuggerContext.createEvaluationContext();
            DebuggerManagerThreadImpl managerThread = this.myDebuggerContext.getDebugProcess().getManagerThread();
            MethodsTracker tracker = new MethodsTracker();
            int totalFramesCount = frames.size();
            int index = 0;
            IndexCounter indexCounter = new IndexCounter(totalFramesCount);
            long timestamp = FramesPanel.this.getNextStamp();
            for (StackFrameProxyImpl stackFrameProxy : frames) {
                managerThread.schedule(new AppendFrameCommand(this.getSuspendContext(), stackFrameProxy, evaluationContext, tracker, index++, stackFrameProxy.equals(contextFrame), timestamp, indexCounter));
            }
        }
    }

    private class UpdateFramesListCommand
    extends SuspendContextCommandImpl {
        private final DebuggerContextImpl myDebuggerContext;

        public UpdateFramesListCommand(DebuggerContextImpl debuggerContext, SuspendContextImpl suspendContext) {
            super(suspendContext);
            this.myDebuggerContext = debuggerContext;
        }

        @Override
        public void contextAction() throws Exception {
            this.updateFrameList(this.myDebuggerContext.getThreadProxy());
            DebuggerInvocationUtil.swingInvokeLater(FramesPanel.this.getProject(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        FramesPanel.this.myFramesListener.setEnabled(false);
                        StackFrameProxyImpl contextFrame = UpdateFramesListCommand.this.getDebuggerContext().getFrameProxy();
                        if (contextFrame != null) {
                            FramesPanel.this.selectFrame(contextFrame);
                        }
                    }
                    finally {
                        FramesPanel.this.myFramesListener.setEnabled(true);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFrameList(ThreadReferenceProxyImpl thread) {
            try {
                if (!this.getSuspendContext().getDebugProcess().getSuspendManager().isSuspended(thread)) {
                    return;
                }
            }
            catch (ObjectCollectedException ignored) {
                return;
            }
            EvaluationContextImpl evaluationContext = this.getDebuggerContext().createEvaluationContext();
            ArrayList<StackFrameDescriptorImpl> descriptors = new ArrayList<StackFrameDescriptorImpl>();
            FramesList framesList = FramesPanel.this.myFramesList;
            synchronized (framesList) {
                DefaultListModel model = FramesPanel.this.myFramesList.getModel();
                int size = model.getSize();
                for (int i = 0; i < size; ++i) {
                    Object elem = model.getElementAt(i);
                    if (!(elem instanceof StackFrameDescriptorImpl)) continue;
                    descriptors.add((StackFrameDescriptorImpl)elem);
                }
            }
            for (StackFrameDescriptorImpl descriptor : descriptors) {
                descriptor.setContext(evaluationContext);
                descriptor.updateRepresentation(evaluationContext, DescriptorLabelListener.DUMMY_LISTENER);
            }
        }

        public DebuggerContextImpl getDebuggerContext() {
            return this.myDebuggerContext;
        }
    }

    private class RefreshFramePanelCommand
    extends DebuggerContextCommandImpl {
        private final boolean myRefreshOnly;
        private final ThreadDescriptorImpl[] myThreadDescriptorsToUpdate;

        public RefreshFramePanelCommand(boolean refreshOnly) {
            super(FramesPanel.this.getContext());
            this.myRefreshOnly = refreshOnly;
            if (refreshOnly) {
                int size = FramesPanel.this.myThreadsCombo.getItemCount();
                this.myThreadDescriptorsToUpdate = new ThreadDescriptorImpl[size];
                for (int idx = 0; idx < size; ++idx) {
                    this.myThreadDescriptorsToUpdate[idx] = (ThreadDescriptorImpl)FramesPanel.this.myThreadsCombo.getItemAt(idx);
                }
            } else {
                this.myThreadDescriptorsToUpdate = null;
            }
        }

        private List<ThreadDescriptorImpl> createThreadDescriptorsList() {
            ArrayList<ThreadReferenceProxyImpl> threads = new ArrayList<ThreadReferenceProxyImpl>(this.getSuspendContext().getDebugProcess().getVirtualMachineProxy().allThreads());
            Collections.sort(threads, ThreadReferenceProxyImpl.ourComparator);
            ArrayList<ThreadDescriptorImpl> descriptors = new ArrayList<ThreadDescriptorImpl>(threads.size());
            EvaluationContextImpl evaluationContext = this.getDebuggerContext().createEvaluationContext();
            for (ThreadReferenceProxyImpl thread : threads) {
                ThreadDescriptorImpl threadDescriptor = new ThreadDescriptorImpl(thread);
                threadDescriptor.setContext(evaluationContext);
                threadDescriptor.updateRepresentation(evaluationContext, DescriptorLabelListener.DUMMY_LISTENER);
                descriptors.add(threadDescriptor);
            }
            return descriptors;
        }

        @Override
        public void threadAction() {
            ThreadReferenceProxyImpl currentThread;
            if (this.myRefreshOnly && this.myThreadDescriptorsToUpdate.length != FramesPanel.this.myThreadsCombo.getItemCount()) {
                return;
            }
            DebuggerContextImpl context = this.getDebuggerContext();
            final ThreadReferenceProxyImpl threadToSelect = context.getThreadProxy();
            if (threadToSelect == null) {
                return;
            }
            SuspendContextImpl threadContext = SuspendManagerUtil.getSuspendContextForThread(context.getSuspendContext(), threadToSelect);
            ThreadDescriptorImpl currentThreadDescriptor = (ThreadDescriptorImpl)FramesPanel.this.myThreadsCombo.getSelectedItem();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = currentThread = currentThreadDescriptor != null ? currentThreadDescriptor.getThreadReference() : null;
            if (this.myRefreshOnly && threadToSelect.equals(currentThread)) {
                context.getDebugProcess().getManagerThread().schedule(new UpdateFramesListCommand(context, threadContext));
            } else {
                context.getDebugProcess().getManagerThread().schedule(new RebuildFramesListCommand(context, threadContext));
            }
            if (this.myRefreshOnly) {
                EvaluationContextImpl evaluationContext = context.createEvaluationContext();
                for (ThreadDescriptorImpl descriptor : this.myThreadDescriptorsToUpdate) {
                    descriptor.setContext(evaluationContext);
                    descriptor.updateRepresentation(evaluationContext, DescriptorLabelListener.DUMMY_LISTENER);
                }
                DebuggerInvocationUtil.swingInvokeLater(FramesPanel.this.getProject(), new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            FramesPanel.this.myThreadsListener.setEnabled(false);
                            FramesPanel.this.selectThread(threadToSelect);
                            FramesPanel.this.myFramesList.repaint();
                        }
                        finally {
                            FramesPanel.this.myThreadsListener.setEnabled(true);
                        }
                    }
                });
            } else {
                this.refillThreadsCombo(threadToSelect);
            }
        }

        @Override
        protected void commandCancelled() {
            if (!DebuggerManagerThreadImpl.isManagerThread()) {
                return;
            }
            DebuggerContextImpl context = this.getDebuggerContext();
            SuspendContextImpl suspendContext = context.getSuspendContext();
            if (suspendContext == null) {
                return;
            }
            ThreadReferenceProxyImpl threadToSelect = context.getThreadProxy();
            if (threadToSelect == null) {
                return;
            }
            if (!suspendContext.isResumed()) {
                SuspendContextImpl threadContext = SuspendManagerUtil.getSuspendContextForThread(suspendContext, threadToSelect);
                context.getDebugProcess().getManagerThread().schedule(new RebuildFramesListCommand(context, threadContext));
                this.refillThreadsCombo(threadToSelect);
            }
        }

        private void refillThreadsCombo(final ThreadReferenceProxyImpl threadToSelect) {
            final List<ThreadDescriptorImpl> threadItems = this.createThreadDescriptorsList();
            DebuggerInvocationUtil.swingInvokeLater(FramesPanel.this.getProject(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        FramesPanel.this.myThreadsListener.setEnabled(false);
                        FramesPanel.this.myThreadsCombo.removeAllItems();
                        for (ThreadDescriptorImpl threadItem : threadItems) {
                            FramesPanel.this.myThreadsCombo.addItem(threadItem);
                        }
                        FramesPanel.this.selectThread(threadToSelect);
                    }
                    finally {
                        FramesPanel.this.myThreadsListener.setEnabled(true);
                    }
                }
            });
        }
    }

    private class ThreadsListener
    implements ItemListener {
        boolean myIsEnabled = true;

        private ThreadsListener() {
        }

        public void setEnabled(boolean enabled) {
            this.myIsEnabled = enabled;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!this.myIsEnabled) {
                return;
            }
            if (e.getStateChange() == 1) {
                ThreadDescriptorImpl item = (ThreadDescriptorImpl)e.getItem();
                DebuggerContextUtil.setThread(FramesPanel.this.getContextManager(), item);
            }
        }
    }

    private class FramesListener
    implements ListSelectionListener {
        boolean myIsEnabled = true;

        private FramesListener() {
        }

        public void setEnabled(boolean enabled) {
            this.myIsEnabled = enabled;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!this.myIsEnabled || e.getValueIsAdjusting()) {
                return;
            }
            JList list = (JList)e.getSource();
            FramesPanel.this.processListValue(list.getSelectedValue());
        }
    }
}

