/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.InspectDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class InspectPanel
extends DebuggerTreePanel {
    public InspectPanel(Project project, DebuggerStateManager stateManager, @NotNull NodeDescriptorImpl inspectDescriptor) {
        if (inspectDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectDescriptor", "com/intellij/debugger/ui/impl/InspectPanel", "<init>"));
        }
        super(project, stateManager);
        this.getInspectTree().setInspectDescriptor(inspectDescriptor);
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.getInspectTree())), "Center");
        this.registerDisposable(DebuggerAction.installEditAction((JTree)((Object)this.getInspectTree()), "Debugger.EditNodeSource"));
        this.overrideShortcut((JComponent)((Object)this.getInspectTree()), "Debugger.CopyValue", CommonShortcuts.getCopy());
        this.setUpdateEnabled(true);
    }

    @Override
    protected void changeEvent(DebuggerContextImpl newContext, int event) {
        if (event != 12) {
            super.changeEvent(newContext, event);
        }
    }

    @Override
    protected DebuggerTree createTreeView() {
        return new InspectDebuggerTree(this.getProject());
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        return InspectDebuggerTree.createPopupMenu();
    }

    public InspectDebuggerTree getInspectTree() {
        return (InspectDebuggerTree)this.getTree();
    }
}

