/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.tree;

import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeBuilder
implements TreeModel {
    private final Object userObject;
    private TreeBuilderNode myRoot;
    private final EventDispatcher<TreeModelListener> myDispatcher = EventDispatcher.create(TreeModelListener.class);

    protected TreeBuilder(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public abstract void buildChildren(TreeBuilderNode var1);

    public abstract boolean isExpandable(TreeBuilderNode var1);

    public void setRoot(TreeBuilderNode root) {
        this.myRoot = root;
    }

    @Override
    public Object getRoot() {
        return this.myRoot;
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeBuilderNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeBuilderNode)node).isLeaf();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.myDispatcher.addListener((EventListener)l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.myDispatcher.removeListener((EventListener)l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeBuilderNode)parent).getChildAt(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeBuilderNode)parent).getIndex((TreeNode)child);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        TreeBuilderNode aNode = (TreeBuilderNode)path.getLastPathComponent();
        aNode.setUserObject(newValue);
        this.nodeChanged(aNode);
    }

    public void nodeChanged(TreeNode node) {
        TreeModelEvent event = null;
        TreeNode parent = node.getParent();
        if (parent != null) {
            int anIndex = parent.getIndex(node);
            event = new TreeModelEvent((Object)this, this.getPathToRoot(parent, 0), new int[]{anIndex}, new Object[]{node});
        } else if (node == this.getRoot()) {
            event = new TreeModelEvent((Object)this, this.getPathToRoot(node, 0), null, null);
        }
        if (event != null) {
            ((TreeModelListener)this.myDispatcher.getMulticaster()).treeNodesChanged(event);
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        TreeModelEvent event = new TreeModelEvent((Object)this, this.getPathToRoot(node, 0), null, null);
        ((TreeModelListener)this.myDispatcher.getMulticaster()).treeStructureChanged(event);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.myRoot ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public void removeNodeFromParent(TreeBuilderNode node) {
        TreeBuilderNode parent = (TreeBuilderNode)node.getParent();
        if (parent != null) {
            parent.remove(node);
        }
    }
}

