/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.impl;

import com.intellij.html.index.Html5CustomAttributesIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;

public class Html5CustomAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    @Override
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag tag) {
        if (tag == null || !HtmlUtil.isHtml5Context((XmlElement)tag)) {
            return XmlAttributeDescriptor.EMPTY;
        }
        ArrayList<String> currentAttrs = new ArrayList<String>();
        for (XmlAttribute attribute : tag.getAttributes()) {
            currentAttrs.add(attribute.getName());
        }
        ArrayList<AnyXmlAttributeDescriptor> result = new ArrayList<AnyXmlAttributeDescriptor>();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)tag.getProject());
        Collection keys = FileBasedIndex.getInstance().getAllKeys(Html5CustomAttributesIndex.INDEX_ID, tag.getProject());
        for (String key : keys) {
            boolean canProcessKey;
            boolean bl = canProcessKey = !FileBasedIndex.getInstance().processValues(Html5CustomAttributesIndex.INDEX_ID, (Object)key, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>(){

                public boolean process(VirtualFile file, Void value) {
                    return false;
                }
            }, scope);
            if (!canProcessKey) continue;
            boolean add = true;
            for (String attr : currentAttrs) {
                if (!attr.startsWith(key)) continue;
                add = false;
            }
            if (!add) continue;
            result.add(new AnyXmlAttributeDescriptor(key));
        }
        return result.toArray(new XmlAttributeDescriptor[result.size()]);
    }

    @Override
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        if (context != null && HtmlUtil.isCustomHtml5Attribute(attributeName) && HtmlUtil.tagHasHtml5Schema(context)) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        return null;
    }
}

