/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerChange;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorWindow {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorWindow");
    public static final DataKey<EditorWindow> DATA_KEY = DataKey.create((String)"editorWindow");
    protected JPanel myPanel;
    private EditorTabbedContainer myTabbedPane;
    private final EditorsSplitters myOwner;
    private static final Icon MODIFIED_ICON = !UISettings.getInstance().HIDE_TABS_IF_NEED ? new Icon(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            Font oldFont = g.getFont();
            try {
                g.setFont(UIUtil.getLabelFont());
                g.setColor(JBColor.foreground());
                g.drawString("*", 0, 10);
            }
            finally {
                config.restore();
                g.setFont(oldFont);
            }
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    } : AllIcons.General.Modified;
    private static final Icon GAP_ICON = new EmptyIcon(MODIFIED_ICON.getIconWidth(), MODIFIED_ICON.getIconHeight());
    private boolean myIsDisposed = false;
    public static final Key<Integer> INITIAL_INDEX_KEY = Key.create((String)"initial editor index");
    private final Stack<Pair<String, Integer>> myRemovedTabs = new Stack<Pair<String, Integer>>(){

        public void push(Pair<String, Integer> pair) {
            if (this.size() >= UISettings.getInstance().EDITOR_TAB_LIMIT) {
                this.remove(0);
            }
            super.push(pair);
        }
    };
    private AtomicBoolean myTabsHidingInProgress = new AtomicBoolean(false);
    private final Stack<Pair<String, Integer>> myHiddenTabs = new Stack();

    protected EditorWindow(EditorsSplitters owner) {
        this.myOwner = owner;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setBorder(new AdaptiveBorder());
        this.myPanel.setOpaque(false);
        this.myTabbedPane = null;
        int tabPlacement = UISettings.getInstance().EDITOR_TAB_PLACEMENT;
        if (tabPlacement != 0 && !UISettings.getInstance().PRESENTATION_MODE) {
            this.createTabs(tabPlacement);
        }
        if (UISettings.getInstance().SCROLL_TAB_LAYOUT_IN_EDITOR) {
            this.setTabLayoutPolicy(1);
        } else {
            this.setTabLayoutPolicy(0);
        }
        this.myOwner.addWindow(this);
        if (this.myOwner.getCurrentWindow() == null) {
            this.myOwner.setCurrentWindow(this, false);
        }
    }

    private void createTabs(int tabPlacement) {
        LOG.assertTrue(this.myTabbedPane == null);
        this.myTabbedPane = new EditorTabbedContainer(this, this.getManager().getProject(), tabPlacement);
        this.myPanel.add(this.myTabbedPane.getComponent(), "Center");
    }

    public boolean isShowing() {
        return this.myPanel.isShowing();
    }

    public void closeAllExcept(VirtualFile selectedFile) {
        VirtualFile[] files;
        for (VirtualFile file : files = this.getFiles()) {
            if (Comparing.equal((Object)file, (Object)selectedFile) || this.isFilePinned(file)) continue;
            this.closeFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        try {
            this.disposeTabs();
            this.myOwner.removeWindow(this);
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    private void disposeTabs() {
        if (this.myTabbedPane != null) {
            Disposer.dispose((Disposable)this.myTabbedPane);
            this.myTabbedPane = null;
        }
        this.myPanel.removeAll();
        this.myPanel.revalidate();
    }

    public void closeFile(VirtualFile file) {
        this.closeFile(file, true);
    }

    public void closeFile(VirtualFile file, boolean disposeIfNeeded) {
        this.closeFile(file, disposeIfNeeded, true);
    }

    public boolean hasClosedTabs() {
        return !this.myRemovedTabs.empty();
    }

    public void restoreClosedTab() {
        assert (this.hasClosedTabs()) : "Nothing to restore";
        Pair info = (Pair)this.myRemovedTabs.pop();
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl((String)info.getFirst());
        Integer second = (Integer)info.getSecond();
        if (file != null) {
            this.getManager().openFileImpl4(this, file, null, true, true, null, second == null ? -1 : second);
        }
    }

    private void restoreHiddenTabs() {
        while (!this.myHiddenTabs.isEmpty()) {
            Pair info = (Pair)this.myHiddenTabs.pop();
            this.myRemovedTabs.remove((Object)info);
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl((String)info.getFirst());
            Integer second = (Integer)info.getSecond();
            if (file == null) continue;
            this.getManager().openFileImpl4(this, file, null, true, true, null, second == null ? -1 : second);
        }
    }

    public void closeFile(final @NotNull VirtualFile file, final boolean disposeIfNeeded, final boolean transferFocus) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorWindow", "closeFile"));
        }
        final FileEditorManagerImpl editorManager = this.getManager();
        editorManager.runChange(new FileEditorManagerChange(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(EditorsSplitters splitters) {
                List<EditorWithProviderComposite> editors = splitters.findEditorComposites(file);
                if (editors.isEmpty()) {
                    return;
                }
                try {
                    EditorWithProviderComposite editor = EditorWindow.this.findFileComposite(file);
                    FileEditorManagerListener.Before beforePublisher = (FileEditorManagerListener.Before)editorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER);
                    beforePublisher.beforeFileClosed((FileEditorManager)editorManager, file);
                    if (EditorWindow.this.myTabbedPane != null && editor != null) {
                        int componentIndex = EditorWindow.this.findComponentIndex(editor.getComponent());
                        if (componentIndex >= 0) {
                            int indexToSelect = EditorWindow.this.calcIndexToSelect(file, componentIndex);
                            Pair pair = Pair.create((Object)file.getUrl(), (Object)componentIndex);
                            EditorWindow.this.myRemovedTabs.push((Object)pair);
                            if (EditorWindow.this.myTabsHidingInProgress.get()) {
                                EditorWindow.this.myHiddenTabs.push((Object)pair);
                            }
                            EditorWindow.this.myTabbedPane.removeTabAt(componentIndex, indexToSelect, transferFocus);
                            editorManager.disposeComposite(editor);
                        }
                    } else {
                        EditorWindow.this.myPanel.removeAll();
                        if (editor != null) {
                            editorManager.disposeComposite(editor);
                        }
                    }
                    if (disposeIfNeeded && EditorWindow.this.getTabCount() == 0) {
                        ThreeComponentsSplitter splitter;
                        EditorsSplitters owner;
                        EditorWindow.this.removeFromSplitter();
                        if (UISettings.getInstance().EDITOR_TAB_PLACEMENT == 0 && (owner = EditorWindow.this.getOwner()) != null && (splitter = (ThreeComponentsSplitter)UIUtil.getParentOfType(ThreeComponentsSplitter.class, (Component)((Object)owner))) != null) {
                            splitter.revalidate();
                            splitter.repaint();
                        }
                    } else {
                        EditorWindow.this.myPanel.revalidate();
                        if (EditorWindow.this.myTabbedPane == null) {
                            EditorWindow.this.myPanel.repaint();
                        }
                    }
                    editorManager.removeSelectionRecord(file, EditorWindow.this);
                    editorManager.notifyPublisher(new Runnable(){

                        @Override
                        public void run() {
                            Project project = editorManager.getProject();
                            if (!project.isDisposed()) {
                                FileEditorManagerListener afterPublisher = (FileEditorManagerListener)project.getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
                                afterPublisher.fileClosed((FileEditorManager)editorManager, file);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    editorManager.removeSelectionRecord(file, EditorWindow.this);
                    editorManager.notifyPublisher(new /* invalid duplicate definition of identical inner class */);
                    splitters.afterFileClosed(file);
                    throw throwable;
                }
                splitters.afterFileClosed(file);
            }
        }, this.myOwner);
    }

    private void removeFromSplitter() {
        if (!this.inSplitter()) {
            return;
        }
        if (this.myOwner.getCurrentWindow() == this) {
            EditorWindow[] siblings = this.findSiblings();
            this.myOwner.setCurrentWindow(siblings[0], false);
        }
        Splitter splitter = (Splitter)this.myPanel.getParent();
        JComponent otherComponent = splitter.getOtherComponent((Component)this.myPanel);
        Container parent = splitter.getParent().getParent();
        if (parent instanceof Splitter) {
            Splitter parentSplitter = (Splitter)parent;
            if (parentSplitter.getFirstComponent() == splitter.getParent()) {
                parentSplitter.setFirstComponent(otherComponent);
            } else {
                parentSplitter.setSecondComponent(otherComponent);
            }
        } else if (parent instanceof EditorsSplitters) {
            parent.removeAll();
            parent.add((Component)otherComponent, "Center");
            ((JComponent)parent).revalidate();
        } else {
            throw new IllegalStateException("Unknown container: " + parent);
        }
        this.dispose();
    }

    private int calcIndexToSelect(VirtualFile fileBeingClosed, int fileIndex) {
        int currentlySelectedIndex = this.myTabbedPane.getSelectedIndex();
        if (currentlySelectedIndex != fileIndex) {
            return currentlySelectedIndex;
        }
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.ACTIVATE_MRU_EDITOR_ON_CLOSE) {
            VirtualFile[] histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFiles();
            for (int idx = histFiles.length - 1; idx >= 0; --idx) {
                int histFileIndex;
                EditorWithProviderComposite editor;
                VirtualFile histFile = histFiles[idx];
                if (histFile.equals(fileBeingClosed) || (editor = this.findFileComposite(histFile)) == null || (histFileIndex = this.findComponentIndex(editor.getComponent())) < 0) continue;
                return histFileIndex;
            }
        } else if (uiSettings.ACTIVATE_RIGHT_EDITOR_ON_CLOSE && fileIndex + 1 < this.myTabbedPane.getTabCount()) {
            return fileIndex + 1;
        }
        if (fileIndex > 0) {
            return fileIndex - 1;
        }
        return -1;
    }

    public FileEditorManagerImpl getManager() {
        return this.myOwner.getManager();
    }

    public int getTabCount() {
        if (this.myTabbedPane != null) {
            return this.myTabbedPane.getTabCount();
        }
        return this.myPanel.getComponentCount();
    }

    public void setForegroundAt(int index, Color color) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setForegroundAt(index, color);
        }
    }

    public void setWaveColor(int index, @Nullable Color color) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setWaveColor(index, color);
        }
    }

    private void setIconAt(int index, Icon icon) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setIconAt(index, icon);
        }
    }

    private void setTitleAt(int index, String text) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setTitleAt(index, text);
        }
    }

    private void setBackgroundColorAt(int index, Color color) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setBackgroundColorAt(index, color);
        }
    }

    private void setToolTipTextAt(int index, String text) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setToolTipTextAt(index, text);
        }
    }

    public void setTabLayoutPolicy(int policy) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setTabLayoutPolicy(policy);
        }
    }

    public void setTabsPlacement(int tabPlacement) {
        if (tabPlacement != 0 && !UISettings.getInstance().PRESENTATION_MODE) {
            if (this.myTabbedPane == null) {
                EditorWithProviderComposite editor = this.getSelectedEditor();
                this.myPanel.removeAll();
                this.createTabs(tabPlacement);
                this.restoreHiddenTabs();
                this.setEditor(editor, true);
            } else {
                this.myTabbedPane.setTabPlacement(tabPlacement);
            }
        } else if (this.myTabbedPane != null) {
            boolean focusEditor = ToolWindowManager.getInstance((Project)this.getManager().getProject()).isEditorComponentActive();
            VirtualFile currentFile = this.getSelectedFile();
            if (currentFile != null) {
                currentFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)Boolean.TRUE);
            }
            VirtualFile[] files = this.getFiles();
            this.myHiddenTabs.clear();
            this.myTabsHidingInProgress.set(true);
            for (VirtualFile file : files) {
                this.closeFile(file, false);
            }
            this.getManager().runChange(new FileEditorManagerChange(){

                @Override
                public void run(EditorsSplitters splitters) {
                    EditorWindow.this.myTabsHidingInProgress.set(false);
                }
            }, this.myOwner);
            this.disposeTabs();
            if (currentFile != null) {
                currentFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
                this.getManager().openFileImpl2(this, currentFile, focusEditor && this.myOwner.getCurrentWindow() == this);
            } else {
                this.myPanel.repaint();
            }
        }
    }

    public void setAsCurrentWindow(boolean requestFocus) {
        this.myOwner.setCurrentWindow(this, requestFocus);
    }

    public void updateFileBackgroundColor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorWindow", "updateFileBackgroundColor"));
        }
        int index = this.findEditorIndex(this.findFileComposite(file));
        if (index != -1) {
            Color color = EditorTabbedContainer.calcTabColor(this.getManager().getProject(), file);
            this.setBackgroundColorAt(index, color);
        }
    }

    public EditorsSplitters getOwner() {
        return this.myOwner;
    }

    public boolean isEmptyVisible() {
        return this.myTabbedPane != null ? this.myTabbedPane.isEmptyVisible() : this.getFiles().length == 0;
    }

    public Dimension getSize() {
        return this.myPanel.getSize();
    }

    @Nullable
    public EditorTabbedContainer getTabbedPane() {
        return this.myTabbedPane;
    }

    public void requestFocus(boolean forced) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.requestFocus(forced);
        } else {
            EditorWithProviderComposite editor = this.getSelectedEditor();
            JComponent preferred = editor == null ? null : editor.getPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)(preferred == null ? this.myPanel : preferred)).requestFocus((Component)this.myPanel, forced);
        }
    }

    public boolean isValid() {
        return this.myPanel.isShowing();
    }

    public void setPaintBlocked(boolean blocked) {
        if (this.myTabbedPane != null) {
            this.myTabbedPane.setPaintBlocked(blocked);
        }
    }

    private void checkConsistency() {
        LOG.assertTrue(this.myOwner.containsWindow(this), (Object)"EditorWindow not in collection");
    }

    public EditorWithProviderComposite getSelectedEditor() {
        TComp comp;
        if (this.myTabbedPane != null) {
            comp = (TComp)this.myTabbedPane.getSelectedComponent();
        } else if (this.myPanel.getComponentCount() != 0) {
            Component component = this.myPanel.getComponent(0);
            comp = component instanceof TComp ? (TComp)component : null;
        } else {
            return null;
        }
        if (comp != null) {
            return comp.myEditor;
        }
        return null;
    }

    public EditorWithProviderComposite[] getEditors() {
        int tabCount = this.getTabCount();
        EditorWithProviderComposite[] res = new EditorWithProviderComposite[tabCount];
        for (int i = 0; i != tabCount; ++i) {
            res[i] = this.getEditorAt(i);
        }
        return res;
    }

    public VirtualFile[] getFiles() {
        int tabCount = this.getTabCount();
        VirtualFile[] res = new VirtualFile[tabCount];
        for (int i = 0; i != tabCount; ++i) {
            res[i] = this.getEditorAt(i).getFile();
        }
        return res;
    }

    public void setSelectedEditor(EditorComposite editor, final boolean focusEditor) {
        int index;
        if (this.myTabbedPane == null) {
            return;
        }
        if (editor != null && (index = this.findFileIndex(editor.getFile())) != -1) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (EditorWindow.this.myTabbedPane != null) {
                        EditorWindow.this.myTabbedPane.setSelectedIndex(index, focusEditor);
                    }
                }
            });
        }
    }

    public void setEditor(@Nullable EditorWithProviderComposite editor, boolean focusEditor) {
        this.setEditor(editor, true, focusEditor);
    }

    public void setEditor(@Nullable EditorWithProviderComposite editor, boolean selectEditor, boolean focusEditor) {
        if (editor != null) {
            this.onBeforeSetEditor(editor.getFile());
            if (this.myTabbedPane == null) {
                this.myPanel.removeAll();
                this.myPanel.add((Component)new TCompForTablessMode(this, editor), "Center");
                this.myOwner.validate();
                return;
            }
            int index = this.findEditorIndex(editor);
            if (index != -1) {
                if (selectEditor) {
                    this.setSelectedEditor(editor, focusEditor);
                }
            } else {
                Integer initialIndex = (Integer)editor.getFile().getUserData(INITIAL_INDEX_KEY);
                int indexToInsert = 0;
                if (Registry.is((String)"ide.editor.tabs.open.at.the.end")) {
                    indexToInsert = this.myTabbedPane.getTabCount();
                } else if (initialIndex == null) {
                    int selectedIndex = this.myTabbedPane.getSelectedIndex();
                    if (selectedIndex >= 0) {
                        indexToInsert = selectedIndex + 1;
                    }
                } else {
                    indexToInsert = initialIndex;
                }
                VirtualFile file = editor.getFile();
                Icon template = AllIcons.FileTypes.Text;
                this.myTabbedPane.insertTab(file, (Icon)new EmptyIcon(template.getIconWidth(), template.getIconHeight()), new TComp(this, editor), null, indexToInsert);
                this.trimToSize(UISettings.getInstance().EDITOR_TAB_LIMIT, file, false);
                if (selectEditor) {
                    this.setSelectedEditor(editor, focusEditor);
                }
                this.myOwner.updateFileIcon(file);
                this.myOwner.updateFileColor(file);
            }
            this.myOwner.setCurrentWindow(this, false);
        }
        this.myOwner.validate();
    }

    protected void onBeforeSetEditor(VirtualFile file) {
    }

    private boolean splitAvailable() {
        return this.getTabCount() >= 1;
    }

    @Nullable
    public EditorWindow split(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile, boolean focusNew) {
        this.checkConsistency();
        FileEditorManagerImpl fileEditorManager = this.myOwner.getManager();
        if (this.splitAvailable()) {
            if (!forceSplit && this.inSplitter()) {
                EditorWindow[] siblings = this.findSiblings();
                EditorWindow target = siblings[0];
                if (virtualFile != null) {
                    FileEditor[] editors = (FileEditor[])fileEditorManager.openFileImpl3((EditorWindow)target, (VirtualFile)virtualFile, (boolean)focusNew, null, (boolean)true).first;
                    this.syncCaretIfPossible(editors);
                }
                return target;
            }
            JPanel panel = this.myPanel;
            panel.setBorder(null);
            int tabCount = this.getTabCount();
            if (tabCount != 0) {
                EditorWithProviderComposite firstEC = this.getEditorAt(0);
                this.myPanel = new JPanel(new BorderLayout());
                this.myPanel.setOpaque(false);
                this.myPanel.setBorder(new AdaptiveBorder());
                this.myPanel.setOpaque(false);
                Splitter splitter = new Splitter(orientation == 0, 0.5f, 0.1f, 0.9f);
                EditorWindow res = new EditorWindow(this.myOwner);
                if (this.myTabbedPane != null) {
                    EditorWithProviderComposite selectedEditor = this.getSelectedEditor();
                    panel.remove(this.myTabbedPane.getComponent());
                    panel.add((Component)splitter, "Center");
                    splitter.setFirstComponent((JComponent)this.myPanel);
                    this.myPanel.add(this.myTabbedPane.getComponent(), "Center");
                    splitter.setSecondComponent((JComponent)res.myPanel);
                    VirtualFile file = selectedEditor.getFile();
                    if (virtualFile == null) {
                        for (FileEditorAssociateFinder finder : (FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)) {
                            VirtualFile associatedFile = finder.getAssociatedFileToOpen(fileEditorManager.getProject(), file);
                            if (associatedFile == null) continue;
                            virtualFile = associatedFile;
                            break;
                        }
                    }
                    VirtualFile nextFile = virtualFile == null ? file : virtualFile;
                    FileEditor[] editors = (FileEditor[])fileEditorManager.openFileImpl3((EditorWindow)res, (VirtualFile)nextFile, (boolean)focusNew, null, (boolean)true).first;
                    this.syncCaretIfPossible(editors);
                    res.setFilePinned(nextFile, this.isFilePinned(file));
                    if (!focusNew) {
                        res.setSelectedEditor(selectedEditor, true);
                        selectedEditor.getComponent().requestFocus();
                    }
                    panel.revalidate();
                } else {
                    panel.removeAll();
                    panel.add((Component)splitter, "Center");
                    splitter.setFirstComponent((JComponent)this.myPanel);
                    splitter.setSecondComponent((JComponent)res.myPanel);
                    panel.revalidate();
                    VirtualFile firstFile = firstEC.getFile();
                    VirtualFile nextFile = virtualFile == null ? firstFile : virtualFile;
                    FileEditor[] firstEditors = (FileEditor[])fileEditorManager.openFileImpl3((EditorWindow)this, (VirtualFile)firstFile, (boolean)(!focusNew ? true : false), null, (boolean)true).first;
                    this.syncCaretIfPossible(firstEditors);
                    FileEditor[] secondEditors = (FileEditor[])fileEditorManager.openFileImpl3((EditorWindow)res, (VirtualFile)nextFile, (boolean)focusNew, null, (boolean)true).first;
                    this.syncCaretIfPossible(secondEditors);
                }
                return res;
            }
        }
        return null;
    }

    private void syncCaretIfPossible(@Nullable FileEditor[] toSync) {
        if (toSync == null) {
            return;
        }
        EditorWithProviderComposite from = this.getSelectedEditor();
        if (from == null) {
            return;
        }
        FileEditor caretSource = from.getSelectedEditor();
        if (!(caretSource instanceof TextEditor)) {
            return;
        }
        Editor editorFrom = ((TextEditor)caretSource).getEditor();
        int offset = editorFrom.getCaretModel().getOffset();
        if (offset <= 0) {
            return;
        }
        int scrollOffset = editorFrom.getScrollingModel().getVerticalScrollOffset();
        for (FileEditor fileEditor : toSync) {
            if (!(fileEditor instanceof TextEditor)) continue;
            final Editor editor = ((TextEditor)fileEditor).getEditor();
            if (editorFrom.getDocument() != editor.getDocument()) continue;
            editor.getCaretModel().moveToOffset(offset);
            final ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.scrollVertically(scrollOffset);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!editor.isDisposed()) {
                        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
                    }
                }
            });
        }
    }

    public EditorWindow[] findSiblings() {
        this.checkConsistency();
        ArrayList<EditorWindow> res = new ArrayList<EditorWindow>();
        if (this.myPanel.getParent() instanceof Splitter) {
            Splitter splitter = (Splitter)this.myPanel.getParent();
            for (EditorWindow win : this.myOwner.getWindows()) {
                if (win == this || !SwingUtilities.isDescendingFrom(win.myPanel, (Component)splitter)) continue;
                res.add(win);
            }
        }
        return res.toArray(new EditorWindow[res.size()]);
    }

    public void changeOrientation() {
        this.checkConsistency();
        Container parent = this.myPanel.getParent();
        if (parent instanceof Splitter) {
            Splitter splitter;
            splitter.setOrientation(!(splitter = (Splitter)parent).getOrientation());
        }
    }

    protected void updateFileIcon(VirtualFile file) {
        int index = this.findEditorIndex(this.findFileComposite(file));
        LOG.assertTrue(index != -1);
        this.setIconAt(index, this.getFileIcon(file));
    }

    protected void updateFileName(VirtualFile file) {
        int index = this.findEditorIndex(this.findFileComposite(file));
        if (index != -1) {
            this.setTitleAt(index, EditorTabbedContainer.calcTabTitle(this.getManager().getProject(), file));
            this.setToolTipTextAt(index, UISettings.getInstance().SHOW_TABS_TOOLTIPS ? this.getManager().getFileTooltipText(file) : null);
        }
    }

    private Icon getFileIcon(@NotNull VirtualFile file) {
        Icon modifiedIcon;
        Icon pinIcon;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorWindow", "getFileIcon"));
        }
        if (!file.isValid()) {
            Icon fakeIcon = FileTypes.UNKNOWN.getIcon();
            assert (fakeIcon != null) : "Can't find the icon for unknown file type";
            return fakeIcon;
        }
        Icon baseIcon = IconUtil.getIcon((VirtualFile)file, (int)2, (Project)this.getManager().getProject());
        int count = 1;
        EditorWithProviderComposite composite = this.findFileComposite(file);
        if (composite != null && composite.isPinned()) {
            ++count;
            pinIcon = AllIcons.Nodes.TabPin;
        } else {
            pinIcon = null;
        }
        if (UISettings.getInstance().MARK_MODIFIED_TABS_WITH_ASTERISK || !UISettings.getInstance().HIDE_TABS_IF_NEED) {
            modifiedIcon = UISettings.getInstance().MARK_MODIFIED_TABS_WITH_ASTERISK && composite != null && ((EditorComposite)composite).isModified() ? MODIFIED_ICON : GAP_ICON;
            ++count;
        } else {
            modifiedIcon = null;
        }
        if (count == 1) {
            return baseIcon;
        }
        int i = 0;
        LayeredIcon result = new LayeredIcon(count);
        int xShift = !UISettings.getInstance().HIDE_TABS_IF_NEED ? 4 : 0;
        result.setIcon(baseIcon, i++, xShift, 0);
        if (pinIcon != null) {
            result.setIcon(pinIcon, i++, xShift, 0);
        }
        if (modifiedIcon != null) {
            result.setIcon(modifiedIcon, i++);
        }
        return result;
    }

    public void unsplit(boolean setCurrent) {
        this.checkConsistency();
        Container splitter = this.myPanel.getParent();
        if (!(splitter instanceof Splitter)) {
            return;
        }
        EditorWithProviderComposite editorToSelect = this.getSelectedEditor();
        EditorWindow[] siblings = this.findSiblings();
        JPanel parent = (JPanel)splitter.getParent();
        for (EditorWindow eachSibling : siblings) {
            EditorWithProviderComposite selected = eachSibling.getSelectedEditor();
            if (editorToSelect != null) continue;
            editorToSelect = selected;
        }
        for (EditorWindow sibling : siblings) {
            EditorWithProviderComposite[] siblingEditors;
            for (EditorWithProviderComposite siblingEditor : siblingEditors = sibling.getEditors()) {
                if (editorToSelect == null) {
                    editorToSelect = siblingEditor;
                }
                this.processSiblingEditor(siblingEditor);
            }
            LOG.assertTrue(sibling != this);
            sibling.dispose();
        }
        parent.remove(splitter);
        if (this.myTabbedPane != null) {
            parent.add(this.myTabbedPane.getComponent(), "Center");
        } else if (this.myPanel.getComponentCount() > 0) {
            parent.add(this.myPanel.getComponent(0), "Center");
        }
        parent.revalidate();
        this.myPanel = parent;
        if (editorToSelect != null) {
            this.setSelectedEditor(editorToSelect, true);
        }
        if (setCurrent) {
            this.myOwner.setCurrentWindow(this, false);
        }
    }

    private void processSiblingEditor(EditorWithProviderComposite siblingEditor) {
        if (this.myTabbedPane != null && this.getTabCount() < UISettings.getInstance().EDITOR_TAB_LIMIT && this.findFileComposite(siblingEditor.getFile()) == null) {
            this.setEditor(siblingEditor, true);
        } else if (this.myTabbedPane == null && this.getTabCount() == 0) {
            this.setEditor(siblingEditor, true);
        } else {
            this.getManager().disposeComposite(siblingEditor);
        }
    }

    public void unsplitAll() {
        this.checkConsistency();
        while (this.inSplitter()) {
            this.unsplit(true);
        }
    }

    public boolean inSplitter() {
        this.checkConsistency();
        return this.myPanel.getParent() instanceof Splitter;
    }

    public VirtualFile getSelectedFile() {
        this.checkConsistency();
        EditorWithProviderComposite editor = this.getSelectedEditor();
        return editor == null ? null : editor.getFile();
    }

    @Nullable
    public EditorWithProviderComposite findFileComposite(VirtualFile file) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.getFile().equals(file)) continue;
            return editor;
        }
        return null;
    }

    public int findComponentIndex(Component component) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.getComponent().equals(component)) continue;
            return i;
        }
        return -1;
    }

    public int findEditorIndex(EditorComposite editorToFind) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.equals(editorToFind)) continue;
            return i;
        }
        return -1;
    }

    public int findFileIndex(VirtualFile fileToFind) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            VirtualFile file = this.getFileAt(i);
            if (!file.equals(fileToFind)) continue;
            return i;
        }
        return -1;
    }

    private EditorWithProviderComposite getEditorAt(int i) {
        TComp comp;
        if (this.myTabbedPane != null) {
            comp = (TComp)this.myTabbedPane.getComponentAt(i);
        } else {
            LOG.assertTrue(i <= 1);
            comp = (TComp)this.myPanel.getComponent(i);
        }
        return comp.myEditor;
    }

    public boolean isFileOpen(VirtualFile file) {
        return this.findFileComposite(file) != null;
    }

    public boolean isFilePinned(VirtualFile file) {
        EditorWithProviderComposite editorComposite = this.findFileComposite(file);
        if (editorComposite == null) {
            throw new IllegalArgumentException("file is not open: " + file.getPath());
        }
        return editorComposite.isPinned();
    }

    public void setFilePinned(VirtualFile file, boolean pinned) {
        EditorWithProviderComposite editorComposite = this.findFileComposite(file);
        if (editorComposite == null) {
            throw new IllegalArgumentException("file is not open: " + file.getPath());
        }
        boolean wasPinned = editorComposite.isPinned();
        editorComposite.setPinned(pinned);
        if (wasPinned != pinned && ApplicationManager.getApplication().isDispatchThread()) {
            this.updateFileIcon(file);
        }
    }

    void trimToSize(final int limit, final @Nullable VirtualFile fileToIgnore, final boolean transferFocus) {
        if (this.myTabbedPane == null) {
            return;
        }
        FileEditorManagerEx.getInstanceEx(this.getManager().getProject()).getReady(this).doWhenDone(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (EditorWindow.this.myTabbedPane == null) {
                    return;
                }
                boolean closeNonModifiedFilesFirst = UISettings.getInstance().CLOSE_NON_MODIFIED_FILES_FIRST;
                EditorWithProviderComposite selectedComposite = EditorWindow.this.getSelectedEditor();
                try {
                    EditorWindow.this.doTrimSize(limit, fileToIgnore, closeNonModifiedFilesFirst, transferFocus);
                }
                finally {
                    EditorWindow.this.setSelectedEditor(selectedComposite, false);
                }
            }
        });
    }

    private void doTrimSize(int limit, @Nullable VirtualFile fileToIgnore, boolean closeNonModifiedFilesFirst, boolean transferFocus) {
        LinkedHashSet<VirtualFile> closingOrder = this.getTabClosingOrder(closeNonModifiedFilesFirst);
        for (VirtualFile file : closingOrder) {
            if (this.myTabbedPane.getTabCount() <= limit || this.myTabbedPane.getTabCount() == 0 || this.areAllTabsPinned(fileToIgnore)) {
                return;
            }
            if (!this.fileCanBeClosed(file, fileToIgnore)) continue;
            this.defaultCloseFile(file, transferFocus);
        }
    }

    private LinkedHashSet<VirtualFile> getTabClosingOrder(boolean closeNonModifiedFilesFirst) {
        VirtualFile[] allFiles = this.getFiles();
        LinkedHashSet<VirtualFile> histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFileSet();
        LinkedHashSet closingOrder = ContainerUtil.newLinkedHashSet();
        for (VirtualFile file : allFiles) {
            if (histFiles.contains(file)) continue;
            closingOrder.add(file);
        }
        if (closeNonModifiedFilesFirst) {
            for (VirtualFile file : histFiles) {
                if (!EditorWindow.isFileModified(this.findFileComposite(file), file)) continue;
                closingOrder.add(file);
            }
            for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                VirtualFile file = this.getFileAt(i);
                if (!EditorWindow.isFileModified(this.getEditorAt(i), file)) continue;
                closingOrder.add(file);
            }
        }
        closingOrder.addAll(histFiles);
        for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
            closingOrder.add(this.getFileAt(i));
        }
        VirtualFile selectedFile = this.getSelectedFile();
        closingOrder.remove(selectedFile);
        closingOrder.add(selectedFile);
        return closingOrder;
    }

    private static boolean isFileModified(EditorComposite composite, VirtualFile file) {
        return composite != null && (composite.getInitialFileTimeStamp() == file.getTimeStamp() || composite.isModified());
    }

    private boolean areAllTabsPinned(VirtualFile fileToIgnore) {
        for (int i = this.myTabbedPane.getTabCount() - 1; i >= 0; --i) {
            if (!this.fileCanBeClosed(this.getFileAt(i), fileToIgnore)) continue;
            return false;
        }
        return true;
    }

    private void defaultCloseFile(VirtualFile file, boolean transferFocus) {
        this.closeFile(file, true, transferFocus);
    }

    private boolean fileCanBeClosed(VirtualFile file, @Nullable VirtualFile fileToIgnore) {
        return this.isFileOpen(file) && !file.equals(fileToIgnore) && !this.isFilePinned(file);
    }

    protected VirtualFile getFileAt(int i) {
        return this.getEditorAt(i).getFile();
    }

    public String toString() {
        return "EditorWindow: files=" + Arrays.asList(this.getFiles());
    }

    protected static class TCompForTablessMode
    extends TComp
    implements CloseAction.CloseTarget {
        TCompForTablessMode(@NotNull EditorWindow window, @NotNull EditorWithProviderComposite editor) {
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/EditorWindow$TCompForTablessMode", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/EditorWindow$TCompForTablessMode", "<init>"));
            }
            super(window, editor);
        }

        @Override
        public Object getData(String dataId) {
            if (DATA_KEY.is(dataId)) {
                return this.myWindow;
            }
            if (CloseAction.CloseTarget.KEY.is(dataId)) {
                return this;
            }
            return super.getData(dataId);
        }

        @Override
        public void close() {
            this.myWindow.closeFile(this.myEditor.getFile());
        }
    }

    protected static class TComp
    extends JPanel
    implements DataProvider,
    EditorWindowHolder {
        @NotNull
        final EditorWithProviderComposite myEditor;
        protected final EditorWindow myWindow;

        TComp(@NotNull EditorWindow window, @NotNull EditorWithProviderComposite editor) {
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp", "<init>"));
            }
            super(new BorderLayout());
            this.myEditor = editor;
            this.myWindow = window;
            this.add((Component)editor.getComponent(), "Center");
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!TComp.this.hasFocus()) {
                                return;
                            }
                            JComponent focus = ((FileEditor)TComp.this.myEditor.getSelectedEditorWithProvider().getFirst()).getPreferredFocusedComponent();
                            if (focus != null && !focus.hasFocus()) {
                                IdeFocusManager.getGlobalInstance().requestFocus((Component)focus, true);
                            }
                        }
                    });
                }
            });
        }

        @Override
        @NotNull
        public EditorWindow getEditorWindow() {
            EditorWindow editorWindow = this.myWindow;
            if (editorWindow == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp", "getEditorWindow"));
            }
            return editorWindow;
        }

        public Object getData(String dataId) {
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile virtualFile = this.myEditor.getFile();
                return virtualFile.isValid() ? virtualFile : null;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myEditor.getFileEditorManager().getProject();
            }
            return null;
        }
    }

    private static class AdaptiveBorder
    implements Border {
        private AdaptiveBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = ((JComponent)c).getInsets();
            g.setColor(UIUtil.getPanelBackground());
            AdaptiveBorder.paintBorder(g, x, y, width, height, insets);
            g.setColor(new Color(0, 0, 0, 90));
            AdaptiveBorder.paintBorder(g, x, y, width, height, insets);
        }

        private static void paintBorder(Graphics g, int x, int y, int width, int height, Insets insets) {
            if (insets.left == 1) {
                g.drawLine(x, y, x, y + height);
            }
            if (insets.right == 1) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height);
            }
            if (insets.bottom == 1) {
                g.drawLine(x, y + height - 1, x + width, y + height - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Container parent = c.getParent();
            if (parent instanceof Splitter) {
                boolean editorToTheLeft = false;
                boolean editorToTheRight = false;
                boolean editorToTheDown = false;
                Splitter splitter = (Splitter)parent;
                boolean vertical = splitter.getOrientation();
                if (vertical && splitter.getFirstComponent() == c) {
                    editorToTheDown = true;
                } else if (!vertical) {
                    if (splitter.getFirstComponent() == c) {
                        editorToTheRight = true;
                    }
                    if (splitter.getSecondComponent() == c) {
                        editorToTheLeft = true;
                    }
                }
                Splitter outer = AdaptiveBorder.nextOuterSplitter((Component)splitter);
                if (outer != null) {
                    boolean outerVertical = outer.getOrientation();
                    if (!outerVertical) {
                        if (splitter.getParent() == outer.getFirstComponent()) {
                            editorToTheRight = true;
                        }
                        if (splitter.getParent() == outer.getSecondComponent()) {
                            editorToTheLeft = true;
                        }
                    } else if (splitter.getParent() == outer.getFirstComponent()) {
                        editorToTheDown = true;
                    }
                }
                int left = editorToTheLeft ? 1 : 0;
                int right = editorToTheRight ? 1 : 0;
                int bottom = editorToTheDown ? 1 : 0;
                return new Insets(0, left, bottom, right);
            }
            return new Insets(0, 0, 0, 0);
        }

        @Nullable
        private static Splitter nextOuterSplitter(Component c) {
            Container parent = c.getParent();
            if (parent == null) {
                return null;
            }
            Container grandParent = parent.getParent();
            if (grandParent instanceof Splitter) {
                return (Splitter)grandParent;
            }
            return null;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

