/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdePanePanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorsSplitters
extends IdePanePanel
implements UISettingsListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorsSplitters");
    private static final String PINNED = "pinned";
    private static final String CURRENT_IN_TAB = "current-in-tab";
    private static final Key<Object> DUMMY_KEY = Key.create((String)"EditorsSplitters.dummy.key");
    private static final EditorEmptyTextPainter ourPainter = (EditorEmptyTextPainter)ServiceManager.getService(EditorEmptyTextPainter.class);
    private EditorWindow myCurrentWindow;
    private final Set<EditorWindow> myWindows = new CopyOnWriteArraySet<EditorWindow>();
    private final FileEditorManagerImpl myManager;
    private Element mySplittersElement;
    int myInsideChange = 0;
    private final MyFocusWatcher myFocusWatcher;
    private final Alarm myIconUpdaterAlarm = new Alarm();
    private final KeymapManagerListener myKeymapListener;
    private final UIBuilder myUIBuilder = new UIBuilder();
    private double myProgressMaximum;
    private int myCurrentProgress;
    private final Set<VirtualFile> myFilesToUpdateIconsFor = new HashSet<VirtualFile>();

    public EditorsSplitters(FileEditorManagerImpl manager, DockManager dockManager, boolean createOwnDockableContainer) {
        super(new BorderLayout());
        this.myManager = manager;
        this.myFocusWatcher = new MyFocusWatcher();
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.clear();
        if (createOwnDockableContainer) {
            DockableEditorTabbedContainer dockable = new DockableEditorTabbedContainer(this.myManager.getProject(), this, false);
            Disposer.register((Disposable)manager.getProject(), (Disposable)dockable);
            dockManager.register((DockContainer)dockable);
        }
        this.myKeymapListener = new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap) {
                EditorsSplitters.this.invalidate();
                EditorsSplitters.this.repaint();
            }
        };
        KeymapManager.getInstance().addKeymapManagerListener(this.myKeymapListener);
        UISettings.getInstance().addUISettingsListener((UISettingsListener)this);
    }

    public FileEditorManagerImpl getManager() {
        return this.myManager;
    }

    public void clear() {
        for (EditorWindow window : this.myWindows) {
            window.dispose();
        }
        this.removeAll();
        this.myWindows.clear();
        this.setCurrentWindow(null);
        this.repaint();
    }

    public void startListeningFocus() {
        this.myFocusWatcher.install((Component)((Object)this));
    }

    private void stopListeningFocus() {
        this.myFocusWatcher.deinstall((Component)((Object)this));
    }

    public void dispose() {
        this.myIconUpdaterAlarm.cancelAllRequests();
        this.stopListeningFocus();
        KeymapManager.getInstance().removeKeymapManagerListener(this.myKeymapListener);
        UISettings.getInstance().removeUISettingsListener((UISettingsListener)this);
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        if (this.myCurrentWindow != null) {
            return this.myCurrentWindow.getSelectedFile();
        }
        return null;
    }

    protected boolean showEmptyText() {
        return this.myCurrentWindow == null || this.myCurrentWindow.getFiles().length == 0;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myCurrentWindow == null || this.myCurrentWindow.getFiles().length == 0) {
            g.setColor(UIUtil.isUnderDarcula() ? UIUtil.getBorderColor() : new Color(0, 0, 0, 50));
            g.drawLine(0, 0, this.getWidth(), 0);
        }
        if (this.showEmptyText()) {
            ourPainter.paintEmptyText(this, g);
        }
    }

    public void writeExternal(Element element) {
        if (this.getComponentCount() != 0) {
            Component comp = this.getComponent(0);
            LOG.assertTrue(comp instanceof JPanel);
            JPanel panel = (JPanel)comp;
            if (panel.getComponentCount() != 0) {
                Element res = this.writePanel(panel);
                element.addContent(res);
            }
        }
    }

    private Element writePanel(JPanel panel) {
        Component comp = panel.getComponent(0);
        if (comp instanceof Splitter) {
            Splitter splitter = (Splitter)comp;
            Element res = new Element("splitter");
            res.setAttribute("split-orientation", splitter.getOrientation() ? "vertical" : "horizontal");
            res.setAttribute("split-proportion", Float.toString(splitter.getProportion()));
            Element first = new Element("split-first");
            first.addContent(this.writePanel((JPanel)splitter.getFirstComponent()));
            Element second = new Element("split-second");
            second.addContent(this.writePanel((JPanel)splitter.getSecondComponent()));
            res.addContent(first);
            res.addContent(second);
            return res;
        }
        if (comp instanceof JBTabs) {
            Element res = new Element("leaf");
            EditorWindow window = this.findWindowWith(comp);
            this.writeWindow(res, window);
            return res;
        }
        if (comp instanceof EditorWindow.TCompForTablessMode) {
            EditorWithProviderComposite composite = ((EditorWindow.TCompForTablessMode)comp).myEditor;
            Element res = new Element("leaf");
            this.writeComposite(res, composite.getFile(), composite, false, composite);
            return res;
        }
        LOG.error(comp != null ? comp.getClass().getName() : null);
        return null;
    }

    private void writeWindow(Element res, EditorWindow window) {
        if (window != null) {
            EditorWithProviderComposite[] composites = window.getEditors();
            for (int i = 0; i < composites.length; ++i) {
                VirtualFile file = window.getFileAt(i);
                boolean isPinned = window.isFilePinned(file);
                EditorWithProviderComposite composite = composites[i];
                EditorWithProviderComposite selectedEditor = window.getSelectedEditor();
                this.writeComposite(res, file, composite, isPinned, selectedEditor);
            }
        }
    }

    private void writeComposite(Element res, VirtualFile file, EditorWithProviderComposite composite, boolean pinned, EditorWithProviderComposite selectedEditor) {
        Element fileElement = new Element("file");
        fileElement.setAttribute("leaf-file-name", file.getName());
        HistoryEntry entry = composite.currentStateAsHistoryEntry();
        entry.writeExternal(fileElement, this.getManager().getProject());
        fileElement.setAttribute(PINNED, Boolean.toString(pinned));
        fileElement.setAttribute(CURRENT_IN_TAB, Boolean.toString(composite.equals(selectedEditor)));
        res.addContent(fileElement);
    }

    public void openFiles() {
        if (this.mySplittersElement != null) {
            this.initializeProgress();
            final JPanel comp = this.myUIBuilder.process(this.mySplittersElement, this.getTopPanel());
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (comp != null) {
                        EditorsSplitters.this.removeAll();
                        EditorsSplitters.this.add(comp, "Center");
                        EditorsSplitters.this.mySplittersElement = null;
                    }
                    for (EditorWindow window : EditorsSplitters.this.getWindows()) {
                        if (window.getEditors().length != 0) continue;
                        for (EditorWindow sibling : window.findSiblings()) {
                            sibling.unsplit(false);
                        }
                    }
                }
            });
        }
    }

    private void initializeProgress() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(IdeBundle.message((String)"loading.editors", (Object[])new Object[0]));
            indicator.setText2("");
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            this.myProgressMaximum = EditorsSplitters.countFiles(this.mySplittersElement);
            this.myCurrentProgress = 0;
        }
    }

    private void updateProgress() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            ++this.myCurrentProgress;
            indicator.setFraction((double)this.myCurrentProgress / this.myProgressMaximum);
        }
    }

    private static int countFiles(Element element) {
        Integer value = new ConfigTreeReader<Integer>(){

            @Override
            protected Integer processFiles(@NotNull List<Element> fileElements, @Nullable Integer context) {
                if (fileElements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileElements", "com/intellij/openapi/fileEditor/impl/EditorsSplitters$3", "processFiles"));
                }
                return fileElements.size();
            }

            @Override
            protected Integer processSplitter(@NotNull Element element, @Nullable Element firstChild, @Nullable Element secondChild, @Nullable Integer context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/EditorsSplitters$3", "processSplitter"));
                }
                Integer first = this.process(firstChild, null);
                Integer second = this.process(secondChild, null);
                return (first == null ? 0 : first) + (second == null ? 0 : second);
            }
        }.process(element, null);
        return value == null ? 0 : value;
    }

    public void readExternal(Element element) {
        this.mySplittersElement = element;
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        ArrayListSet files = new ArrayListSet();
        for (EditorWindow myWindow : this.myWindows) {
            EditorWithProviderComposite[] editors;
            for (EditorWithProviderComposite editor : editors = myWindow.getEditors()) {
                VirtualFile file = editor.getFile();
                if (!file.isValid()) continue;
                files.add((Object)file);
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)files);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "getOpenFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        ArrayListSet files = new ArrayListSet();
        for (EditorWindow window : this.myWindows) {
            VirtualFile file = window.getSelectedFile();
            if (file == null) continue;
            files.add((Object)file);
        }
        VirtualFile[] virtualFiles = VfsUtilCore.toVirtualFileArray((Collection)files);
        VirtualFile currentFile = this.getCurrentFile();
        if (currentFile != null) {
            for (int i = 0; i != virtualFiles.length; ++i) {
                if (!Comparing.equal((Object)virtualFiles[i], (Object)currentFile)) continue;
                virtualFiles[i] = virtualFiles[0];
                virtualFiles[0] = currentFile;
                break;
            }
        }
        if (virtualFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "getSelectedFiles"));
        }
        return virtualFiles;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        ArrayList<FileEditor> editors = new ArrayList<FileEditor>();
        THashSet windows = new THashSet(this.myWindows);
        EditorWindow currentWindow = this.getCurrentWindow();
        if (currentWindow != null) {
            windows.add(currentWindow);
        }
        for (EditorWindow window : windows) {
            EditorWithProviderComposite composite = window.getSelectedEditor();
            if (composite == null) continue;
            editors.add(composite.getSelectedEditor());
        }
        FileEditor[] fileEditorArray = editors.toArray(new FileEditor[editors.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "getSelectedEditors"));
        }
        return fileEditorArray;
    }

    public void updateFileIcon(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "updateFileIcon"));
        }
        this.updateFileIconLater(file);
    }

    private void updateFileIconImmediately(VirtualFile file) {
        List<EditorWindow> windows = this.findWindows(file);
        for (EditorWindow window : windows) {
            window.updateFileIcon(file);
        }
    }

    private void updateFileIconLater(VirtualFile file) {
        this.myFilesToUpdateIconsFor.add(file);
        this.myIconUpdaterAlarm.cancelAllRequests();
        this.myIconUpdaterAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (EditorsSplitters.this.myManager.getProject().isDisposed()) {
                    return;
                }
                for (VirtualFile file : EditorsSplitters.this.myFilesToUpdateIconsFor) {
                    EditorsSplitters.this.updateFileIconImmediately(file);
                }
                EditorsSplitters.this.myFilesToUpdateIconsFor.clear();
            }
        }, 200, ModalityState.stateForComponent((Component)((Object)this)));
    }

    public void updateFileColor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "updateFileColor"));
        }
        List<EditorWindow> windows = this.findWindows(file);
        for (EditorWindow window : windows) {
            int index = window.findEditorIndex(window.findFileComposite(file));
            LOG.assertTrue(index != -1);
            window.setForegroundAt(index, this.getManager().getFileColor(file));
            window.setWaveColor(index, (Color)(this.getManager().isProblem(file) ? JBColor.red : null));
        }
    }

    public void trimToSize(int editor_tab_limit) {
        for (EditorWindow window : this.myWindows) {
            window.trimToSize(editor_tab_limit, null, true);
        }
    }

    public void setTabsPlacement(int tabPlacement) {
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            windows[i].setTabsPlacement(tabPlacement);
        }
    }

    public void setTabLayoutPolicy(int scrollTabLayout) {
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            windows[i].setTabLayoutPolicy(scrollTabLayout);
        }
    }

    public void updateFileName(VirtualFile updatedFile) {
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            windows[i].updateFileName(updatedFile);
        }
        Project project = this.myManager.getProject();
        IdeFrame frame = this.getFrame(project);
        if (frame != null) {
            VirtualFile file = this.getCurrentFile();
            File ioFile = file == null ? null : new File(file.getPresentableUrl());
            String fileTitle = null;
            if (file != null) {
                fileTitle = DumbService.isDumb((Project)project) ? file.getName() : FrameTitleBuilder.getInstance().getFileTitle(project, file);
            }
            frame.setFileTitle(fileTitle, ioFile);
        }
    }

    protected IdeFrame getFrame(Project project) {
        WindowManagerEx windowManagerEx = WindowManagerEx.getInstanceEx();
        IdeFrameImpl frame = windowManagerEx.getFrame(project);
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || frame != null);
        return frame;
    }

    public boolean isInsideChange() {
        return this.myInsideChange > 0;
    }

    private void setCurrentWindow(@Nullable EditorWindow currentWindow) {
        if (currentWindow != null && !this.myWindows.contains(currentWindow)) {
            throw new IllegalArgumentException(currentWindow + " is not a member of this container");
        }
        this.myCurrentWindow = currentWindow;
    }

    public void updateFileBackgroundColor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "updateFileBackgroundColor"));
        }
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            windows[i].updateFileBackgroundColor(file);
        }
    }

    public int getSplitCount() {
        if (this.getComponentCount() > 0) {
            JPanel panel = (JPanel)this.getComponent(0);
            return EditorsSplitters.getSplitCount(panel);
        }
        return 0;
    }

    private static int getSplitCount(JComponent component) {
        if (component.getComponentCount() > 0) {
            JComponent firstChild = (JComponent)component.getComponent(0);
            if (firstChild instanceof Splitter) {
                Splitter splitter = (Splitter)firstChild;
                return EditorsSplitters.getSplitCount(splitter.getFirstComponent()) + EditorsSplitters.getSplitCount(splitter.getSecondComponent());
            }
            return 1;
        }
        return 0;
    }

    protected void afterFileClosed(VirtualFile file) {
    }

    protected void afterFileOpen(VirtualFile file) {
    }

    @Nullable
    public JBTabs getTabsAt(RelativePoint point) {
        Point thisPoint = point.getPoint((Component)((Object)this));
        for (Component c = SwingUtilities.getDeepestComponentAt((Component)((Object)this), thisPoint.x, thisPoint.y); c != null; c = c.getParent()) {
            if (!(c instanceof JBTabs)) continue;
            return (JBTabs)c;
        }
        return null;
    }

    public boolean isEmptyVisible() {
        EditorWindow[] windows;
        for (EditorWindow each : windows = this.getWindows()) {
            if (each.isEmptyVisible()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public VirtualFile findNextFile(VirtualFile file) {
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            VirtualFile[] files;
            for (VirtualFile fileAt : files = windows[i].getFiles()) {
                if (Comparing.equal((Object)fileAt, (Object)file)) continue;
                return fileAt;
            }
        }
        return null;
    }

    void closeFile(VirtualFile file, boolean moveFocus) {
        List<EditorWindow> windows = this.findWindows(file);
        if (!windows.isEmpty()) {
            VirtualFile nextFile = this.findNextFile(file);
            for (EditorWindow window : windows) {
                LOG.assertTrue(window.getSelectedEditor() != null);
                window.closeFile(file, false, moveFocus);
                if (window.getTabCount() != 0 || nextFile == null || !this.myManager.getProject().isOpen()) continue;
                EditorWithProviderComposite newComposite = this.myManager.newEditorComposite(nextFile);
                window.setEditor(newComposite, moveFocus);
            }
            for (EditorWindow window : windows) {
                if (window.isDisposed() || window.getTabCount() != 0) continue;
                window.unsplit(false);
            }
        }
    }

    public void uiSettingsChanged(UISettings source) {
        if (!this.myManager.getProject().isOpen()) {
            return;
        }
        for (VirtualFile file : this.getOpenFiles()) {
            this.updateFileBackgroundColor(file);
            this.updateFileIcon(file);
            this.updateFileColor(file);
        }
    }

    @Nullable
    public JPanel getTopPanel() {
        return this.getComponentCount() > 0 ? (JPanel)this.getComponent(0) : null;
    }

    public EditorWindow getCurrentWindow() {
        return this.myCurrentWindow;
    }

    public EditorWindow getOrCreateCurrentWindow(VirtualFile file) {
        List<EditorWindow> windows = this.findWindows(file);
        if (this.getCurrentWindow() == null) {
            Iterator<EditorWindow> iterator = this.myWindows.iterator();
            if (!windows.isEmpty()) {
                this.setCurrentWindow(windows.get(0), false);
            } else if (iterator.hasNext()) {
                this.setCurrentWindow(iterator.next(), false);
            } else {
                this.createCurrentWindow();
            }
        } else if (!windows.isEmpty() && !windows.contains(this.getCurrentWindow())) {
            this.setCurrentWindow(windows.get(0), false);
        }
        return this.getCurrentWindow();
    }

    public void createCurrentWindow() {
        LOG.assertTrue(this.myCurrentWindow == null);
        this.setCurrentWindow(this.createEditorWindow());
        this.add(this.myCurrentWindow.myPanel, "Center");
    }

    protected EditorWindow createEditorWindow() {
        return new EditorWindow(this);
    }

    public void setCurrentWindow(@Nullable EditorWindow window, boolean requestFocus) {
        final EditorWithProviderComposite newEditor = window == null ? null : window.getSelectedEditor();
        Runnable fireRunnable = new Runnable(){

            @Override
            public void run() {
                EditorsSplitters.this.getManager().fireSelectionChanged(newEditor);
            }
        };
        this.setCurrentWindow(window);
        this.getManager().updateFileName(window == null ? null : window.getSelectedFile());
        if (window != null) {
            EditorWithProviderComposite selectedEditor = window.getSelectedEditor();
            if (selectedEditor != null) {
                fireRunnable.run();
            }
            if (requestFocus) {
                window.requestFocus(true);
            }
        } else {
            fireRunnable.run();
        }
    }

    void addWindow(EditorWindow window) {
        this.myWindows.add(window);
    }

    void removeWindow(EditorWindow window) {
        this.myWindows.remove(window);
        if (this.myCurrentWindow == window) {
            this.myCurrentWindow = null;
        }
    }

    boolean containsWindow(EditorWindow window) {
        return this.myWindows.contains(window);
    }

    public EditorWithProviderComposite[] getEditorsComposites() {
        ArrayList res = new ArrayList();
        for (EditorWindow myWindow : this.myWindows) {
            Object[] editors = myWindow.getEditors();
            ContainerUtil.addAll(res, (Object[])editors);
        }
        return res.toArray(new EditorWithProviderComposite[res.size()]);
    }

    @NotNull
    public List<EditorWithProviderComposite> findEditorComposites(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "findEditorComposites"));
        }
        ArrayList<EditorWithProviderComposite> res = new ArrayList<EditorWithProviderComposite>();
        for (EditorWindow window : this.myWindows) {
            EditorWithProviderComposite fileComposite = window.findFileComposite(file);
            if (fileComposite == null) continue;
            res.add(fileComposite);
        }
        ArrayList<EditorWithProviderComposite> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "findEditorComposites"));
        }
        return arrayList;
    }

    @NotNull
    public List<EditorWindow> findWindows(VirtualFile file) {
        ArrayList<EditorWindow> res = new ArrayList<EditorWindow>();
        for (EditorWindow window : this.myWindows) {
            if (window.findFileComposite(file) == null) continue;
            res.add(window);
        }
        ArrayList<EditorWindow> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "findWindows"));
        }
        return arrayList;
    }

    @NotNull
    public EditorWindow[] getWindows() {
        EditorWindow[] editorWindowArray = this.myWindows.toArray(new EditorWindow[this.myWindows.size()]);
        if (editorWindowArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "getWindows"));
        }
        return editorWindowArray;
    }

    @NotNull
    public EditorWindow[] getOrderedWindows() {
        final ArrayList res = new ArrayList();
        if (this.getComponentCount() != 0) {
            Component comp = this.getComponent(0);
            LOG.assertTrue(comp instanceof JPanel);
            JPanel panel = (JPanel)comp;
            if (panel.getComponentCount() != 0) {
                class Inner {
                    Inner() {
                    }

                    final void collect(JPanel panel) {
                        EditorWindow window;
                        Component comp = panel.getComponent(0);
                        if (comp instanceof Splitter) {
                            Splitter splitter = (Splitter)comp;
                            this.collect((JPanel)splitter.getFirstComponent());
                            this.collect((JPanel)splitter.getSecondComponent());
                        } else if ((comp instanceof JPanel || comp instanceof JBTabs) && (window = EditorsSplitters.this.findWindowWith(comp)) != null) {
                            res.add(window);
                        }
                    }
                }
                new Inner().collect(panel);
            }
        }
        LOG.assertTrue(res.size() == this.myWindows.size());
        EditorWindow[] editorWindowArray = res.toArray(new EditorWindow[res.size()]);
        if (editorWindowArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorsSplitters", "getOrderedWindows"));
        }
        return editorWindowArray;
    }

    @Nullable
    private EditorWindow findWindowWith(Component component) {
        if (component != null) {
            for (EditorWindow window : this.myWindows) {
                if (!SwingUtilities.isDescendingFrom(component, window.myPanel)) continue;
                return window;
            }
        }
        return null;
    }

    public boolean isFloating() {
        return false;
    }

    public boolean isPreview() {
        return false;
    }

    private class UIBuilder
    extends ConfigTreeReader<JPanel> {
        private UIBuilder() {
        }

        @Override
        protected JPanel processFiles(@NotNull List<Element> fileElements, final JPanel context) {
            if (fileElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileElements", "com/intellij/openapi/fileEditor/impl/EditorsSplitters$UIBuilder", "processFiles"));
            }
            final Ref windowRef = new Ref();
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    windowRef.set((Object)(context == null ? EditorsSplitters.this.createEditorWindow() : EditorsSplitters.this.findWindowWith(context)));
                }
            });
            EditorWindow window = (EditorWindow)windowRef.get();
            LOG.assertTrue(window != null);
            VirtualFile focusedFile = null;
            for (int i = 0; i < fileElements.size(); ++i) {
                Element file = fileElements.get(i);
                try {
                    FileEditorManagerImpl fileEditorManager = EditorsSplitters.this.getManager();
                    Element historyElement = file.getChild("entry");
                    final VirtualFile virtualFile = HistoryEntry.getVirtualFile(historyElement);
                    Document document = (Document)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Document>(){

                        public Document compute() {
                            return virtualFile.isValid() ? FileDocumentManager.getInstance().getDocument(virtualFile) : null;
                        }
                    });
                    HistoryEntry entry = new HistoryEntry(fileEditorManager.getProject(), historyElement);
                    boolean isCurrentInTab = Boolean.valueOf(file.getAttributeValue(EditorsSplitters.CURRENT_IN_TAB));
                    Boolean pin = Boolean.valueOf(file.getAttributeValue(EditorsSplitters.PINNED));
                    fileEditorManager.openFileImpl4(window, entry.myFile, entry, isCurrentInTab, isCurrentInTab, pin, i);
                    if (isCurrentInTab) {
                        focusedFile = entry.myFile;
                    }
                    if (document != null) {
                        document.putUserData(DUMMY_KEY, null);
                    }
                    EditorsSplitters.this.updateProgress();
                    continue;
                }
                catch (InvalidDataException e) {
                    if (!ApplicationManager.getApplication().isUnitTestMode()) continue;
                    LOG.error((Throwable)e);
                }
            }
            if (focusedFile != null) {
                EditorsSplitters.this.getManager().addSelectionRecord(focusedFile, window);
            }
            return window.myPanel;
        }

        @Override
        protected JPanel processSplitter(@NotNull Element splitterElement, Element firstChild, Element secondChild, final JPanel context) {
            if (splitterElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitterElement", "com/intellij/openapi/fileEditor/impl/EditorsSplitters$UIBuilder", "processSplitter"));
            }
            if (context == null) {
                final boolean orientation = "vertical".equals(splitterElement.getAttributeValue("split-orientation"));
                final float proportion = Float.valueOf(splitterElement.getAttributeValue("split-proportion")).floatValue();
                final JPanel firstComponent = this.process(firstChild, null);
                final JPanel secondComponent = this.process(secondChild, null);
                final Ref panelRef = new Ref();
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.setOpaque(false);
                        Splitter splitter = new Splitter(orientation, proportion, 0.1f, 0.9f);
                        panel.add((Component)splitter, "Center");
                        splitter.setFirstComponent((JComponent)firstComponent);
                        splitter.setSecondComponent((JComponent)secondComponent);
                        panelRef.set((Object)panel);
                    }
                });
                return (JPanel)panelRef.get();
            }
            final Ref firstComponent = new Ref();
            final Ref secondComponent = new Ref();
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (context.getComponent(0) instanceof Splitter) {
                        Splitter splitter = (Splitter)context.getComponent(0);
                        firstComponent.set((Object)((JPanel)splitter.getFirstComponent()));
                        secondComponent.set((Object)((JPanel)splitter.getSecondComponent()));
                    } else {
                        firstComponent.set((Object)context);
                        secondComponent.set((Object)context);
                    }
                }
            });
            this.process(firstChild, firstComponent.get());
            this.process(secondChild, secondComponent.get());
            return context;
        }
    }

    private static abstract class ConfigTreeReader<T> {
        private ConfigTreeReader() {
        }

        @Nullable
        public T process(@Nullable Element element, @Nullable T context) {
            if (element == null) {
                return null;
            }
            Element splitterElement = element.getChild("splitter");
            if (splitterElement != null) {
                Element first = splitterElement.getChild("split-first");
                Element second = splitterElement.getChild("split-second");
                return this.processSplitter(splitterElement, first, second, context);
            }
            Element leaf = element.getChild("leaf");
            if (leaf == null) {
                return null;
            }
            List fileElements = leaf.getChildren("file");
            ArrayList<Element> children = new ArrayList<Element>(fileElements.size());
            int toRemove = fileElements.size() - UISettings.getInstance().EDITOR_TAB_LIMIT;
            for (Element fileElement : fileElements) {
                if (toRemove <= 0 || Boolean.valueOf(fileElement.getAttributeValue(EditorsSplitters.PINNED)).booleanValue()) {
                    children.add(fileElement);
                    continue;
                }
                --toRemove;
            }
            return this.processFiles(children, context);
        }

        @Nullable
        protected abstract T processFiles(@NotNull List<Element> var1, @Nullable T var2);

        @Nullable
        protected abstract T processSplitter(@NotNull Element var1, @Nullable Element var2, @Nullable Element var3, @Nullable T var4);
    }

    private final class MyFocusWatcher
    extends FocusWatcher {
        private MyFocusWatcher() {
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            EditorWindow newWindow = null;
            if (component != null) {
                newWindow = EditorsSplitters.this.findWindowWith(component);
            } else if (cause instanceof ContainerEvent && cause.getID() == 301) {
                return;
            }
            EditorsSplitters.this.setCurrentWindow(newWindow);
            EditorsSplitters.this.setCurrentWindow(newWindow, false);
        }
    }

    private final class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponentImpl(Container focusCycleRoot) {
            EditorWithProviderComposite selectedEditor;
            if (EditorsSplitters.this.myCurrentWindow != null && (selectedEditor = EditorsSplitters.this.myCurrentWindow.getSelectedEditor()) != null) {
                return IdeFocusTraversalPolicy.getPreferredFocusedComponent(selectedEditor.getComponent(), this);
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)((Object)EditorsSplitters.this), this);
        }
    }
}

