/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import org.jetbrains.annotations.NotNull;

public class LineIndentInfo {
    public static final LineIndentInfo EMPTY_LINE = new LineIndentInfo(LineType.EMPTY_LINE, -1);
    public static final LineIndentInfo LINE_WITH_COMMENT = new LineIndentInfo(LineType.LINE_WITH_COMMENT, -1);
    public static final LineIndentInfo LINE_WITH_TABS = new LineIndentInfo(LineType.LINE_WITH_TABS, -1);
    private final int myIndentSize;
    private final LineType myType;

    private LineIndentInfo(@NotNull LineType type, int indentSize) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/codeStyle/autodetect/LineIndentInfo", "<init>"));
        }
        this.myType = type;
        this.myIndentSize = indentSize;
    }

    @NotNull
    public static LineIndentInfo newWhiteSpaceIndent(int indentSize) {
        LineIndentInfo lineIndentInfo = new LineIndentInfo(LineType.LINE_WITH_WHITESPACE_INDENT, indentSize);
        if (lineIndentInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/LineIndentInfo", "newWhiteSpaceIndent"));
        }
        return lineIndentInfo;
    }

    public int getIndentSize() {
        return this.myIndentSize;
    }

    public boolean isLineWithWhiteSpaceIndent() {
        return this.myType == LineType.LINE_WITH_WHITESPACE_INDENT;
    }

    public boolean isLineWithTabs() {
        return this.myType == LineType.LINE_WITH_TABS;
    }

    private static enum LineType {
        EMPTY_LINE,
        LINE_WITH_COMMENT,
        LINE_WITH_TABS,
        LINE_WITH_WHITESPACE_INDENT;

    }
}

