/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inCallers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MethodNodeBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JavaMethodNode
extends MethodNodeBase<PsiMethod> {
    protected JavaMethodNode(PsiMethod method, Set<PsiMethod> called, Project project, Runnable cancelCallback) {
        super(method, called, project, cancelCallback);
    }

    @Override
    protected MethodNodeBase<PsiMethod> createNode(PsiMethod caller, HashSet<PsiMethod> called) {
        return new JavaMethodNode(caller, (Set<PsiMethod>)called, this.myProject, this.myCancelCallback);
    }

    @Override
    protected List<PsiMethod> computeCallers() {
        PsiReference[] refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)((PsiMethod)this.myMethod), (SearchScope)GlobalSearchScope.allScope((Project)this.myProject), (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY);
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            if (element instanceof PsiReferenceExpression && ((PsiReferenceExpression)element).getQualifierExpression() instanceof PsiSuperExpression) continue;
            PsiElement enclosingContext = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
            if (enclosingContext instanceof PsiMethod && !result.contains(enclosingContext) && !((PsiMethod)this.myMethod).equals(enclosingContext) && !this.myCalled.contains(this.myMethod)) {
                result.add((PsiMethod)enclosingContext);
                continue;
            }
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)element;
            PsiMethod method = JavaPsiFacade.getElementFactory((Project)this.myProject).createMethodFromText(aClass.getName() + "(){}", (PsiElement)aClass);
            if (result.contains(method)) continue;
            result.add(method);
        }
        return result;
    }

    @Override
    protected void customizeRendererText(ColoredTreeCellRenderer renderer) {
        StringBuilder buffer = new StringBuilder(128);
        PsiClass containingClass = ((PsiMethod)this.myMethod).getContainingClass();
        if (containingClass != null) {
            buffer.append(ClassPresentationUtil.getNameForClass(containingClass, false));
            buffer.append('.');
        }
        String methodText = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)this.myMethod), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        buffer.append(methodText);
        SimpleTextAttributes attributes = this.isEnabled() ? new SimpleTextAttributes(0, UIUtil.getTreeForeground()) : SimpleTextAttributes.EXCLUDED_ATTRIBUTES;
        renderer.append(buffer.toString(), attributes);
        if (containingClass != null) {
            String packageName = JavaMethodNode.getPackageName(containingClass);
            renderer.append("  (" + packageName + ")", new SimpleTextAttributes(2, (Color)JBColor.GRAY));
        }
    }

    @Nullable
    private static String getPackageName(PsiClass aClass) {
        PsiFile file = aClass.getContainingFile();
        if (file instanceof PsiJavaFile) {
            return ((PsiJavaFile)file).getPackageName();
        }
        return null;
    }
}

