/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.actions.ServersTreeAction;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;

public abstract class ApplicationActionBase<T extends CloudApplicationRuntime>
extends ServersTreeAction<DeploymentNode> {
    protected ApplicationActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    protected Class<DeploymentNode> getTargetNodeClass() {
        return DeploymentNode.class;
    }

    protected T getApplicationRuntime(DeploymentNode node) {
        Object nodeValue = node.getValue();
        if (!(nodeValue instanceof Deployment)) {
            return null;
        }
        DeploymentRuntime deploymentRuntime = ((Deployment)nodeValue).getRuntime();
        return (T)((Object)((CloudApplicationRuntime)((Object)ObjectUtils.tryCast((Object)deploymentRuntime, this.getApplicationRuntimeClass()))));
    }

    protected static ServerConnection<?> getConnection(DeploymentNode node) {
        RemoteServer server = (RemoteServer)node.getServerNode().getValue();
        return ServerConnectionManager.getInstance().getConnection(server);
    }

    @Override
    protected boolean isVisible4(DeploymentNode node) {
        return this.getApplicationRuntime(node) != null;
    }

    protected abstract Class<T> getApplicationRuntimeClass();

    protected class SelectLogRunnable
    implements Runnable {
        private final ServersToolWindowContent myContent;
        private final DeploymentNode myNode;
        private final String myLogName;

        public SelectLogRunnable(ServersToolWindowContent content, DeploymentNode node, String logName) {
            this.myContent = content;
            this.myNode = node;
            this.myLogName = logName;
        }

        @Override
        public void run() {
            final ServerConnection<?> connection = ApplicationActionBase.getConnection(this.myNode);
            if (connection == null) {
                return;
            }
            final Deployment deployment = this.findDeployment(connection);
            if (deployment == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SelectLogRunnable.this.myContent.select(connection, deployment.getName(), SelectLogRunnable.this.myLogName);
                }
            });
        }

        private Deployment findDeployment(ServerConnection<?> connection) {
            Object applicationRuntime = ApplicationActionBase.this.getApplicationRuntime(this.myNode);
            for (Deployment deployment : connection.getDeployments()) {
                if (applicationRuntime != deployment.getRuntime()) continue;
                return deployment;
            }
            return null;
        }
    }
}

