/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeException
extends Exception {
    private final List<Throwable> myExceptions;

    public CompositeException(Throwable ... e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/testFramework/CompositeException", "<init>"));
        }
        this.myExceptions = new ArrayList<Throwable>();
        this.myExceptions.addAll(Arrays.asList(e));
    }

    public void add(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/testFramework/CompositeException", "add"));
        }
        if (e instanceof CompositeException) {
            this.myExceptions.addAll(((CompositeException)e).myExceptions);
        } else {
            this.myExceptions.add(e);
        }
    }

    public boolean isEmpty() {
        return this.myExceptions.isEmpty();
    }

    @Override
    public String getMessage() {
        return this.processAll(new Function<Throwable, String>(){

            public String fun(Throwable throwable) {
                return throwable.getMessage();
            }
        }, (Processor<String>)CommonProcessors.alwaysTrue());
    }

    @Override
    public String getLocalizedMessage() {
        return this.processAll(new Function<Throwable, String>(){

            public String fun(Throwable throwable) {
                return throwable.getLocalizedMessage();
            }
        }, (Processor<String>)CommonProcessors.alwaysTrue());
    }

    @Override
    public String toString() {
        return this.processAll(new Function<Throwable, String>(){

            public String fun(Throwable throwable) {
                return throwable.toString();
            }
        }, (Processor<String>)CommonProcessors.alwaysTrue());
    }

    @Override
    public void printStackTrace(final PrintStream s) {
        this.processAll(new Function<Throwable, String>(){

            public String fun(Throwable throwable) {
                throwable.printStackTrace(s);
                return "";
            }
        }, new Processor<String>(){

            public boolean process(String str) {
                s.print(str);
                return false;
            }
        });
    }

    @Override
    public void printStackTrace(final PrintWriter s) {
        this.processAll(new Function<Throwable, String>(){

            public String fun(Throwable throwable) {
                throwable.printStackTrace(s);
                return "";
            }
        }, new Processor<String>(){

            public boolean process(String str) {
                s.print(str);
                return false;
            }
        });
    }

    private String processAll(Function<Throwable, String> exceptionProcessor, Processor<String> stringProcessor) {
        if (this.myExceptions.size() == 1) {
            Throwable throwable = this.myExceptions.get(0);
            String s = (String)exceptionProcessor.fun((Object)throwable);
            stringProcessor.process((Object)s);
            return s;
        }
        StringBuilder sb = new StringBuilder();
        String line = "CompositeException (" + this.myExceptions.size() + " nested):\n------------------------------\n";
        stringProcessor.process((Object)line);
        sb.append(line);
        for (int i = 0; i < this.myExceptions.size(); ++i) {
            Throwable exception = this.myExceptions.get(i);
            line = "[" + i + "]: ";
            stringProcessor.process((Object)line);
            sb.append(line);
            line = (String)exceptionProcessor.fun((Object)exception);
            if (line == null) {
                line = "null\n";
            } else if (!line.endsWith("\n")) {
                line = line + '\n';
            }
            stringProcessor.process((Object)line);
            sb.append(line);
        }
        line = "------------------------------\n";
        stringProcessor.process((Object)line);
        sb.append(line);
        return sb.toString();
    }

    public void throwIfNotEmpty() throws CompositeException {
        if (!this.isEmpty()) {
            throw this;
        }
    }
}

