/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import com.siyeh.ig.imports.ImportsAreUsedVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedImportInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unused.import.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/UnusedImportInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unused.import.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/UnusedImportInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteImportFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedImportVisitor();
    }

    private static class UnusedImportVisitor
    extends BaseInspectionVisitor {
        private UnusedImportVisitor() {
        }

        public void visitJavaFile(PsiJavaFile file) {
            if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
                return;
            }
            PsiClass[] classes = file.getClasses();
            PsiPackageStatement packageStatement = file.getPackageStatement();
            PsiModifierList annotationList = packageStatement != null ? packageStatement.getAnnotationList() : null;
            this.checkImports(file, classes, annotationList);
        }

        private void checkImports(PsiJavaFile file, PsiClass[] classes, @Nullable PsiModifierList annotationList) {
            ImportsAreUsedVisitor visitor = new ImportsAreUsedVisitor(file);
            for (PsiClass psiClass : classes) {
                psiClass.accept((PsiElementVisitor)visitor);
            }
            if (annotationList != null) {
                annotationList.accept((PsiElementVisitor)visitor);
            }
            for (PsiClass psiClass : visitor.getUnusedImportStatements()) {
                this.registerError((PsiElement)psiClass, new Object[0]);
            }
        }
    }
}

