/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.constant.ConstantSubexpressionPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import org.jetbrains.annotations.NotNull;

public class ConstantSubexpressionIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConstantSubexpressionPredicate constantSubexpressionPredicate = new ConstantSubexpressionPredicate();
        if (constantSubexpressionPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/constant/ConstantSubexpressionIntention", "getElementPredicate"));
        }
        return constantSubexpressionPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiJavaToken token;
        if (element instanceof PsiJavaToken) {
            token = (PsiJavaToken)element;
        } else {
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiJavaToken) {
                token = (PsiJavaToken)prevSibling;
            } else {
                throw new AssertionError();
            }
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        PsiPolyadicExpression subexpression = ConstantSubexpressionPredicate.getSubexpression(polyadicExpression, token);
        String text = HighlightUtil.getPresentableText((PsiElement)subexpression);
        return IntentionPowerPackBundle.message("constant.expression.intention.name", text);
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken token;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/constant/ConstantSubexpressionIntention", "processIntention"));
        }
        if (element instanceof PsiJavaToken) {
            token = (PsiJavaToken)element;
        } else {
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiJavaToken) {
                token = (PsiJavaToken)prevSibling;
            } else {
                throw new AssertionError();
            }
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        PsiPolyadicExpression subexpression = ConstantSubexpressionPredicate.getSubexpression(polyadicExpression, token);
        if (subexpression == null) {
            return;
        }
        Object value = ExpressionUtils.computeConstantExpression((PsiExpression)subexpression);
        StringBuilder newExpressionText = new StringBuilder();
        PsiExpression[] operands = polyadicExpression.getOperands();
        PsiExpression prevOperand = null;
        PsiJavaToken prevToken = null;
        for (PsiExpression operand : operands) {
            PsiJavaToken currentToken = polyadicExpression.getTokenBeforeOperand(operand);
            if (token == currentToken) {
                if (prevToken != null) {
                    newExpressionText.append(prevToken.getText());
                }
                if (newExpressionText.length() > 0) {
                    newExpressionText.append(' ');
                }
                if (value instanceof Long) {
                    newExpressionText.append(value).append('L');
                } else if (value instanceof Double) {
                    double v = (Double)value;
                    if (Double.isNaN(v)) {
                        newExpressionText.append("java.lang.Double.NaN");
                    } else if (Double.isInfinite(v)) {
                        if (v > 0.0) {
                            newExpressionText.append("java.lang.Double.POSITIVE_INFINITY");
                        } else {
                            newExpressionText.append("java.lang.Double.NEGATIVE_INFINITY");
                        }
                    } else {
                        newExpressionText.append(Double.toString(v));
                    }
                } else if (value instanceof Float) {
                    float v = ((Float)value).floatValue();
                    if (Float.isNaN(v)) {
                        newExpressionText.append("java.lang.Float.NaN");
                    } else if (Float.isInfinite(v)) {
                        if (v > 0.0f) {
                            newExpressionText.append("java.lang.Float.POSITIVE_INFINITY");
                        } else {
                            newExpressionText.append("java.lang.Float.NEGATIVE_INFINITY");
                        }
                    } else {
                        newExpressionText.append(Float.toString(v)).append('f');
                    }
                } else {
                    newExpressionText.append(value);
                }
                prevOperand = null;
                prevToken = null;
                continue;
            }
            if (prevToken != null) {
                newExpressionText.append(prevToken.getText());
            }
            if (prevOperand != null) {
                newExpressionText.append(prevOperand.getText());
            }
            prevOperand = operand;
            prevToken = currentToken;
        }
        if (prevToken != null) {
            newExpressionText.append(prevToken.getText());
        }
        if (prevOperand != null) {
            newExpressionText.append(prevOperand.getText());
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpressionText.toString());
    }
}

