/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.UIUtil;
import git4idea.GitVcs;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class GitVcsPanel {
    private static final String IDEA_SSH = GitBundle.getString("git.vcs.config.ssh.mode.idea");
    private static final String NATIVE_SSH = GitBundle.getString("git.vcs.config.ssh.mode.native");
    private final GitVcsApplicationSettings myAppSettings;
    private final GitVcs myVcs;
    private JButton myTestButton;
    private JComponent myRootPanel;
    private TextFieldWithBrowseButton myGitField;
    private JComboBox mySSHExecutableComboBox;
    private JCheckBox myAutoUpdateIfPushRejected;
    private JBCheckBox mySyncControl;
    private JCheckBox myAutoCommitOnCherryPick;
    private JBCheckBox myWarnAboutCrlf;
    private JCheckBox myWarnAboutDetachedHead;
    private JCheckBox myEnableForcePush;
    private TextFieldWithBrowseButton myProtectedBranchesButton;
    private JBLabel myProtectedBranchesLabel;
    private JComboBox myUpdateMethodComboBox;

    public GitVcsPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/config/GitVcsPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myVcs = GitVcs.getInstance(project);
        this.myAppSettings = GitVcsApplicationSettings.getInstance();
        this.mySSHExecutableComboBox.addItem(IDEA_SSH);
        this.mySSHExecutableComboBox.addItem(NATIVE_SSH);
        this.mySSHExecutableComboBox.setSelectedItem(IDEA_SSH);
        this.mySSHExecutableComboBox.setToolTipText(GitBundle.message("git.vcs.config.ssh.mode.tooltip", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitVcsPanel.this.testConnection();
            }
        });
        this.myGitField.addBrowseFolderListener(GitBundle.getString("find.git.title"), GitBundle.getString("find.git.description"), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        if (!project.isDefault()) {
            GitRepositoryManager repositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
            this.mySyncControl.setVisible(repositoryManager != null && repositoryManager.moreThanOneRoot());
        } else {
            this.mySyncControl.setVisible(true);
        }
        this.mySyncControl.setToolTipText(DvcsBundle.message((String)"sync.setting.description", (Object[])new Object[]{"Git"}));
        this.myProtectedBranchesLabel.setLabelFor((Component)this.myProtectedBranchesButton);
        this.myEnableForcePush.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UIUtil.setEnabled((Component)GitVcsPanel.this.myProtectedBranchesButton, (boolean)GitVcsPanel.this.myEnableForcePush.isSelected(), (boolean)true);
                UIUtil.setEnabled((Component)GitVcsPanel.this.myProtectedBranchesLabel, (boolean)GitVcsPanel.this.myEnableForcePush.isSelected(), (boolean)false);
            }
        });
    }

    private void testConnection() {
        GitVersion version;
        String executable = this.getCurrentExecutablePath();
        if (this.myAppSettings != null) {
            this.myAppSettings.setPathToGit(executable);
        }
        try {
            version = GitVersion.identifyVersion(executable);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)this.myRootPanel, (String)e.getMessage(), (String)GitBundle.getString("find.git.error.title"));
            return;
        }
        if (version.isSupported()) {
            Messages.showInfoMessage((Component)this.myRootPanel, (String)String.format("<html>%s<br>Git version is %s</html>", GitBundle.getString("find.git.success.title"), version.toString()), (String)GitBundle.getString("find.git.success.title"));
        } else {
            Messages.showWarningDialog((Component)this.myRootPanel, (String)GitBundle.message("find.git.unsupported.message", version.toString(), GitVersion.MIN), (String)GitBundle.getString("find.git.success.title"));
        }
    }

    private String getCurrentExecutablePath() {
        return this.myGitField.getText().trim();
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    public void load(@NotNull GitVcsSettings settings, @NotNull GitSharedSettings sharedSettings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "git4idea/config/GitVcsPanel", "load"));
        }
        if (sharedSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedSettings", "git4idea/config/GitVcsPanel", "load"));
        }
        this.myGitField.setText(settings.getAppSettings().getPathToGit());
        this.mySSHExecutableComboBox.setSelectedItem(settings.isIdeaSsh() ? IDEA_SSH : NATIVE_SSH);
        this.myAutoUpdateIfPushRejected.setSelected(settings.autoUpdateIfPushRejected());
        this.mySyncControl.setSelected(settings.getSyncSetting() == DvcsSyncSettings.Value.SYNC);
        this.myAutoCommitOnCherryPick.setSelected(settings.isAutoCommitOnCherryPick());
        this.myWarnAboutCrlf.setSelected(settings.warnAboutCrlf());
        this.myWarnAboutDetachedHead.setSelected(settings.warnAboutDetachedHead());
        this.myEnableForcePush.setSelected(settings.isForcePushAllowed());
        this.myUpdateMethodComboBox.setSelectedItem((Object)settings.getUpdateType());
        this.myProtectedBranchesButton.setText((String)ParametersListUtil.COLON_LINE_JOINER.fun(sharedSettings.getForcePushProhibitedPatterns()));
    }

    public boolean isModified(@NotNull GitVcsSettings settings, @NotNull GitSharedSettings sharedSettings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "git4idea/config/GitVcsPanel", "isModified"));
        }
        if (sharedSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedSettings", "git4idea/config/GitVcsPanel", "isModified"));
        }
        return !settings.getAppSettings().getPathToGit().equals(this.getCurrentExecutablePath()) || settings.isIdeaSsh() != IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()) || !settings.autoUpdateIfPushRejected() == this.myAutoUpdateIfPushRejected.isSelected() || settings.getSyncSetting() == DvcsSyncSettings.Value.SYNC != this.mySyncControl.isSelected() || settings.isAutoCommitOnCherryPick() != this.myAutoCommitOnCherryPick.isSelected() || settings.warnAboutCrlf() != this.myWarnAboutCrlf.isSelected() || settings.warnAboutDetachedHead() != this.myWarnAboutDetachedHead.isSelected() || settings.isForcePushAllowed() != this.myEnableForcePush.isSelected() || settings.getUpdateType() != this.myUpdateMethodComboBox.getModel().getSelectedItem() || !((Object)ContainerUtil.sorted(sharedSettings.getForcePushProhibitedPatterns())).equals(ContainerUtil.sorted(this.getProtectedBranchesPatterns()));
    }

    public void save(@NotNull GitVcsSettings settings, GitSharedSettings sharedSettings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "git4idea/config/GitVcsPanel", "save"));
        }
        settings.getAppSettings().setPathToGit(this.getCurrentExecutablePath());
        this.myVcs.checkVersion();
        settings.getAppSettings().setIdeaSsh(IDEA_SSH.equals(this.mySSHExecutableComboBox.getSelectedItem()) ? GitVcsApplicationSettings.SshExecutable.IDEA_SSH : GitVcsApplicationSettings.SshExecutable.NATIVE_SSH);
        settings.setAutoUpdateIfPushRejected(this.myAutoUpdateIfPushRejected.isSelected());
        settings.setSyncSetting(this.mySyncControl.isSelected() ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        settings.setAutoCommitOnCherryPick(this.myAutoCommitOnCherryPick.isSelected());
        settings.setWarnAboutCrlf(this.myWarnAboutCrlf.isSelected());
        settings.setWarnAboutDetachedHead(this.myWarnAboutDetachedHead.isSelected());
        settings.setForcePushAllowed(this.myEnableForcePush.isSelected());
        settings.setUpdateType((UpdateMethod)((Object)this.myUpdateMethodComboBox.getSelectedItem()));
        sharedSettings.setForcePushProhibitedPatters(this.getProtectedBranchesPatterns());
    }

    @NotNull
    private List<String> getProtectedBranchesPatterns() {
        List list = (List)ParametersListUtil.COLON_LINE_PARSER.fun((Object)this.myProtectedBranchesButton.getText());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsPanel", "getProtectedBranchesPatterns"));
        }
        return list;
    }

    private void createUIComponents() {
        this.myProtectedBranchesButton = new TextFieldWithBrowseButton.NoPathCompletion(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Messages.showTextAreaDialog((JTextField)GitVcsPanel.this.myProtectedBranchesButton.getTextField(), (String)"Protected Branches", (String)"Git.Force.Push.Protected.Branches", (Function)ParametersListUtil.COLON_LINE_PARSER, (Function)ParametersListUtil.COLON_LINE_JOINER);
            }
        });
        this.myProtectedBranchesButton.setButtonIcon(AllIcons.Actions.ShowViewer);
        this.myUpdateMethodComboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(UpdateMethod.class));
        this.myUpdateMethodComboBox.setRenderer(new ListCellRendererWrapper<UpdateMethod>(){

            public void customize(JList list, UpdateMethod value, int index, boolean selected, boolean hasFocus) {
                this.setText(StringUtil.capitalize((String)StringUtil.toLowerCase((String)value.name().replace('_', ' '))));
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JBCheckBox jBCheckBox2;
        JCheckBox jCheckBox4;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JComboBox jComboBox;
        this.createUIComponents();
        JPanel jPanel = new JPanel();
        this.myRootPanel = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 7, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.path.label"));
        jLabel.setVerifyInputWhenFocusTarget(false);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.ssh.mode"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySSHExecutableComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGitField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setLabel(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test.label"));
        jButton.setHorizontalAlignment(0);
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("git.vcs.config.test"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 2, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 8, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAutoCommitOnCherryPick = jCheckBox4 = new JCheckBox();
        jCheckBox4.setIconTextGap(4);
        jCheckBox4.setText("Commit automatically on cherry-pick");
        jPanel5.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 8, 8, 0, 3, 0, null, null, null));
        this.myWarnAboutCrlf = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Warn if CRLF line separators are about to be committed");
        jBCheckBox2.setMnemonic('C');
        jBCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel5.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 8, 8, 0, 0, 0, null, null, null));
        this.myWarnAboutDetachedHead = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Warn when committing in detached HEAD or during rebase");
        jCheckBox3.setSelected(true);
        jPanel5.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 8, 8, 0, 3, 0, null, null, null));
        this.myEnableForcePush = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Allow force push");
        jCheckBox2.setMnemonic('F');
        jCheckBox2.setDisplayedMnemonicIndex(6);
        jCheckBox2.setSelected(true);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myProtectedBranchesButton;
        textFieldWithBrowseButton2.setText("");
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(6, 7, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myProtectedBranchesLabel = jBLabel = new JBLabel();
        jBLabel.setText("Protected branches:");
        jPanel5.add((Component)jBLabel, new GridConstraints(6, 6, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySyncControl = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("sync.setting"));
        jBCheckBox.setToolTipText("");
        jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 8, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Update method:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myAutoUpdateIfPushRejected = jCheckBox = new JCheckBox();
        jCheckBox.setIconTextGap(4);
        jCheckBox.setText("Auto-update if push of the current branch was rejected");
        jCheckBox.setMnemonic('P');
        jCheckBox.setDisplayedMnemonicIndex(15);
        jPanel5.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 8, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox2 = this.myUpdateMethodComboBox;
        jPanel5.add((Component)jComboBox2, new GridConstraints(4, 1, 1, 3, 8, 1, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

