/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceFolderType;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.android.AndroidUsagesTargetProvider;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRenameHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return false;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return false;
        }
        if (AndroidUsagesTargetProvider.findValueResourceTagInContext(editor, file) != null) {
            return true;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return element != null && AndroidRenameHandler.isPackageAttributeInManifest(project, element);
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidRenameHandler", "invoke"));
        }
        if (file == null || editor == null) {
            return;
        }
        XmlTag tag = AndroidUsagesTargetProvider.findValueResourceTagInContext(editor, file);
        if (tag != null) {
            ResourceUrl url = AndroidRenameHandler.findResourceReferenceUnderCaret(editor, file);
            if (url != null && !url.framework) {
                AndroidRenameHandler.performResourceReferenceRenaming(project, editor, dataContext, file, url);
            } else {
                AndroidRenameHandler.performValueResourceRenaming(project, editor, dataContext, tag);
            }
        } else {
            AndroidRenameHandler.performApplicationPackageRenaming(project, editor, dataContext);
        }
    }

    private static void performValueResourceRenaming(Project project, Editor editor, DataContext dataContext, XmlTag tag) {
        XmlAttribute nameAttribute = tag.getAttribute("name");
        if (nameAttribute == null) {
            return;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new RenameDialog(project, (PsiElement)new ValueResourceElementWrapper(attributeValue), null, editor));
    }

    private static void performResourceReferenceRenaming(Project project, Editor editor, DataContext dataContext, PsiFile file, ResourceUrl url) {
        PsiField[] resourceFields;
        assert (!url.framework);
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet != null && (resourceFields = AndroidResourceUtil.findResourceFields(facet, url.type.getName(), url.name, false)).length == 1) {
            RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new RenameDialog(project, (PsiElement)resourceFields[0], null, editor));
        }
    }

    @Nullable
    private static ResourceUrl findResourceReferenceUnderCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        XmlText text;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/android/AndroidRenameHandler", "findResourceReferenceUnderCaret"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/AndroidRenameHandler", "findResourceReferenceUnderCaret"));
        }
        if (!(file instanceof XmlFile)) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        if (!AndroidResourceUtil.isInResourceSubdirectory(file, ResourceFolderType.VALUES.getName())) {
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (text = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)element, XmlText.class)) != null) {
            return ResourceUrl.parse((String)text.getText().trim());
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/android/AndroidRenameHandler", "invoke"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return;
        }
        this.invoke(project, editor, file, dataContext);
    }

    public String getActionTitle() {
        return "Rename Android value resource";
    }

    static boolean isPackageAttributeInManifest(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidRenameHandler", "isPackageAttributeInManifest"));
        }
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)psiFile);
        if (facet == null) {
            return false;
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null || !vFile.equals(AndroidRootUtil.getManifestFile(facet))) {
            return false;
        }
        if (!(element instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return false;
        }
        GenericAttributeValue attrValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)parent);
        if (attrValue == null) {
            return false;
        }
        DomElement parentDomElement = attrValue.getParent();
        return parentDomElement instanceof Manifest && attrValue.equals(((Manifest)parentDomElement).getPackage());
    }

    private static void performApplicationPackageRenaming(@NotNull Project project, @NotNull Editor editor, @NotNull DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidRenameHandler", "performApplicationPackageRenaming"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/android/AndroidRenameHandler", "performApplicationPackageRenaming"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/AndroidRenameHandler", "performApplicationPackageRenaming"));
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (!(element instanceof XmlAttributeValue)) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)context, (RenameDialog)new RenameDialog(project, element, null, editor){

            @NotNull
            protected String getLabelText() {
                String string = "Rename Android application package of module '" + module.getName() + "' to:";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidRenameHandler$1", "getLabelText"));
                }
                return string;
            }

            protected void canRun() throws ConfigurationException {
                String name = this.getNewName();
                if (name.length() == 0) {
                    throw new ConfigurationException(AndroidBundle.message("specify.package.name.error", new Object[0]));
                }
                if (!AndroidUtils.isValidAndroidPackageName(name)) {
                    throw new ConfigurationException(AndroidBundle.message("not.valid.package.name.error", name));
                }
                if (!AndroidCommonUtils.contains2Identifiers((String)name)) {
                    throw new ConfigurationException(AndroidBundle.message("package.name.must.contain.2.ids.error", new Object[0]));
                }
                super.canRun();
            }
        });
    }
}

