/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightFilePointer
implements VirtualFilePointer {
    private final String myUrl;
    private VirtualFile myFile;

    public LightFilePointer(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/ui/LightFilePointer", "<init>"));
        }
        this.myUrl = url;
    }

    public LightFilePointer(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/ui/LightFilePointer", "<init>"));
        }
        this.myUrl = file.getUrl();
        this.myFile = file;
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        this.refreshFile();
        return this.myFile;
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/LightFilePointer", "getUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFileName() {
        if (this.myFile != null) {
            String string = this.myFile.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/LightFilePointer", "getFileName"));
            }
            return string;
        }
        int index = this.myUrl.lastIndexOf(47);
        String string = index >= 0 ? this.myUrl.substring(index + 1) : this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/LightFilePointer", "getFileName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        VirtualFile file = this.getFile();
        if (file != null) {
            String string = file.getPresentableUrl();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/LightFilePointer", "getPresentableUrl"));
            }
            return string;
        }
        String string = LightFilePointer.toPresentableUrl(this.myUrl);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/LightFilePointer", "getPresentableUrl"));
        }
        return string;
    }

    public static String toPresentableUrl(String url) {
        String path = VirtualFileManager.extractPath(url);
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        return path.replace('/', File.separatorChar);
    }

    @Override
    public boolean isValid() {
        return this.getFile() != null;
    }

    private void refreshFile() {
        if (this.myFile != null && this.myFile.isValid()) {
            return;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        this.myFile = virtualFile != null && virtualFile.isValid() ? virtualFile : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LightFilePointer)) {
            return false;
        }
        return this.myUrl.equals(((LightFilePointer)o).myUrl);
    }

    public int hashCode() {
        return this.myUrl.hashCode();
    }
}

