/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StdArrangementRuleAliasToken
extends StdArrangementSettingsToken
implements Cloneable {
    private String myName;
    private List<StdArrangementMatchRule> myDefinitionRules;

    public StdArrangementRuleAliasToken(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "<init>"));
        }
        this(name, ContainerUtil.emptyList());
    }

    public StdArrangementRuleAliasToken(@NotNull String name, @NotNull List<StdArrangementMatchRule> definitionRules) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "<init>"));
        }
        if (definitionRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "<init>"));
        }
        this(StdArrangementRuleAliasToken.createIdByName(name), name, definitionRules);
        this.myDefinitionRules = definitionRules;
    }

    public StdArrangementRuleAliasToken(@NotNull String id, @NotNull String name, @NotNull List<StdArrangementMatchRule> definitionRules) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "<init>"));
        }
        if (definitionRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "<init>"));
        }
        super(id, StdArrangementRuleAliasToken.createRepresentationValue(name), StdArrangementTokenType.ALIAS);
        this.myName = name;
        this.myDefinitionRules = definitionRules;
    }

    @NotNull
    private static String createRepresentationValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "createRepresentationValue"));
        }
        String string = "by " + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "createRepresentationValue"));
        }
        return string;
    }

    private static String createIdByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "createIdByName"));
        }
        return name.replaceAll("\\s+", "_");
    }

    public String getName() {
        return this.myName;
    }

    public List<StdArrangementMatchRule> getDefinitionRules() {
        return this.myDefinitionRules;
    }

    public void setDefinitionRules(List<StdArrangementMatchRule> definitionRules) {
        this.myDefinitionRules = definitionRules;
    }

    public void setTokenName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementRuleAliasToken", "setTokenName"));
        }
        this.myId = name.replaceAll("\\s+", "_");
        this.myRepresentationName = StdArrangementRuleAliasToken.createRepresentationValue(name);
        this.myName = name;
    }

    protected StdArrangementRuleAliasToken clone() {
        ArrayList<StdArrangementMatchRule> newValue = new ArrayList<StdArrangementMatchRule>(this.myDefinitionRules.size());
        for (StdArrangementMatchRule rule : this.myDefinitionRules) {
            newValue.add(rule.clone());
        }
        return new StdArrangementRuleAliasToken(this.getName(), newValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementRuleAliasToken token = (StdArrangementRuleAliasToken)o;
        if (!super.equals(o)) {
            return false;
        }
        return !(this.myDefinitionRules != null ? !((Object)this.myDefinitionRules).equals(token.myDefinitionRules) : token.myDefinitionRules != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myDefinitionRules != null ? ((Object)this.myDefinitionRules).hashCode() : 0);
        return result;
    }
}

