/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.inputs;

import com.google.common.collect.ImmutableMap;
import org.gradle.model.dsl.internal.inputs.RuleInputAccess;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelRuleInput;

public abstract class RuleInputAccessBacking {
    private static final ThreadLocal<ImmutableMap<String, Object>> INPUT = new ThreadLocal();

    private RuleInputAccessBacking() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithContext(Inputs inputs, Runnable runnable) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ModelRuleInput ruleInput : inputs.getRuleInputs()) {
            assert (ruleInput.getBinding().getReference().isUntyped());
            builder.put((Object)ruleInput.getBinding().getPath().toString(), ruleInput.getView().getInstance());
        }
        ImmutableMap inputsMap = builder.build();
        INPUT.set((ImmutableMap<String, Object>)inputsMap);
        try {
            runnable.run();
        }
        finally {
            INPUT.remove();
        }
    }

    public static RuleInputAccess getAccess() {
        final ImmutableMap<String, Object> inputs = INPUT.get();
        return new RuleInputAccess(){

            public Object input(String modelPath) {
                return inputs.get((Object)modelPath);
            }
        };
    }
}

