/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.template.Template;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;

public class SmartCompletionTemplateItem
extends LookupItem<Template>
implements TypedLookupItem {
    @NonNls
    private static final String PLACEHOLDER = "xxx";
    private final PsiElement myContext;

    public SmartCompletionTemplateItem(Template o, PsiElement context) {
        super(o, o.getKey());
        this.myContext = context;
    }

    @Override
    public PsiType getType() {
        Template template = (Template)this.getObject();
        String text = template.getTemplateText();
        StringBuilder resultingText = new StringBuilder(text);
        int segmentsCount = template.getSegmentsCount();
        for (int j = segmentsCount - 1; j >= 0; --j) {
            if (template.getSegmentName(j).equals("END")) continue;
            int segmentOffset = template.getSegmentOffset(j);
            resultingText.insert(segmentOffset, PLACEHOLDER);
        }
        try {
            PsiExpression templateExpression = JavaPsiFacade.getElementFactory((Project)this.myContext.getProject()).createExpressionFromText(resultingText.toString(), this.myContext);
            return templateExpression.getType();
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }
}

