/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepIntoBreakpoint
extends RunToCursorBreakpoint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint");
    @NotNull
    private final BreakpointStepMethodFilter myFilter;

    StepIntoBreakpoint(@NotNull Project project, @NotNull SourcePosition pos, @NotNull BreakpointStepMethodFilter filter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/StepIntoBreakpoint", "<init>"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/debugger/ui/breakpoints/StepIntoBreakpoint", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/debugger/ui/breakpoints/StepIntoBreakpoint", "<init>"));
        }
        super(project, pos, false);
        this.myFilter = filter;
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        try {
            int lastLine;
            CompoundPositionManager positionManager = debugProcess.getPositionManager();
            List<Location> locations = positionManager.locationsOfLine(classType, this.myCustomPosition);
            if (locations.isEmpty() && (lastLine = this.myFilter.getLastStatementLine()) >= 0) {
                int nextLine = this.myCustomPosition.getLine() + 1;
                while (nextLine <= lastLine && locations.isEmpty()) {
                    locations = positionManager.locationsOfLine(classType, SourcePosition.createFromLine((PsiFile)this.myCustomPosition.getFile(), (int)nextLine++));
                }
            }
            if (!locations.isEmpty()) {
                HashSet<Method> methods = new HashSet<Method>();
                for (Location loc : locations) {
                    if (!this.acceptLocation(debugProcess, classType, loc)) continue;
                    methods.add(loc.method());
                }
                Location location = null;
                int methodsFound = methods.size();
                if (methodsFound == 1) {
                    location = ((Method)methods.iterator().next()).location();
                } else if (this.myFilter instanceof LambdaMethodFilter) {
                    LambdaMethodFilter lambdaFilter = (LambdaMethodFilter)this.myFilter;
                    if (lambdaFilter.getLambdaOrdinal() < methodsFound) {
                        Method[] candidates = methods.toArray(new Method[methodsFound]);
                        Arrays.sort(candidates, new Comparator<Method>(){

                            @Override
                            public int compare(Method m1, Method m2) {
                                return StepIntoBreakpoint.getMethodOrdinal(m1) - StepIntoBreakpoint.getMethodOrdinal(m2);
                            }
                        });
                        location = candidates[lambdaFilter.getLambdaOrdinal()].location();
                    }
                } else if (methodsFound > 0) {
                    location = ((Method)methods.iterator().next()).location();
                }
                if (location != null) {
                    RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
                    BreakpointRequest request = requestsManager.createBreakpointRequest(this, location);
                    requestsManager.enableRequest(request);
                }
            }
        }
        catch (ClassNotPreparedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassNotPreparedException: " + ex.getMessage());
            }
        }
        catch (ObjectCollectedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ObjectCollectedException: " + ex.getMessage());
            }
        }
        catch (InternalException ex) {
            LOG.info((Throwable)ex);
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
        }
    }

    private static int getMethodOrdinal(Method m) {
        String name = m.name();
        int dollarIndex = name.lastIndexOf("$");
        if (dollarIndex < 0) {
            return 0;
        }
        try {
            return Integer.parseInt(name.substring(dollarIndex + 1));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected boolean acceptLocation(DebugProcessImpl debugProcess, ReferenceType classType, Location loc) {
        try {
            return this.myFilter.locationMatches(debugProcess, loc);
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
            return true;
        }
    }

    @Nullable
    protected static StepIntoBreakpoint create(@NotNull Project project, @NotNull BreakpointStepMethodFilter filter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/StepIntoBreakpoint", "create"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/debugger/ui/breakpoints/StepIntoBreakpoint", "create"));
        }
        SourcePosition pos = filter.getBreakpointPosition();
        if (pos != null) {
            StepIntoBreakpoint breakpoint = new StepIntoBreakpoint(project, pos, filter);
            breakpoint.init();
            return breakpoint;
        }
        return null;
    }
}

