/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DiffLineMarkerRenderer
implements LineMarkerRenderer {
    @NotNull
    private final TextDiffType myDiffType;

    public DiffLineMarkerRenderer(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffType", "com/intellij/diff/util/DiffLineMarkerRenderer", "<init>"));
        }
        this.myDiffType = diffType;
    }

    public void paint(Editor editor, Graphics g, Rectangle range) {
        Color color = this.myDiffType.getColor(editor);
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        Graphics2D g2 = (Graphics2D)g;
        int x = 0;
        int y = range.y;
        int width = gutter.getWidth();
        int height = range.height;
        if (height > 2) {
            g.setColor(color);
            g.fillRect(x, y, width, height);
            DiffDrawUtil.drawShadowedLine(g2, x, x + width, y - 1, color);
            DiffDrawUtil.drawShadowedLine(g2, x, x + width, y + height - 1, color);
        } else {
            DiffDrawUtil.drawDoubleShadowedLine(g2, x, x + width, y - 1, color);
        }
    }
}

