/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import org.jetbrains.annotations.NotNull;

public class FileHyperlinkParsedData {
    private final String myFilePath;
    private final int myDocumentLine;
    private final int myDocumentColumn;
    private final int myHyperlinkStartOffset;
    private final int myHyperlinkEndOffset;

    public FileHyperlinkParsedData(@NotNull String filePath, int documentLine, int documentColumn, int hyperlinkStartOffset, int hyperlinkEndOffset) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/execution/filters/FileHyperlinkParsedData", "<init>"));
        }
        this.myFilePath = filePath;
        this.myDocumentLine = documentLine;
        this.myDocumentColumn = documentColumn;
        this.myHyperlinkStartOffset = hyperlinkStartOffset;
        this.myHyperlinkEndOffset = hyperlinkEndOffset;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/FileHyperlinkParsedData", "getFilePath"));
        }
        return string;
    }

    public int getDocumentLine() {
        return this.myDocumentLine;
    }

    public int getDocumentColumn() {
        return this.myDocumentColumn;
    }

    public int getHyperlinkStartOffset() {
        return this.myHyperlinkStartOffset;
    }

    public int getHyperlinkEndOffset() {
        return this.myHyperlinkEndOffset;
    }
}

