/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import sun.swing.SwingUtilities2;

public class ActionButtonWithText
extends ActionButton {
    private static final int ICON_TEXT_SPACE = 2;
    private int myHorizontalTextPosition = 11;
    private int myHorizontalTextAlignment = 0;

    public ActionButtonWithText(AnAction action, Presentation presentation, String place, Dimension minimumSize) {
        super(action, presentation, place, minimumSize);
        this.setFont(UIUtil.getLabelFont());
        this.setForeground(UIUtil.getLabelForeground());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension basicSize = super.getPreferredSize();
        Icon icon = this.getIcon();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle viewRect = new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        Insets insets = this.getInsets();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), icon, 0, this.horizontalTextAlignment(), 0, this.horizontalTextPosition(), viewRect, iconR, textR, this.iconTextSpace());
        int x1 = Math.min(iconR.x, textR.x);
        int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
        int y1 = Math.min(iconR.y, textR.y);
        int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
        Dimension rv = new Dimension(x2 - x1, y2 - y1);
        rv.width = Math.max(rv.width += dx, basicSize.width);
        rv.height = Math.max(rv.height += dy, basicSize.height);
        return rv;
    }

    @Override
    public void paintComponent(Graphics g) {
        Icon icon = this.getIcon();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle viewRect = new Rectangle(this.getSize());
        Insets i = this.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        String text = SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), icon, 0, this.horizontalTextAlignment(), 0, this.horizontalTextPosition(), viewRect, iconRect, textRect, this.iconTextSpace());
        ActionButtonLook look = ActionButtonLook.IDEA_LOOK;
        look.paintBackground(g, this);
        look.paintIconAt(g, this, icon, iconRect.x, iconRect.y);
        look.paintBorder(g, this);
        UIUtil.applyRenderingHints((Graphics)g);
        g.setColor(this.isButtonEnabled() ? this.getForeground() : UIUtil.getInactiveTextColor());
        SwingUtilities2.drawStringUnderlineCharAt(this, g, text, this.getMnemonicCharIndex(text), textRect.x, textRect.y + fm.getAscent());
    }

    public void setHorizontalTextPosition(int position) {
        this.myHorizontalTextPosition = position;
    }

    public void setHorizontalTextAlignment(int alignment) {
        this.myHorizontalTextAlignment = alignment;
    }

    protected int horizontalTextPosition() {
        return this.myHorizontalTextPosition;
    }

    protected int horizontalTextAlignment() {
        return this.myHorizontalTextAlignment;
    }

    protected int iconTextSpace() {
        return this.getIcon() instanceof EmptyIcon || this.getIcon() == null ? 0 : 2;
    }

    private int getMnemonicCharIndex(String text) {
        Shortcut[] shortcuts;
        int mnemonicIndex = this.myPresentation.getDisplayedMnemonicIndex();
        if (mnemonicIndex != -1) {
            return mnemonicIndex;
        }
        ShortcutSet shortcutSet = this.myAction.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyStroke keyStroke;
            int modifiers;
            KeyboardShortcut keyboardShortcut;
            if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null || ((modifiers = (keyStroke = keyboardShortcut.getFirstKeyStroke()).getModifiers()) & 8) == 0) continue;
            return keyStroke.getKeyChar() != '\uffff' ? text.indexOf(keyStroke.getKeyChar()) : text.indexOf(KeyEvent.getKeyText(keyStroke.getKeyCode()));
        }
        return -1;
    }

    private String getText() {
        String text = this.myPresentation.getText();
        return text != null ? text : "";
    }
}

