/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.actions.MergeOperations;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeActionGroup
extends ActionGroup {
    private final MergeOperations myOperations;

    public MergeActionGroup(DiffPanelImpl diffPanel, FragmentSide side) {
        this.myOperations = new MergeOperations(diffPanel, side);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        List<MergeOperations.Operation> operations = this.myOperations.getOperations();
        AnAction[] actions = new AnAction[operations.size() + 2];
        actions[0] = new SelectSuggestionAction(this.myOperations);
        actions[1] = Separator.getInstance();
        for (int i = 2; i < actions.length; ++i) {
            actions[i] = new OperationAction(operations.get(i - 2));
        }
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/MergeActionGroup", "getChildren"));
        }
        return actions;
    }

    public static class OperationAction
    extends AnAction {
        private final MergeOperations.Operation myOperation;

        public OperationAction(MergeOperations.Operation operation) {
            super(operation.getName(), null, operation.getGutterIcon());
            this.myOperation = operation;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myOperation.perform((Project)CommonDataKeys.PROJECT.getData(e.getDataContext()));
        }
    }

    private static class SelectSuggestionAction
    extends AnAction {
        private final MergeOperations myOperations;

        public SelectSuggestionAction(MergeOperations operations) {
            super(DiffBundle.message((String)"diff.dialog.select.change.action.name", (Object[])new Object[0]), DiffBundle.message((String)"diff.dialog.select.change.action.description", (Object[])new Object[0]), null);
            this.myOperations = operations;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myOperations.selectSuggestion();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myOperations.getCurrentFragment() != null);
        }
    }
}

