/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class FragmentBoundRenderer
implements LineMarkerRenderer,
LineSeparatorRenderer {
    private final int myLineHeight;
    private final Editor myEditor;
    private final Consumer<Integer> myOffsetsConsumer;
    private final ShoeneLine myShoeneLine;
    private final Color myMainColor;
    private static final int xVariation = 7;

    public FragmentBoundRenderer(int lineHeight, Editor editor, Consumer<Integer> offsetsConsumer) {
        this.myLineHeight = lineHeight;
        this.myEditor = editor;
        this.myOffsetsConsumer = offsetsConsumer;
        this.myShoeneLine = new ShoeneLine(2);
        this.myMainColor = FragmentBoundRenderer.darkerBorder();
    }

    public static Color darkerBorder() {
        Color borderColor = UIUtil.getBorderColor();
        return new Color(borderColor.getRed() + 10, borderColor.getGreen() + 10, borderColor.getBlue() + 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Editor editor, Graphics g, Rectangle r) {
        Graphics gr = g.create();
        try {
            ((Graphics2D)gr).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gr.setColor(this.getColor());
            int y = r.y;
            int width = ((EditorEx)editor).getGutterComponentEx().getWidth();
            int editorWidth = editor.getScrollingModel().getVisibleArea().width;
            this.myShoeneLine.ensureLastX(editorWidth + width + width);
            if (((EditorImpl)editor).isMirrored()) {
                int j;
                Couple<Integer> integerIntegerPair;
                int i;
                List<Couple<Integer>> points = this.myShoeneLine.getPoints();
                for (i = 0; i < points.size() && (Integer)(integerIntegerPair = points.get(i)).getFirst() - width < editorWidth; ++i) {
                }
                i = i == 0 ? 0 : i - 1;
                points = points.subList(i, points.size());
                this.drawCurved(gr, 0, r.y, 3, points, width + editorWidth, true, width);
                gr.setColor(this.getColor().darker());
                this.drawCurved(gr, 0, r.y, 2, points, width + editorWidth, true, width);
                int finalX = width + editorWidth;
                for (j = points.size() - 1; j > 0 && (Integer)points.get(j).getFirst() < finalX; --j) {
                }
                this.myOffsetsConsumer.consume(points.get(j).getSecond());
            } else {
                List<Couple<Integer>> points = this.myShoeneLine.getPoints();
                this.drawCurved(gr, 0, r.y, 3, points, 0, false, 0);
                gr.setColor(this.getColor().darker());
                this.drawCurved(gr, 0, r.y, 2, points, 0, false, 0);
                this.myOffsetsConsumer.consume(points.get(0).getSecond());
            }
        }
        finally {
            gr.dispose();
        }
    }

    public Color getColor() {
        return this.myMainColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(Graphics g, int x1, int x2, int y) {
        int length = x2 - x1;
        if (length == 0) {
            return;
        }
        int width = ((EditorEx)this.myEditor).getGutterComponentEx().getWidth();
        this.myShoeneLine.ensureLastX(length + width);
        Graphics gr = g.create();
        try {
            ((Graphics2D)gr).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gr.setColor(this.getColor());
            List<Couple<Integer>> points = this.myShoeneLine.getPoints();
            int i = this.getLastPointInBeforeGutter(width, points);
            points = points.subList(i, points.size());
            this.drawCurved(gr, x1, y, 3, points, width, false, 0);
            gr.setColor(this.getColor().darker());
            this.drawCurved(gr, x1, y, 2, points, width, false, 0);
        }
        finally {
            gr.dispose();
        }
    }

    private int getLastPointInBeforeGutter(int width, List<Couple<Integer>> points) {
        int i;
        for (i = 0; i < points.size() && (Integer)points.get(i).getFirst() < width; ++i) {
        }
        i = i == 0 ? 0 : i - 1;
        return i;
    }

    private void drawCurved(Graphics g, int x1, int y, int offset, List<Couple<Integer>> points, int subtractX, boolean mirrorX, int mirrorSize) {
        Iterator<Couple<Integer>> iterator = points.iterator();
        assert (iterator.hasNext());
        int[] xPoints = new int[points.size()];
        int[] yPoints1 = new int[points.size()];
        int[] yPoints2 = new int[points.size()];
        int n = 0;
        Couple<Integer> previous = iterator.next();
        while (iterator.hasNext()) {
            Couple<Integer> next = iterator.next();
            xPoints[n] = FragmentBoundRenderer.convert((Integer)previous.getFirst(), x1, subtractX, mirrorX, mirrorSize);
            yPoints1[n] = y + offset + (Integer)previous.getSecond() - this.myLineHeight / 2;
            yPoints2[n] = y - offset + (Integer)previous.getSecond() - this.myLineHeight / 2;
            ++n;
            previous = next;
        }
        xPoints[n] = FragmentBoundRenderer.convert((Integer)previous.getFirst(), x1, subtractX, mirrorX, mirrorSize);
        yPoints1[n] = y + offset + (Integer)previous.getSecond() - this.myLineHeight / 2;
        yPoints2[n] = y - offset + (Integer)previous.getSecond() - this.myLineHeight / 2;
        g.drawPolyline(xPoints, yPoints1, points.size());
        g.drawPolyline(xPoints, yPoints2, points.size());
    }

    private static int convert(int value, int x1, int subtractX, boolean mirrorX, int mirrorSize) {
        int val = x1 + value - subtractX;
        if (mirrorX) {
            return mirrorSize - val;
        }
        return val;
    }

    private static List<Couple<Integer>> generateLine(int startX, int startY, int finalX, int yBase, int yDiff, int wasPrevStep) {
        int xCurrent = startX;
        int yCurrent = startY;
        ArrayList<Couple<Integer>> result = new ArrayList<Couple<Integer>>();
        Random xRnd = new Random();
        Random yRnd = new Random();
        int prevStep = wasPrevStep;
        while (xCurrent < finalX) {
            int yStep = prevStep;
            while (prevStep == yStep) {
                yStep = yRnd.nextInt(yDiff * 2) - yDiff;
            }
            prevStep = yStep;
            int newY = yBase + yStep;
            int newX = xCurrent + 4 + xRnd.nextInt(7);
            newX = Math.min(newX, finalX);
            result.add((Couple<Integer>)Couple.of((Object)newX, (Object)newY));
            xCurrent = newX;
        }
        return result;
    }

    private static class ShoeneLine {
        private List<Couple<Integer>> myPoints;
        private final int myYDiff;

        private ShoeneLine(int yDiff) {
            this.myYDiff = yDiff;
            this.myPoints = new ArrayList<Couple<Integer>>();
        }

        public void ensureLastX(int x) {
            if (this.myPoints.isEmpty() || (Integer)this.myPoints.get(this.myPoints.size() - 1).getFirst() < x) {
                if (this.myPoints.isEmpty()) {
                    this.myPoints.add((Couple<Integer>)Couple.of((Object)0, (Object)0));
                    this.myPoints.addAll(FragmentBoundRenderer.generateLine(0, 0, x, 0, this.myYDiff, 0));
                } else {
                    Couple<Integer> lastPoint = this.myPoints.get(this.myPoints.size() - 1);
                    int finalX = x - (Integer)lastPoint.getFirst() < 5 ? x + 10 : x;
                    this.myPoints.addAll(FragmentBoundRenderer.generateLine((Integer)lastPoint.getFirst(), (Integer)lastPoint.getSecond(), finalX, 0, this.myYDiff, (Integer)lastPoint.getSecond()));
                }
            }
        }

        public List<Couple<Integer>> getPoints() {
            return this.myPoints;
        }
    }
}

