/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.softwrap.ArrowSoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.TextBasedSoftWrapPainter;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeSoftWrapPainter
implements SoftWrapPainter {
    public static final String CUSTOM_BEFORE_SOFT_WRAP_SIGN_KEY = "idea.editor.wrap.soft.before.code";
    public static final String CUSTOM_AFTER_SOFT_WRAP_SIGN_KEY = "idea.editor.wrap.soft.after.code";
    private static final Logger LOG;
    private static final List<Map<SoftWrapDrawingType, Character>> SYMBOLS;
    private final EditorEx myEditor;
    private SoftWrapPainter myDelegate;
    private int mySymbolsDrawingIndex = -1;

    public CompositeSoftWrapPainter(EditorEx editor) {
        this.myEditor = editor;
    }

    @Nullable
    private static Character parse(String key) {
        int code;
        String value = System.getProperty(key);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        try {
            code = Integer.parseInt(value, 16);
        }
        catch (NumberFormatException e) {
            LOG.info(String.format("Detected invalid code for system property '%s' - '%s'. Expected to find hex number there. Custom soft wraps signs will not be applied", key, value));
            return null;
        }
        return Character.valueOf((char)code);
    }

    @Override
    public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/softwrap/CompositeSoftWrapPainter", "paint"));
        }
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/CompositeSoftWrapPainter", "paint"));
        }
        this.initDelegateIfNecessary();
        if (!this.myEditor.getSettings().isAllSoftWrapsShown()) {
            int visualLine = y / lineHeight;
            LogicalPosition position = this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, 0));
            if (position.line != this.myEditor.getCaretModel().getLogicalPosition().line) {
                return this.myDelegate.getDrawingHorizontalOffset(g, drawingType, x, y, lineHeight);
            }
        }
        return this.myDelegate.paint(g, drawingType, x, y, lineHeight);
    }

    @Override
    public int getDrawingHorizontalOffset(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/softwrap/CompositeSoftWrapPainter", "getDrawingHorizontalOffset"));
        }
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/CompositeSoftWrapPainter", "getDrawingHorizontalOffset"));
        }
        this.initDelegateIfNecessary();
        return this.myDelegate.getDrawingHorizontalOffset(g, drawingType, x, y, lineHeight);
    }

    @Override
    public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/CompositeSoftWrapPainter", "getMinDrawingWidth"));
        }
        this.initDelegateIfNecessary();
        return this.myDelegate.getMinDrawingWidth(drawingType);
    }

    @Override
    public boolean canUse() {
        return true;
    }

    private void initDelegateIfNecessary() {
        if (this.myDelegate != null && this.myDelegate.canUse()) {
            return;
        }
        if (++this.mySymbolsDrawingIndex < SYMBOLS.size()) {
            TextDrawingCallback callback = this.myEditor.getTextDrawingCallback();
            ColorProvider colorHolder = ColorProvider.byColorScheme(this.myEditor, EditorColors.SOFT_WRAP_SIGN_COLOR);
            this.myDelegate = new TextBasedSoftWrapPainter(SYMBOLS.get(this.mySymbolsDrawingIndex), this.myEditor, callback, colorHolder);
            this.initDelegateIfNecessary();
            return;
        }
        this.myDelegate = new ArrowSoftWrapPainter(this.myEditor);
    }

    @Override
    public void reinit() {
        this.myDelegate = null;
        this.mySymbolsDrawingIndex = -1;
    }

    private static <K, V> Map<K, V> asMap(Iterable<K> keys, Iterable<V> values) throws IllegalArgumentException {
        HashMap<K, V> result = new HashMap<K, V>();
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        while (keyIterator.hasNext()) {
            if (!valueIterator.hasNext()) {
                throw new IllegalArgumentException(String.format("Can't build for the given data. Reason: number of keys differs from number of values. Keys: %s, values: %s", keys, values));
            }
            result.put(keyIterator.next(), valueIterator.next());
        }
        if (valueIterator.hasNext()) {
            throw new IllegalArgumentException(String.format("Can't build for the given data. Reason: number of keys differs from number of values. Keys: %s, values: %s", keys, values));
        }
        return result;
    }

    static {
        Character customAfterSymbol;
        LOG = Logger.getInstance((String)("#" + CompositeSoftWrapPainter.class.getName()));
        SYMBOLS = new ArrayList<Map<SoftWrapDrawingType, Character>>();
        Character customBeforeSymbol = CompositeSoftWrapPainter.parse(CUSTOM_BEFORE_SOFT_WRAP_SIGN_KEY);
        if (customBeforeSymbol != null && (customAfterSymbol = CompositeSoftWrapPainter.parse(CUSTOM_AFTER_SOFT_WRAP_SIGN_KEY)) != null) {
            LOG.info(String.format("Picked up custom soft wrap drawing symbols: '%c' and '%c'", customBeforeSymbol, customAfterSymbol));
            SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(customBeforeSymbol, customAfterSymbol)));
        }
        if (!SystemInfo.isAppleJvm) {
            SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\u2926'), Character.valueOf('\u2925'))));
        }
        SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\u21b2'), Character.valueOf('\u21b3'))));
        SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\u2936'), Character.valueOf('\u2937'))));
        SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\u21a9'), Character.valueOf('\u21aa'))));
        SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\ue48b'), Character.valueOf('\ue48c'))));
    }
}

