/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorDialogBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ui.FormBuilder;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewLibraryDialog
extends LibraryEditorDialogBase {
    private final StructureConfigurableContext myContext;
    private final NewLibraryEditor myLibraryEditor;
    private final ComboBox myLibraryLevelCombobox;

    public CreateNewLibraryDialog(@NotNull JComponent parent, @NotNull StructureConfigurableContext context, @NotNull NewLibraryEditor libraryEditor, @NotNull List<LibraryTable> libraryTables, int selectedTable) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryDialog", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryDialog", "<init>"));
        }
        if (libraryEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryEditor", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryDialog", "<init>"));
        }
        if (libraryTables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTables", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryDialog", "<init>"));
        }
        super(parent, new LibraryRootsComponent(context.getProject(), libraryEditor));
        this.myContext = context;
        this.myLibraryEditor = libraryEditor;
        DefaultComboBoxModel<LibraryTable> model = new DefaultComboBoxModel<LibraryTable>();
        for (LibraryTable table : libraryTables) {
            model.addElement(table);
        }
        this.myLibraryLevelCombobox = new ComboBox(model);
        this.myLibraryLevelCombobox.setSelectedIndex(selectedTable);
        this.myLibraryLevelCombobox.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof LibraryTable) {
                    this.setText(((LibraryTable)value).getPresentation().getDisplayName(false));
                }
            }
        });
        this.init();
    }

    @Override
    @NotNull
    protected LibraryTable.ModifiableModel getTableModifiableModel() {
        LibraryTable selectedTable = (LibraryTable)this.myLibraryLevelCombobox.getSelectedItem();
        LibraryTable.ModifiableModel modifiableModel = this.myContext.getModifiableLibraryTable(selectedTable);
        if (modifiableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryDialog", "getTableModifiableModel"));
        }
        return modifiableModel;
    }

    @NotNull
    public Library createLibrary() {
        LibraryTableBase.ModifiableModelEx modifiableModel = (LibraryTableBase.ModifiableModelEx)this.getTableModifiableModel();
        LibraryType<?> type = this.myLibraryEditor.getType();
        Library library = modifiableModel.createLibrary(this.myLibraryEditor.getName(), type != null ? type.getKind() : null);
        final LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        this.myLibraryEditor.applyTo(model);
        new WriteAction(){

            protected void run(Result result) {
                model.commit();
            }
        }.execute();
        Library library2 = library;
        if (library2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryDialog", "createLibrary"));
        }
        return library2;
    }

    @Override
    protected void addNorthComponents(FormBuilder formBuilder) {
        formBuilder.addLabeledComponent("&Level:", (JComponent)this.myLibraryLevelCombobox);
    }

    @Override
    protected boolean shouldCheckName(String newName) {
        return true;
    }

    @Nullable
    protected String getHelpId() {
        return "Create_Library_dialog";
    }
}

