/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsEventsListenerManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.impl.VcsEnvironmentsProxyCreator;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class VcsEventsListenerManagerImpl
implements VcsEventsListenerManager,
VcsEnvironmentsProxyCreator {
    private final Wrapper<CheckinEnvironment> myCheckinWrapper = new Wrapper(CheckinEnvironment.class);
    private final Wrapper<UpdateEnvironment> myUpdateWrapper = new Wrapper(UpdateEnvironment.class);
    private final Wrapper<RollbackEnvironment> myRollbackWrapper = new Wrapper(RollbackEnvironment.class);

    public Object addCheckin(Consumer<Pair<VcsKey, Consumer<CheckinEnvironment>>> consumer) {
        return this.myCheckinWrapper.add(consumer);
    }

    public Object addUpdate(Consumer<Pair<VcsKey, Consumer<UpdateEnvironment>>> consumer) {
        return this.myUpdateWrapper.add(consumer);
    }

    public Object addRollback(Consumer<Pair<VcsKey, Consumer<RollbackEnvironment>>> consumer) {
        return this.myRollbackWrapper.add(consumer);
    }

    public void removeCheckin(Object key) {
        this.myCheckinWrapper.remove(key);
    }

    public void removeUpdate(Object key) {
        this.myUpdateWrapper.remove(key);
    }

    public void removeRollback(Object key) {
        this.myRollbackWrapper.remove(key);
    }

    @Nullable
    public CheckinEnvironment proxyCheckin(VcsKey key, CheckinEnvironment environment) {
        return this.myCheckinWrapper.createProxy(key, environment);
    }

    @Nullable
    public UpdateEnvironment proxyUpdate(VcsKey key, UpdateEnvironment environment) {
        return this.myUpdateWrapper.createProxy(key, environment);
    }

    @Nullable
    public RollbackEnvironment proxyRollback(VcsKey key, RollbackEnvironment environment) {
        return this.myRollbackWrapper.createProxy(key, environment);
    }

    private static class Wrapper<T> {
        private final Map<Object, EventListenerWrapperI> myListenersMap;
        private final Map<VcsKey, EventDispatcher<EventListenerWrapperI>> myExistingMulticasters;
        private final Class<T> myClazz;
        private final Object myLock;
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsEventsListenerManagerImpl.Wrapper");

        private Wrapper(Class<T> clazz) {
            this.myClazz = clazz;
            this.myListenersMap = new HashMap<Object, EventListenerWrapperI>();
            this.myExistingMulticasters = Collections.synchronizedMap(new HashMap());
            this.myLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public T createProxy(final VcsKey key, final @Nullable T environment) {
            EventDispatcher eventDispatcher;
            if (environment == null) {
                return null;
            }
            Object object = this.myLock;
            synchronized (object) {
                assert (!this.myExistingMulticasters.containsKey(key));
                eventDispatcher = EventDispatcher.create(EventListenerWrapperI.class);
                this.myExistingMulticasters.put(key, (EventDispatcher<EventListenerWrapperI>)eventDispatcher);
                for (EventListenerWrapperI wrapper : this.myListenersMap.values()) {
                    eventDispatcher.addListener((EventListener)wrapper);
                }
            }
            Object proxy = Proxy.newProxyInstance(this.myClazz.getClassLoader(), new Class[]{this.myClazz}, new InvocationHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                    method.setAccessible(true);
                    Object object = Wrapper.this.myLock;
                    synchronized (object) {
                        ((EventListenerWrapperI)eventDispatcher.getMulticaster()).consume(new Pair((Object)key, (Object)new Consumer<T>(){

                            public void consume(T t) {
                                try {
                                    method.invoke(t, args);
                                }
                                catch (IllegalAccessException e) {
                                    LOG.info((Throwable)e);
                                }
                                catch (InvocationTargetException e) {
                                    LOG.info((Throwable)e);
                                }
                            }
                        }));
                    }
                    return method.invoke(environment, args);
                }
            });
            return (T)proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object add(Consumer<Pair<VcsKey, Consumer<T>>> consumer) {
            Object key = new Object();
            Object object = this.myLock;
            synchronized (object) {
                EventListenerWrapper<T> listenerWrapper = new EventListenerWrapper<T>(consumer);
                this.myListenersMap.put(key, listenerWrapper);
                for (EventDispatcher<EventListenerWrapperI> eventDispatcher : this.myExistingMulticasters.values()) {
                    eventDispatcher.addListener(listenerWrapper);
                }
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Object key) {
            Object object = this.myLock;
            synchronized (object) {
                EventListenerWrapperI listenerWrapper = this.myListenersMap.remove(key);
                if (listenerWrapper != null) {
                    for (EventDispatcher<EventListenerWrapperI> dispatcher : this.myExistingMulticasters.values()) {
                        dispatcher.removeListener((EventListener)listenerWrapper);
                    }
                }
            }
        }

        private static class EventListenerWrapper<T>
        implements EventListenerWrapperI<T> {
            private final Consumer<Pair<VcsKey, Consumer<T>>> myConsumer;

            public EventListenerWrapper(Consumer<Pair<VcsKey, Consumer<T>>> consumer) {
                this.myConsumer = consumer;
            }

            public void consume(Pair<VcsKey, Consumer<T>> vcsKeyConsumerPair) {
                this.myConsumer.consume(vcsKeyConsumerPair);
            }
        }

        private static interface EventListenerWrapperI<T>
        extends Consumer<Pair<VcsKey, Consumer<T>>>,
        EventListener {
        }
    }
}

