/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ForwardDependenciesBuilder
extends DependenciesBuilder {
    private final Map<PsiFile, Set<PsiFile>> myDirectDependencies;

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/ForwardDependenciesBuilder", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/packageDependencies/ForwardDependenciesBuilder", "<init>"));
        }
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
    }

    public ForwardDependenciesBuilder(Project project, AnalysisScope scope, AnalysisScope scopeOfInterest) {
        super(project, scope, scopeOfInterest);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
    }

    public ForwardDependenciesBuilder(Project project, AnalysisScope scope, int transitive) {
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myTransitive = transitive;
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisScopeBundle.message((String)"forward.dependencies.usage.view.root.node.text", (Object[])new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisScopeBundle.message((String)"forward.dependencies.usage.view.initial.text", (Object[])new Object[0]);
    }

    @Override
    public boolean isBackward() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze() {
        final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        psiManager.startBatchFilesProcessingMode();
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        try {
            this.getScope().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitFile(PsiFile file) {
                    ForwardDependenciesBuilder.this.visit(file, fileIndex, psiManager, 0);
                }
            });
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private void visit(PsiFile file, final ProjectFileIndex fileIndex, PsiManager psiManager, int depth) {
        final FileViewProvider viewProvider = file.getViewProvider();
        if (viewProvider.getBaseLanguage() != file.getLanguage()) {
            return;
        }
        if (this.getScopeOfInterest() != null && !this.getScopeOfInterest().contains((PsiElement)file)) {
            return;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        VirtualFile virtualFile = file.getVirtualFile();
        if (indicator != null) {
            if (indicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
            indicator.setText(AnalysisScopeBundle.message((String)"package.dependencies.progress.text", (Object[])new Object[0]));
            if (virtualFile != null) {
                indicator.setText2(this.getRelativeToProjectPath(virtualFile));
            }
            if (this.myTotalFileCount > 0) {
                indicator.setFraction((double)(++this.myFileCount) / (double)this.myTotalFileCount);
            }
        }
        boolean isInLibrary = virtualFile == null || fileIndex.isInLibrarySource(virtualFile) || fileIndex.isInLibraryClasses(virtualFile);
        HashSet<Object> collectedDeps = new HashSet<Object>();
        HashSet<PsiFile> processed = new HashSet<PsiFile>();
        collectedDeps.add(file);
        do {
            if (depth++ > this.getTransitiveBorder()) {
                return;
            }
            for (PsiFile psiFile : new HashSet(collectedDeps)) {
                VirtualFile vFile = psiFile.getVirtualFile();
                if (vFile != null) {
                    if (indicator != null) {
                        indicator.setText2(this.getRelativeToProjectPath(vFile));
                    }
                    if (!isInLibrary && (fileIndex.isInLibraryClasses(vFile) || fileIndex.isInLibrarySource(vFile))) {
                        processed.add(psiFile);
                    }
                }
                final HashSet found = new HashSet();
                if (processed.contains(psiFile)) continue;
                processed.add(psiFile);
                ForwardDependenciesBuilder.analyzeFileDependencies(psiFile, new DependenciesBuilder.DependencyProcessor(){

                    @Override
                    public void process(PsiElement place, PsiElement dependency) {
                        PsiFile dependencyFile = dependency.getContainingFile();
                        if (dependencyFile != null) {
                            VirtualFile virtualFile;
                            if (viewProvider == dependencyFile.getViewProvider()) {
                                return;
                            }
                            if (dependencyFile.isPhysical() && (virtualFile = dependencyFile.getVirtualFile()) != null && (fileIndex.isInContent(virtualFile) || fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInLibrarySource(virtualFile))) {
                                found.add(dependencyFile);
                            }
                        }
                    }
                });
                Set<PsiFile> deps = this.getDependencies().get(file);
                if (deps == null) {
                    deps = new HashSet<PsiFile>();
                    this.getDependencies().put(file, deps);
                }
                deps.addAll(found);
                this.getDirectDependencies().put(psiFile, new HashSet(found));
                collectedDeps.addAll(found);
                psiManager.dropResolveCaches();
                InjectedLanguageManager.getInstance((Project)file.getProject()).dropFileCaches(file);
            }
            collectedDeps.removeAll(processed);
        } while (this.isTransitive() && !collectedDeps.isEmpty());
    }

    @Override
    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        return this.myDirectDependencies;
    }
}

