/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.impl.source.tree.MarkersHolderFileViewProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final Object lock = new Object();
    private static final ReferenceQueue<SmartPointerEx> ourQueue = new ReferenceQueue();
    private static final LowMemoryWatcher ourWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

        @Override
        public void run() {
            SmartPointerManagerImpl.processQueue();
        }
    });
    private final Project myProject;
    private final Key<Set<PointerReference>> POINTERS_KEY;
    private final Key<Boolean> POINTERS_ARE_FASTENED_KEY;
    private static final Key<Reference<SmartPointerEx>> CACHED_SMART_POINTER_KEY = Key.create((String)"CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
        this.POINTERS_KEY = Key.create((String)("SMART_POINTERS for " + project));
        this.POINTERS_ARE_FASTENED_KEY = Key.create((String)("SMART_POINTERS_ARE_FASTENED for " + project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            Object object = lock;
            synchronized (object) {
                Set pointers = (Set)reference.file.getUserData(reference.key);
                if (pointers != null) {
                    pointers.remove(reference);
                    if (pointers.isEmpty()) {
                        reference.file.putUserData(reference.key, null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastenBelts(@NotNull VirtualFile file, int offset, @Nullable RangeMarker[] cachedRangeMarkers) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "fastenBelts"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        SmartPointerManagerImpl.processQueue();
        Object object = lock;
        synchronized (object) {
            List<SmartPointerEx> pointers = this.getStrongPointers(file);
            if (pointers.isEmpty()) {
                return;
            }
            if (this.getAndFasten(file)) {
                return;
            }
            for (SmartPointerEx pointer : pointers) {
                pointer.fastenBelt(offset, cachedRangeMarkers);
            }
            PsiFile psiFile = ((PsiManagerEx)PsiManager.getInstance((Project)this.myProject)).getFileManager().getCachedPsiFile(file);
            if (psiFile != null) {
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                for (DocumentWindow injectedDoc : InjectedLanguageManager.getInstance((Project)this.myProject).getCachedInjectedDocuments(psiFile)) {
                    PsiFile injectedFile = psiDocumentManager.getPsiFile((Document)injectedDoc);
                    if (injectedFile == null) continue;
                    RangeMarker[] cachedMarkers = SmartPointerManagerImpl.getCachedRangeMarkerToInjectedFragment(injectedFile);
                    boolean relevant = false;
                    for (Segment hostSegment : injectedDoc.getHostRanges()) {
                        if (offset > hostSegment.getEndOffset()) continue;
                        relevant = true;
                        break;
                    }
                    if (!relevant) continue;
                    this.fastenBelts(injectedFile.getViewProvider().getVirtualFile(), 0, cachedMarkers);
                }
            }
        }
    }

    @NotNull
    private static RangeMarker[] getCachedRangeMarkerToInjectedFragment(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedRangeMarkerToInjectedFragment"));
        }
        MarkersHolderFileViewProvider provider = (MarkersHolderFileViewProvider)injectedFile.getViewProvider();
        RangeMarker[] rangeMarkerArray = provider.getCachedMarkers();
        if (rangeMarkerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedRangeMarkerToInjectedFragment"));
        }
        return rangeMarkerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfastenBelts(@NotNull VirtualFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "unfastenBelts"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        SmartPointerManagerImpl.processQueue();
        Object object = lock;
        synchronized (object) {
            List<SmartPointerEx> pointers = this.getStrongPointers(file);
            if (pointers.isEmpty()) {
                return;
            }
            if (!this.getAndUnfasten(file)) {
                return;
            }
            for (SmartPointerEx pointer : pointers) {
                pointer.unfastenBelt(offset);
            }
            PsiFile psiFile = ((PsiManagerEx)PsiManager.getInstance((Project)this.myProject)).getFileManager().getCachedPsiFile(file);
            if (psiFile != null) {
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                for (DocumentWindow injectedDoc : InjectedLanguageManager.getInstance((Project)this.myProject).getCachedInjectedDocuments(psiFile)) {
                    PsiFile injectedFile = psiDocumentManager.getPsiFile((Document)injectedDoc);
                    if (injectedFile == null) continue;
                    this.unfastenBelts(injectedFile.getViewProvider().getVirtualFile(), 0);
                }
            }
        }
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            PsiUtilCore.ensureValid(element);
            LOG.error("Invalid element:" + element);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPointerEx<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (pointer != null) {
            PsiFile psiFile = containingFile = containingFile == null ? element.getContainingFile() : containingFile;
            if (containingFile != null && this.areBeltsFastened(containingFile.getViewProvider().getVirtualFile())) {
                pointer.fastenBelt(0, null);
            }
        } else {
            pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile);
            if (containingFile != null) {
                this.initPointer(pointer, containingFile.getViewProvider().getVirtualFile());
            }
            element.putUserData(CACHED_SMART_POINTER_KEY, (Object)new SoftReference(pointer));
        }
        if (pointer instanceof SmartPsiElementPointerImpl) {
            Object object = lock;
            synchronized (object) {
                ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(1);
            }
        }
        SmartPointerEx<E> smartPointerEx = pointer;
        if (smartPointerEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPointerEx;
    }

    private static <E extends PsiElement> SmartPointerEx<E> getCachedPointer(@NotNull E element) {
        PsiElement cachedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedPointer"));
        }
        Reference data = (Reference)element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPointerEx cachedPointer = (SmartPointerEx)SoftReference.dereference((Reference)data);
        if (cachedPointer != null && (cachedElement = cachedPointer.getCachedElement()) != null && cachedElement != element) {
            return null;
        }
        return cachedPointer;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (!file.isValid()) {
            LOG.error("Invalid element:" + file);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file, ProperTextRange.create((Segment)range));
        this.initPointer(pointer, file.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRangePointerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends PsiElement> void initPointer(@NotNull SmartPointerEx<E> pointer, @NotNull VirtualFile containingFile) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "initPointer"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "initPointer"));
        }
        Object object = lock;
        synchronized (object) {
            THashSet pointers = this.getPointers(containingFile);
            if (pointers == null) {
                pointers = ContainerUtil.newTroveSet();
                containingFile.putUserData(this.POINTERS_KEY, (Object)pointers);
            }
            pointers.add(new PointerReference(pointer, containingFile, ourQueue, this.POINTERS_KEY));
            if (this.areBeltsFastened(containingFile)) {
                pointer.fastenBelt(0, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "removePointer"));
        }
        Object object = lock;
        synchronized (object) {
            int refCount;
            if (pointer instanceof SmartPsiElementPointerImpl && (refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1)) == 0) {
                PsiFile containingFile;
                PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
                if (element != null) {
                    element.putUserData(CACHED_SMART_POINTER_KEY, null);
                }
                if ((containingFile = pointer.getContainingFile()) == null) {
                    return false;
                }
                VirtualFile vFile = containingFile.getViewProvider().getVirtualFile();
                Set<PointerReference> pointers = this.getPointers(vFile);
                if (pointers == null) {
                    return false;
                }
                SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
                info.cleanup();
                Iterator<PointerReference> iterator = pointers.iterator();
                while (iterator.hasNext()) {
                    if (pointer != iterator.next().get()) continue;
                    iterator.remove();
                    if (pointers.isEmpty()) {
                        vFile.putUserData(this.POINTERS_KEY, null);
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Nullable
    private Set<PointerReference> getPointers(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointers"));
        }
        return (Set)containingFile.getUserData(this.POINTERS_KEY);
    }

    @NotNull
    private List<SmartPointerEx> getStrongPointers(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getStrongPointers"));
        }
        Set<PointerReference> refs = this.getPointers(containingFile);
        if (refs == null) {
            List<SmartPointerEx> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getStrongPointers"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (PointerReference reference : refs) {
            ContainerUtil.addIfNotNull((Collection)result, reference.get());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getStrongPointers"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointersNumber"));
        }
        Object object = lock;
        synchronized (object) {
            return this.getStrongPointers(containingFile.getViewProvider().getVirtualFile()).size();
        }
    }

    private boolean getAndFasten(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getAndFasten"));
        }
        boolean fastened = this.areBeltsFastened(file);
        file.putUserData(this.POINTERS_ARE_FASTENED_KEY, (Object)Boolean.TRUE);
        return fastened;
    }

    private boolean getAndUnfasten(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getAndUnfasten"));
        }
        boolean fastened = this.areBeltsFastened(file);
        file.putUserData(this.POINTERS_ARE_FASTENED_KEY, null);
        return fastened;
    }

    private boolean areBeltsFastened(VirtualFile file) {
        return file.getUserData(this.POINTERS_ARE_FASTENED_KEY) == Boolean.TRUE;
    }

    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    private static class PointerReference
    extends WeakReference<SmartPointerEx> {
        private final VirtualFile file;
        private final Key<Set<PointerReference>> key;

        public PointerReference(SmartPointerEx<?> pointer, VirtualFile containingFile, ReferenceQueue<SmartPointerEx> queue, Key<Set<PointerReference>> key) {
            super(pointer, queue);
            this.file = containingFile;
            this.key = key;
        }
    }
}

