/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.NamedObjectProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.SimpleProviderBinding;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceRegistrarImpl
extends PsiReferenceRegistrar {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl");
    private final Map<Class, SimpleProviderBinding<PsiReferenceProvider>> myBindingsMap = new THashMap();
    private final Map<Class, NamedObjectProviderBinding<PsiReferenceProvider>> myNamedBindingsMap = new THashMap();
    private final FactoryMap<Class, Class[]> myKnownSupers = new ConcurrentFactoryMap<Class, Class[]>(){

        protected Class[] create(Class key) {
            LinkedHashSet<Class> result = new LinkedHashSet<Class>();
            for (Class candidate : PsiReferenceRegistrarImpl.this.myBindingsMap.keySet()) {
                if (!candidate.isAssignableFrom(key)) continue;
                result.add(candidate);
            }
            for (Class candidate : PsiReferenceRegistrarImpl.this.myNamedBindingsMap.keySet()) {
                if (!candidate.isAssignableFrom(key)) continue;
                result.add(candidate);
            }
            if (result.isEmpty()) {
                return ArrayUtil.EMPTY_CLASS_ARRAY;
            }
            return result.toArray(new Class[result.size()]);
        }
    };
    private boolean myInitialized;

    public void markInitialized() {
        this.myInitialized = true;
    }

    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority) {
        SimpleProviderBinding<Object> providerBinding;
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerReferenceProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerReferenceProvider"));
        }
        if (this.myInitialized && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Reference provider registration is only allowed from PsiReferenceContributor");
        }
        this.myKnownSupers.clear();
        Class scope = pattern.getCondition().getInitialCondition().getAcceptedClass();
        List conditions = pattern.getCondition().getConditions();
        for (PatternCondition _condition : conditions) {
            if (!(_condition instanceof PsiNamePatternCondition)) continue;
            PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)_condition;
            List conditions1 = nameCondition.getNamePattern().getCondition().getConditions();
            for (PatternCondition condition1 : conditions1) {
                if (condition1 instanceof ValuePatternCondition) {
                    Collection strings = ((ValuePatternCondition)condition1).getValues();
                    this.registerNamedReferenceProvider(ArrayUtil.toStringArray((Collection)strings), nameCondition, scope, true, provider, priority, pattern);
                    return;
                }
                if (!(condition1 instanceof CaseInsensitiveValuePatternCondition)) continue;
                String[] strings = ((CaseInsensitiveValuePatternCondition)condition1).getValues();
                this.registerNamedReferenceProvider(strings, nameCondition, scope, false, provider, priority, pattern);
                return;
            }
        }
        if ((providerBinding = this.myBindingsMap.get(scope)) == null) {
            providerBinding = new SimpleProviderBinding();
            this.myBindingsMap.put(scope, providerBinding);
        }
        providerBinding.registerProvider(provider, pattern, priority);
    }

    public void unregisterReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "unregisterReferenceProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "unregisterReferenceProvider"));
        }
        ProviderBinding providerBinding = this.myBindingsMap.get(scope);
        providerBinding.unregisterProvider(provider);
    }

    /*
     * WARNING - void declaration
     */
    private void registerNamedReferenceProvider(@NotNull String[] names, final PsiNamePatternCondition<?> nameCondition, @NotNull Class scopeClass, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority, @NotNull ElementPattern elementPattern) {
        void pattern;
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerNamedReferenceProvider"));
        }
        if (scopeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeClass", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerNamedReferenceProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerNamedReferenceProvider"));
        }
        if (elementPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerNamedReferenceProvider"));
        }
        NamedObjectProviderBinding<PsiReferenceProvider> providerBinding = this.myNamedBindingsMap.get(scopeClass);
        if (providerBinding == null) {
            providerBinding = new NamedObjectProviderBinding<PsiReferenceProvider>(){

                @Override
                protected String getName(PsiElement position) {
                    return nameCondition.getPropertyValue((Object)position);
                }
            };
            this.myNamedBindingsMap.put(scopeClass, providerBinding);
        }
        providerBinding.registerProvider(names, (ElementPattern)pattern, caseSensitive, provider, priority);
    }

    public void registerReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerReferenceProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerReferenceProvider"));
        }
        this.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement((Class)scope), provider, 0.0);
    }

    @NotNull
    List<ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext>> getPairsByElement(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "getPairsByElement"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "getPairsByElement"));
        }
        Class<?> clazz = element.getClass();
        SmartList ret = null;
        for (Class aClass : (Class[])this.myKnownSupers.get(clazz)) {
            SimpleProviderBinding<PsiReferenceProvider> simpleBinding = this.myBindingsMap.get(aClass);
            NamedObjectProviderBinding<PsiReferenceProvider> namedBinding = this.myNamedBindingsMap.get(aClass);
            if (simpleBinding == null && namedBinding == null) continue;
            if (ret == null) {
                ret = new SmartList();
            }
            if (simpleBinding != null) {
                simpleBinding.addAcceptableReferenceProviders(element, (List<ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext>>)ret, hints);
            }
            if (namedBinding == null) continue;
            namedBinding.addAcceptableReferenceProviders(element, (List<ProviderBinding.ProviderInfo<PsiReferenceProvider, ProcessingContext>>)ret, hints);
        }
        List<ProviderBinding.ProviderInfo<Object, Object>> list = ret == null ? Collections.emptyList() : ret;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "getPairsByElement"));
        }
        return list;
    }
}

