/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;

public class EscapeHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public EscapeHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void execute(Editor editor, DataContext dataContext) {
        LookupImpl lookup;
        TemplateState state;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection() && (state = TemplateManagerImpl.getTemplateState(editor)) != null && editor.getUserData(InplaceRefactoring.INPLACE_RENAMER) != null && (lookup = (LookupImpl)LookupManager.getActiveLookup(editor)) != null) {
            selectionModel.removeSelection();
            lookup.hide();
            return;
        }
        this.myOriginalHandler.execute(editor, dataContext);
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState != null && !templateState.isFinished()) {
            return true;
        }
        return this.myOriginalHandler.isEnabled(editor, dataContext);
    }
}

