/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.Disposable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MovablePopup
implements Disposable {
    private final Component myOwner;
    private final Component myContent;
    private Rectangle myViewBounds;
    private Container myView;
    private boolean myAlwaysOnTop;
    private boolean myHeavyWeight;
    private boolean myWindowFocusable;
    private boolean myWindowShadow;

    public MovablePopup(@NotNull Component owner, @NotNull Component content) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ui/popup/MovablePopup", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/popup/MovablePopup", "<init>"));
        }
        this.myOwner = owner;
        this.myContent = content;
        this.myViewBounds = new Rectangle(content.getPreferredSize());
        this.myHeavyWeight = true;
    }

    public void dispose() {
        this.disposeAndUpdate(false);
    }

    public void setAlwaysOnTop(boolean value) {
        if (this.myAlwaysOnTop != value) {
            this.myAlwaysOnTop = value;
            this.disposeAndUpdate(true);
        }
    }

    public void setHeavyWeight(boolean value) {
        if (this.myHeavyWeight != value) {
            this.myHeavyWeight = value;
            this.disposeAndUpdate(true);
        }
    }

    public void setWindowFocusable(boolean value) {
        if (this.myWindowFocusable != value) {
            this.myWindowFocusable = value;
            this.disposeAndUpdate(true);
        }
    }

    public void setWindowShadow(boolean value) {
        if (this.myWindowShadow != value) {
            this.myWindowShadow = value;
            this.disposeAndUpdate(true);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setBounds(x, y, width, height);
        } else {
            this.setBounds(new Point(x, y), new Dimension(width, height));
        }
    }

    public void setLocation(int x, int y) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setLocation(x, y);
        } else {
            this.setBounds(new Point(x, y), null);
        }
    }

    public void setSize(int width, int height) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setSize(width, height);
        } else {
            this.setBounds(null, new Dimension(width, height));
        }
    }

    public void setVisible(boolean visible) {
        if (this.myView != null) {
            this.myView.setVisible(visible);
        } else if (visible) {
            JLayeredPane parent;
            Window owner = UIUtil.getWindow((Component)this.myOwner);
            if (owner != null) {
                if (this.myHeavyWeight) {
                    JWindow view = new JWindow(owner);
                    try {
                        Class<?> type = Class.forName("java.awt.Window$Type");
                        Object value = Enum.valueOf(type, "POPUP");
                        view.getClass().getMethod("setType", type).invoke((Object)view, value);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    if (this.myAlwaysOnTop) {
                        try {
                            view.setAlwaysOnTop(true);
                        }
                        catch (SecurityException ignored) {
                            this.myAlwaysOnTop = false;
                        }
                    }
                    view.setFocusableWindowState(this.myWindowFocusable);
                    if (!this.myWindowShadow) {
                        view.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
                    }
                    this.myView = view;
                } else if (owner instanceof RootPaneContainer && (parent = ((RootPaneContainer)((Object)owner)).getLayeredPane()) != null) {
                    JPanel view = new JPanel(new BorderLayout());
                    view.setVisible(false);
                    parent.add(view, JLayeredPane.POPUP_LAYER, 0);
                    this.myView = view;
                }
            }
            if (this.myView != null) {
                this.myView.add(this.myContent);
                Container container = parent = this.myView instanceof Window ? null : this.myView.getParent();
                if (parent != null) {
                    Point location = this.myViewBounds.getLocation();
                    SwingUtilities.convertPointFromScreen(location, parent);
                    this.myViewBounds.setLocation(location);
                }
                this.myView.setBounds(this.myViewBounds);
                this.myView.setVisible(true);
                this.myViewBounds = null;
            }
        }
    }

    public boolean isVisible() {
        return this.myView != null && this.myView.isVisible();
    }

    private void disposeAndUpdate(boolean update) {
        if (this.myView != null) {
            boolean visible = this.myView.isVisible();
            if (this.myView instanceof Window) {
                this.myViewBounds = this.myView.getBounds();
                Window window = (Window)this.myView;
                window.dispose();
            } else {
                Container parent = this.myView.getParent();
                if (parent == null) {
                    this.myViewBounds = new Rectangle(this.myContent.getPreferredSize());
                } else {
                    this.myViewBounds = new Rectangle(this.myView.getBounds());
                    parent.remove(this.myView);
                    Point point = new Point(this.myViewBounds.x, this.myViewBounds.y);
                    SwingUtilities.convertPointToScreen(point, parent);
                    this.myViewBounds.x = point.x;
                    this.myViewBounds.y = point.y;
                }
            }
            this.myView = null;
            if (update && visible) {
                this.setVisible(true);
            }
        }
    }

    private void setBounds(Point location, Dimension size) {
        if (this.myView != null) {
            if (size == null) {
                size = this.myView.getSize();
            }
            if (location == null) {
                location = this.myView.getLocation();
            } else {
                Container parent;
                Container container = parent = this.myView instanceof Window ? null : this.myView.getParent();
                if (parent != null) {
                    SwingUtilities.convertPointFromScreen(location, parent);
                }
            }
            this.myView.setBounds(location.x, location.y, size.width, size.height);
            if (this.myView.isVisible()) {
                this.myView.invalidate();
                this.myView.validate();
                this.myView.repaint();
            }
        }
    }
}

