/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsCommitCache;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataGetter<T extends VcsShortCommitDetails>
implements Disposable {
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    private static final int MAX_LOADING_TASKS = 10;
    @NotNull
    protected final VcsLogDataHolder myDataHolder;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final VcsCommitCache<Integer, T> myCache;
    @NotNull
    private final SequentialLimitedLifoExecutor<TaskDescriptor> myLoader;
    private long myCurrentTaskIndex;
    @NotNull
    private final Collection<Runnable> myLoadingFinishedListeners;

    DataGetter(@NotNull VcsLogDataHolder dataHolder, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsCommitCache<Integer, T> cache) {
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/data/DataGetter", "<init>"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/DataGetter", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/vcs/log/data/DataGetter", "<init>"));
        }
        this.myCurrentTaskIndex = 0L;
        this.myLoadingFinishedListeners = new ArrayList<Runnable>();
        this.myDataHolder = dataHolder;
        this.myLogProviders = logProviders;
        this.myCache = cache;
        Disposer.register((Disposable)dataHolder, (Disposable)this);
        this.myLoader = new SequentialLimitedLifoExecutor<TaskDescriptor>(this, 10, new ThrowableConsumer<TaskDescriptor, VcsException>(){

            public void consume(TaskDescriptor task) throws VcsException {
                DataGetter.this.preLoadCommitData((MultiMap<VirtualFile, Integer>)task.myCommits);
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (Runnable loadingFinishedListener : DataGetter.this.myLoadingFinishedListeners) {
                            loadingFinishedListener.run();
                        }
                    }
                });
            }
        });
    }

    public void dispose() {
        this.myLoadingFinishedListeners.clear();
    }

    @Nullable
    public T getCommitData(int row, @NotNull GraphTableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/vcs/log/data/DataGetter", "getCommitData"));
        }
        assert (EventQueue.isDispatchThread());
        Integer hash = tableModel.getCommitIdAtRow(row);
        T details = this.getFromCache(hash);
        if (details != null) {
            return details;
        }
        this.runLoadAroundCommitData(row, tableModel);
        return this.myCache.get(hash);
    }

    @Nullable
    public T getCommitDataIfAvailable(int hash) {
        return this.getFromCache(hash);
    }

    @Nullable
    private T getFromCache(@NotNull Integer commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/data/DataGetter", "getFromCache"));
        }
        T details = this.myCache.get(commitId);
        if (details != null) {
            if (details instanceof LoadingDetails && ((LoadingDetails)details).getLoadingTaskIndex() <= this.myCurrentTaskIndex - 10L) {
                this.myCache.remove(commitId);
                return null;
            }
            return details;
        }
        return this.getFromAdditionalCache(commitId);
    }

    @Nullable
    protected abstract T getFromAdditionalCache(int var1);

    private void runLoadAroundCommitData(int row, @NotNull GraphTableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/vcs/log/data/DataGetter", "runLoadAroundCommitData"));
        }
        long taskNumber = this.myCurrentTaskIndex++;
        MultiMap<VirtualFile, Integer> commits = DataGetter.getCommitsAround(row, tableModel, 20, 40);
        for (Map.Entry hashesByRoots : commits.entrySet()) {
            VirtualFile root = (VirtualFile)hashesByRoots.getKey();
            Collection hashes = (Collection)hashesByRoots.getValue();
            Iterator i$ = hashes.iterator();
            while (i$.hasNext()) {
                int commitId = (Integer)i$.next();
                if (this.myCache.isKeyCached(commitId)) continue;
                this.myCache.put(commitId, new LoadingDetails(this.myDataHolder.getHash(commitId), taskNumber, root));
            }
        }
        TaskDescriptor task = new TaskDescriptor(commits);
        this.myLoader.queue(task);
    }

    @NotNull
    private static MultiMap<VirtualFile, Integer> getCommitsAround(int selectedRow, @NotNull GraphTableModel model, int above, int below) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/vcs/log/data/DataGetter", "getCommitsAround"));
        }
        MultiMap commits = MultiMap.create();
        for (int row = Math.max(0, selectedRow - above); row < selectedRow + below && row < model.getRowCount(); ++row) {
            Integer hash = model.getCommitIdAtRow(row);
            VirtualFile root = model.getRoot(row);
            commits.putValue((Object)root, (Object)hash);
        }
        MultiMap multiMap = commits;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataGetter", "getCommitsAround"));
        }
        return multiMap;
    }

    private void preLoadCommitData(@NotNull MultiMap<VirtualFile, Integer> commits) throws VcsException {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/DataGetter", "preLoadCommitData"));
        }
        for (Map.Entry entry : commits.entrySet()) {
            List hashStrings = ContainerUtil.map((Collection)((Collection)entry.getValue()), (Function)new Function<Integer, String>(){

                public String fun(Integer commitId) {
                    return DataGetter.this.myDataHolder.getHash(commitId).asString();
                }
            });
            List<T> details = this.readDetails(this.myLogProviders.get(entry.getKey()), (VirtualFile)entry.getKey(), hashStrings);
            this.saveInCache(details);
        }
    }

    public void saveInCache(final List<? extends T> details) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                for (VcsShortCommitDetails data : details) {
                    DataGetter.this.myCache.put(DataGetter.this.myDataHolder.getCommitIndex((Hash)data.getId()), data);
                }
            }
        });
    }

    @NotNull
    protected abstract List<? extends T> readDetails(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull List<String> var3) throws VcsException;

    public void addDetailsLoadedListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/data/DataGetter", "addDetailsLoadedListener"));
        }
        this.myLoadingFinishedListeners.add(runnable);
    }

    private static class TaskDescriptor {
        private final MultiMap<VirtualFile, Integer> myCommits;

        private TaskDescriptor(MultiMap<VirtualFile, Integer> commits) {
            this.myCommits = commits;
        }
    }
}

